var PicUpload= {
	fileInput: null,				//html file控件
	dragDrop: null,					//拖拽敏感区域
	upButton: null,					//提交按钮
	url: "",						//ajax地址
	formId : "",					//#+表单id
	fileFilter: [],					//过滤后的文件数组
	filter: function(files) {		//选择文件组的过滤方法
		return files;
	},
	
	onSelect: function(files) {
		var html = '', i = 0;
		//openMessage(msgType.loading);
		var funAppendImage = function() {
			file = files[i];
			if (file) {
				var reader = new FileReader()
				reader.onload = function(e) {
					html = html + '<div id="uploadList_'+ i +'" class="upload_append_list">'
								+'<label class="upload_append_filename" title="' + file.name + '">' + file.name + '</label>' 
								+'<span id="uploadProgress_' + i + '" class="upload_progress"></span>'
								+'<a href="javascript:" class="upload_delete" data-index="'+ i +'">'
								+'<img src="/base/images/del.png" /></a><br />'
								+'</div>';
					
					i++;
					funAppendImage();
				}
				reader.readAsDataURL(file);
			} else {
				//closeMessage(100);
				$("#preview").html(html);
				if (html) {
					//删除方法
					$(".upload_delete").click(function() {
						PicUpload.funDeleteFile(files[parseInt($(this).attr("data-index"))]);
						return false;	
					});
					//提交按钮显示
					$("#confirmButton").attr("disabled", false);	
				} else {
					//提交按钮隐藏
					$("#confirmButton").attr("disabled", true);
				}
			}
		};
		funAppendImage();		
	},
	onDelete: function(file) {
		$("#uploadList_" + file.index).fadeOut();
		$("#"+this.formId)[0].reset();
		if (this.fileFilter.length <= 1)
		{
			$("#confirmButton").attr("disabled", true);
		}
	},
	onDragOver: function() {
		$(this).addClass("upload_drag_hover");
	},
	onDragLeave: function() {
		$(this).removeClass("upload_drag_hover");
	},
	onProgress: function(file, loaded, total) {
		var eleProgress = $("#uploadProgress_" + file.index), percent = (loaded / total * 100).toFixed(2) + '%';
		eleProgress.show().html(percent);
	},
	onSuccess: function(file, response) {
		//$("#uploadInf").append("<p>上传成功，图片地址是：" + response + "</p>");
	},
	onFailure: function(file) {
		$("#uploadProgress_" + file.index).text("${common_prompt_wrong}");
		//$("#uploadInf").append("<p>图片" + file.name + "上传失败！</p>"); 	
		$("#uploadImage_" + file.index).css("opacity", 0.2);
	},
	onComplete: function(data) {
		closeMessage();
		var self = this;
		messageBox({messageType: "alert", title: "${common_prompt_title}", text: data, callback:function(){
			if (!self.fileFilter.length > 0)
			{
				closeWindow();
				reloadGrid();
			}
		}});
	},
	
	/* 开发参数和内置方法分界线 */
	
	//文件拖放
	funDragHover: function(e) {
		e.stopPropagation();
		e.preventDefault();
		this[e.type === "dragover"? "onDragOver": "onDragLeave"].call(e.target);
		return this;
	},
	//获取选择文件，file控件或拖放
	funGetFiles: function(e) {
		// 取消鼠标经过样式
		this.funDragHover(e);
				
		// 获取文件列表对象
		var files = e.target.files || e.dataTransfer.files;
		//继续添加文件
		this.fileFilter = this.fileFilter.concat(this.filter(files));
		this.funDealFiles();
		return this;
	},
	
	//选中文件的处理与回调
	funDealFiles: function() {
		for (var i = 0, file; file = this.fileFilter[i]; i++) {
			//增加唯一索引值
			file.index = i;
		}
		//执行选择回调
		this.onSelect(this.fileFilter);
		return this;
	},
	
	//删除对应的文件
	funDeleteFile: function(fileDelete) {
		var arrFile = [];
		for (var i = 0, file; file = this.fileFilter[i]; i++) 
		{
			if (file != fileDelete) 
			{
				arrFile.push(file);
			}
			else 
			{
				this.onDelete(fileDelete);	
			}
		}
		this.fileFilter = arrFile;
		return this;
	},
	//删除范围内的文件
	funDeleteRangeFile: function(range) {
		var arrFile = [];
		for (var i = range, file; file = this.fileFilter[i]; i++) 
		{
			arrFile.push(file);
		}
		this.fileFilter = arrFile;
		this.onSelect(this.fileFilter);
		return this;
	},
	
	//文件上传
	funUploadFile: function() {
		var self = this;	
		//for (var i = 0, file; file = this.fileFilter[i]; i++) {
			(function(file) {
				var xhr = new XMLHttpRequest();
				if (xhr.upload) {
					// 上传中
					xhr.upload.addEventListener("progress", function(e) {
						self.onProgress(file, e.loaded, e.total);
					}, false);
		
					// 文件上传成功或是失败
					xhr.onreadystatechange = function(e) {
						debugger;
						if (xhr.readyState == 4) {
							if (xhr.status == 200) 
							{
								var data = eval("("+eval("("+xhr.response+")").data+")");
								//self.onSuccess(file, xhr.responseText);
								self.funDeleteRangeFile(data.succ);
								if (!self.fileFilter.length) {
									//全部完毕
									self.onComplete(data.info);
								}
							} else {
								self.onFailure(file, xhr.responseText);
							}
						}
					};
		
					// 开始上传
					xhr.open("POST", self.url, false);
					var formData = new FormData();
					for (var i = 0, file; file = self.fileFilter[i]; i++)
					{
						formData.append("files["+i+"]", file);
					}
					formData.append("type", $("#uploadPicType").val());
					xhr.send(formData);
					openMessage(msgType.loading);
				}	
			})(file);
	//	}	
			
	},
	
	init: function() {
		var self = this;
		
		if (this.dragDrop) {
			this.dragDrop.addEventListener("dragover", function(e) { self.funDragHover(e); }, false);
			this.dragDrop.addEventListener("dragleave", function(e) { self.funDragHover(e); }, false);
			this.dragDrop.addEventListener("drop", function(e) { self.funGetFiles(e); }, false);
		}
		
		//文件选择控件选择
		if (this.fileInput) {
			this.fileInput.addEventListener("change", function(e) { self.funGetFiles(e); }, false);	
		}
		
		//上传按钮提交
		if (this.upButton) {
			this.upButton.addEventListener("click", function(e) { self.funUploadFile(e); }, false);	
		} 
	}
};
