changeMachineType();
changeCachType();
changeCashMode();

$("#ipv4_1").attr("disabled",true);
$("#ipv4_2").attr("disabled",true);
$("#ipv4_3").attr("disabled",true);
$("#ipv4_4").attr("disabled",true);


$("#ipv4_4").keyup(function()
{
    $("#idIPAddress").attr("value", ipv4.getValue());
    $("#idIPAddress").valid();
});

//ip不为空验证
jQuery.validator.addMethod("ipAddressValid", function(value, element)
{
	var ipv4_1 = $("#ipv4_1").val();
	var ipv4_2 = $("#ipv4_2").val();
	var ipv4_3 = $("#ipv4_3").val();
	var ipv4_4 = $("#ipv4_4").val();
	
	if (ipv4_1 == "" || ipv4_2 == "" || ipv4_3 == "" || ipv4_4 == "")
	{
		$("#ipInput #ipv4").css('border','1px solid red');
		return false;
	}
	else
	{
		$("#ipInput #ipv4").css('border','1px solid #c3c2c2');
		return true;
	}
	
}, "<@i18n 'common_jqMsg_required!'/>");//IP字段不能为空！

jQuery.validator.addMethod("comma", function(value, element){
	var isIncludeComma = true;//是否包含逗号
	//判断姓名中是否包含逗号
	if(new RegExp(",").test(value))
	{
		isIncludeComma = false;
	}
	return isIncludeComma;
},function(){
	return  "<@i18n 'common_prompt_noComma'/>";
});

jQuery.validator.addMethod("validInteger", function(value, element)
{
	var pattenChar = /^([1-9]\d|\d)$/;
	return this.optional(element) || (pattenChar.test(value));
}, function()
{
	return "<@i18n 'posid_alert_sale'/>";
});

jQuery.validator.addMethod("maxNumber", function(value, element)
{
	var returnVal = true;
	inputZ = value;
	var ArrMen = inputZ.split(".");
	if (ArrMen.length == 2)
	{
		if (ArrMen[1].length > 2)
		{
			returnVal = false;
			return false;
		}
	}
	var vzNum = parseFloat(inputZ).toFixed(2);
	if (isNaN(vzNum))
	{
		returnVal = false;
		return false;
	}
	var ele = parseFloat('999.99');
	if (ele < parseFloat(vzNum)||parseFloat(vzNum)<=0)
	{
		returnVal = false;
		return false;
	}      
	return returnVal;      
},"<@i18n 'posid_keyValue_moneyCheck'/>");

//改变设备用途事件
function changeMachineType()
{
	var machineType = $("#idMachineType").val();
	if(machineType == "0")  //消费机
	{
		$(".trSubsidyHidden").hide();
		$(".trCashierHidden").hide();
		$(".trRecharge").hide();
		$(".trFixMode").hide();
		$(".trConsumerHidden").show();
		$(".checkOperate").show();
		$(".checkWhiteList").show();
		$("#idCachType").rules("remove");
		$("#idCashMode").rules("remove");
		$("#idFavorable").rules("remove");
		$("#idMaxAmount").rules("remove");
		$("#idFixAmount").rules("remove");
		$("#idFavorable").rules("remove");
		$("#idFixAmount").rules("add", {required: true, min: 0,valitTimePrice:true,maxNumber:true});
		$("#idTimePrice").rules("add", {required: true, min: 0,valitTimePrice:true,maxNumber:true});
		$("#idLongTime").rules("add", {required: true, digits:true,range:[1,59]});
		if(doubleCash==2){
			$(".doubleShow").show();
		}
		changeSel();
	}
	else if(machineType == "1") //出纳机
	{
		$(".trConsumerHidden").hide();
		$(".trSubsidyHidden").hide();
		$(".trTimingModeHidden").hide();
		$(".trFixModeHidden").hide();
		$(".trCashierHidden").show();
		$(".checkOperate").show();
		$(".checkWhiteList").show();
		$(".trRecharge").show();
		$(".trFixMode").show();
		$("#idCachType").rules("add", {required: true});
		$("#idCashMode").rules("add", {required: true});
		$("#idFavorable").rules("add", {required: true,validInteger:true});
		$("#idMaxAmount").rules("add", {required: true, min: 0,valitTimePrice:true,validMaxMoney:true});
		$("#idFixAmount").rules("add", {required: true, min: 0,valitTimePrice:true,maxNumber:true});
		$("#idTimePrice").rules("remove");
		$("#idLongTime").rules("remove");
		changeCachType();
		changeCashMode();
	}
	else if(machineType == "2") //补贴机
	{
		$(".trConsumerHidden").hide();
		$(".trCashierHidden").hide();
		$(".trRecharge").hide();
		$(".trFixMode").hide();
		$(".trFixModeHidden").hide();
		$(".trTimingModeHidden").hide();
		$(".trSubsidyHidden").show();
		$(".checkOperate").hide();
		$(".checkWhiteList").hide();
		$("#idCachType").rules("remove");
		$("#idCashMode").rules("remove");
		$("#idFavorable").rules("remove");
		$("#idMaxAmount").rules("remove");
		$("#idFixAmount").rules("remove");
		$("#idTimePrice").rules("remove");
		$("#idLongTime").rules("remove");
	}
}

//改变出纳类型事件
function changeCachType()
{
	var machineType = $("#idMachineType").val();
	var cashType = $("#idCachType").val();
	if(machineType == "1")
	{
		if(cashType == "1") //充值
		{
			$(".trRecharge").show();
			$("#idFavorable").rules("add", {required: true,validInteger:true});
			$("#idMaxAmount").rules("add", {required: true, min: 0,valitTimePrice:true,validMaxMoney:true});
		}
		else //退款
		{
			$("#idFavorable").rules("remove");
			$("#idMaxAmount").rules("remove");
			$(".trRecharge").hide();
		}
	}
}

//改变出纳模式事件
function changeCashMode()
{
	var machineType = $("#idMachineType").val();
	var cashMode = $("#idCashMode").val();
	if(machineType == "1")
	{
		if(cashMode == "1") //定值模式
		{
			$(".trFixMode").show();
			$("#idFixAmount").rules("add", {required: true, min: 0,valitTimePrice:true,maxNumber:true});
		}
		else //金额模式
		{
			$(".trFixMode").hide();
			$("#idFixAmount").rules("remove");
		}
	}
}

//CheckBox点击事件
function changeVal(id)
{
   if($(id).is(":checked"))
   {
       $(id).val(true);
   }
   else
   {
       $(id).val(false);
   }
}

jQuery.validator.addMethod("valitTimePrice", function(value, element){ //金钱的约束
	var pattenChar = /(^[1-9]([0-9]+)?(\.[0-9]{1,2})?$)|(^(0){1}$)|(^[0-9]\.[0-9]([0-9])?$)/;
	return this.optional(element) || (pattenChar.test(value));
}, function(){
return "<@i18n 'posid_alert_money'/>";
});


//消费机消费模式切换事件
function changeSel()
{
	var modeVal = $("#idConsumeMode").val();
	if(modeVal == "1")
	{
		$(".trFixModeHidden").show();
		$(".trTimingModeHidden").hide();
		var fixType=$('input:radio[name="fixModeRadio"]:checked').val();
		if(fixType == "1")
		{
			$(".trFixMode").show();
			$("#idFixAmount").rules("add", {required: true, min: 0,valitTimePrice:true,maxNumber:true});
			$("#idTimePrice").rules("remove");
			$("#idLongTime").rules("remove");
		}
		else
		{
			$("#idFixAmount").rules("remove");
			$(".trFixMode").hide();
			$("#idTimePrice").rules("remove");
			$("#idLongTime").rules("remove");
		}
	}
	else if(modeVal == "6")
	{
		$("#idTimePrice").rules("add", {required: true, min: 0,valitTimePrice:true,maxNumber:true});
		$("#idLongTime").rules("add", {required: true, digits:true,range:[1,59]});
		$("#idFixAmount").rules("remove");
		$(".trFixModeHidden").hide();
		$(".trTimingModeHidden").show();
		$(".trFixMode").hide();
		
	}
	else
	{
		$("#idTimePrice").rules("remove");
		$("#idLongTime").rules("remove");
		$("#idFixAmount").rules("remove");
		$(".trFixModeHidden").hide();
		$(".trTimingModeHidden").hide();
		$(".trFixMode").hide();
	}
}

//消费机定值模式：定值或者分段定值单选切换事件
function getRadio()
{
    var fixType=$('input:radio[name="fixModeRadio"]:checked').val();
    if(fixType == "1")
    {
      $(".trFixMode").show();
      $("#idFixAmount").rules("add", {required: true, min: 0,valitTimePrice:true,maxNumber:true});
    }
    else
    {
      $("#idFixAmount").val('');
      $("#idFixAmount").rules("remove");
      $(".trFixMode").hide();
    }
}

function isFixAmountBiggerThanMaxAmount()
{
	var maxAmount = $("#idMaxAmount").val();
	var fixAmount = $("#idFixAmount").val();
	
	if(fixAmount != '' && maxAmount != '' && Number(fixAmount) > Number(maxAmount))
	{
		openMessage(msgType.info, "<@i18n 'posid_dev_fixAmountBiggerThanMaxAmount'/>",1000);
		return;
	}
}

function loadPosGrid(devId)
{
	loadGrid("pos", "posDevSplitTime", "gridSplitTime", null, null, null,function(){resizeGird("gridSplitTime");} , "&devId="+devId, "posDevSplitTime");
	loadGrid("pos", "posDevIcCard", "gridIcCard", null, null, null, function(){resizeGird("gridIcCard");}, "&devId="+devId, "posDevIcCard");
	loadGrid("pos", "posDevKeyValue", "gridKeyValue", null, null, null, function(){resizeGird("gridKeyValue");}, null, "posDevKeyValue");
}
