function sendCmd(ret){
	var retJson;
	var sendData = ret.data.url;
	var keyWord = ret.data.keyWord;
	var timeStamp = new Date().getTime();
	sendData = rc4encrypt(sendData, keyWord+"-"+timeStamp);
	ZKDevice.get(ZKDevType.PosHelper).PosHelper({
		dataType:'json',
		type:"post",
		timeout:1000,
		async:false,
		data:{
			"CardSender": "CR10MW",
			"DATA": sendData.toUpperCase(),
			"SESSION": timeStamp
		},
		callback:function(data){
			retJson = data;
			/* console.log(data); */
		},
		errorback:function(){
			
		}
	});
	return retJson;
}

function getFinalData(methodName,ajaxData)
{
	var finalData='';
	$.ajax({
		url:methodName,
		async:false,
		dataType:'json',
		type:'post',
		data:ajaxData,
		success:function(data){
			finalData = data;
		}
	});
	return finalData;
}

function readCardInfo(methodName,ajaxData)
{
	var dataInfo;
	var cardInfo = sendCmd(getFinalData(methodName,ajaxData));
	if(cardInfo!=undefined && cardInfo.ret==0)
	{
		$.ajax({
			type : "POST",
			url : "posIDAccount.do?loadCard",
			dataType : "json",
			data : cardInfo.data,
			async : false,
			success : function(data){
				dataInfo=data;
			}
		});
	}
	else
	{
		var ret = cardInfo==undefined?"1":cardInfo.ret;
		openMessage(msgType.error, errorMessage(ret));
	}
	return dataInfo;
}

function errorMessage(ret){
    return I18n.getValue("posid_error_message_" + ret);
}

//同步软件数据到设备
function cardManage(id, callbackFun)
{
	var opStr = isCheckbox(id);
	var ids = opStr.substring(opStr.indexOf("ids=")+4);
	var idArr = ids.split(",");
	if(idArr.length > 1) {
		messageBox({messageType:"alert",text: "只能选择一个对象进行操作"});
		return false;
	} else {
		executeOperate(id, callbackFun);
	}
}

function isCheckbox(id) {
	
	var opStr = id.split("^")[0];
	if(id.indexOf("]") > 0)
	{
		operateObjId = id.substring(1,id.indexOf("]"));
		opStr = id.substring(id.indexOf("]")+1);
	}
	else
	{
		operateObjId = "operate";
	}
	
	var idNum = 0;
	var itemText = ""; 
	var gridName = null;
	if(id.indexOf("(id")>0)//判断是否是grid复选
	{
		var checkboxName;
		var idStr = "(id)";
		var selectedNum = 0;
		var conditionMode = "==";
		var noSelectPrompt = "请选择你要操作的对象！";
		var noRightSelectPrompt = "只能选择一个对象进行操作";
		var split = ",";
		var isOnline = false;
		if(id.indexOf("(id*")>0)//这里是判断是否存在提示信息参数
		{
			//(id*{checkboxName:'ids',selectedNum:1,conditionMode:'!=',noSelectPrompt:'请选择你要操作的角色',noRightSelectPrompt:'只能选择一个操作的角色',split:','})
			var opParamStr = id.substring(id.indexOf("(id*") + "(id*".length, id.lastIndexOf(")"));
			var opParams = eval("(" + opParamStr + ")");
			
			checkboxName = opParams.checkboxName ? opParams.checkboxName : checkboxName;
			
			selectedNum = opParams.selectedNum != undefined ? opParams.selectedNum : selectedNum;
			
			conditionMode = opParams.conditionMode ? opParams.conditionMode : conditionMode;
			noSelectPrompt = opParams.noSelectPrompt ? opParams.noSelectPrompt : noSelectPrompt;
			noRightSelectPrompt = opParams.noRightSelectPrompt ? opParams.noRightSelectPrompt : noRightSelectPrompt;
			isOnline = opParams.isOnline ? opParams.isOnline : isOnline ;
			split = opParams.split ? opParams.split : split;
			gridName = opParams.gridName ? opParams.gridName : gridName;

			idStr = id.substring(id.indexOf("(id*"), id.lastIndexOf(")")+1);
			
		}
		var checkboxVlaues = getGridCheckboxValue(checkboxName, split);
		if(checkboxVlaues == "")
		{
			messageBox({messageType:"alert",text: noSelectPrompt});
			return;
		}
		else
		{
			idNum = checkboxVlaues.split(split).length;

			switch (conditionMode)
			{
				case "!=":
					if(idNum != selectedNum)
					{
						messageBox({messageType:"alert",text: noRightSelectPrompt});
						return;
					}
					break;
				case "==":
					if(idNum == selectedNum)
					{
						messageBox({messageType:"alert",text: noRightSelectPrompt});
						return;
					}
					break;
				case ">":
					if(idNum > selectedNum)
					{
						messageBox({messageType:"alert",text: noRightSelectPrompt});
						return;
					}
					break;
				case ">=":
					if(idNum >= selectedNum)
					{
						messageBox({messageType:"alert",text: noRightSelectPrompt});
						return;
					}
					break;
				case "<":
					if(idNum < selectedNum)
					{
						messageBox({messageType:"alert",text: noRightSelectPrompt});
						return;
					}
					break;
				case "<=":
					if(idNum >= selectedNum)
					{
						messageBox({messageType:"alert",text: noRightSelectPrompt});
						return;
					}
					break;
				default:
					messageBox({messageType:"alert",text: "条件运算符不合法"});
					return;
					break;
			}
		}
		opStr = opStr.replace(idStr, checkboxVlaues);
	}
	else if(id.indexOf("(select") > 0)
	{
		var opParamStr = id.substring(id.indexOf("(select") + "(select".length + 1, id.lastIndexOf(")"));
		var val = $("input:hidden[name='"+opParamStr+"']").val();
		opStr = id.substring(0, id.indexOf("custom=") + "custom=".length) + (val == undefined ? "" : val);
	}
	return opStr;
}

function executeOperateByCells(id)
{
	messageBox({
	    messageType : "confirm",
	    text : msg,
	});
}


function strToHexCharCode(str) {
	var hexCharCode = [];
	for(var i = 0; i < str.length; i++) {
		hexCharCode.push((str.charCodeAt(i)).toString(16));
	}
	return hexCharCode.join("");
}
	
	function strToByteArr(str) {
		var bytes = [];
		for (var i = 0; i < str.length; ++i) {
		    bytes.push(str.charCodeAt(i));
		}
		return bytes;
	}
	
	 function byteToString(arr) {  
	        if(typeof arr === 'string') {  
	            return arr;  
	        }  
	        var str = '',  
	            _arr = arr;  
	        for(var i = 0; i < _arr.length; i++) {  
	            var one = _arr[i].toString(2),  
	                v = one.match(/^1+?(?=0)/);  
	            if(v && one.length == 8) {  
	                var bytesLength = v[0].length;  
	                var store = _arr[i].toString(2).slice(7 - bytesLength);  
	                for(var st = 1; st < bytesLength; st++) {  
	                    store += _arr[st + i].toString(2).slice(2);  
	                }  
	                str += String.fromCharCode(parseInt(store, 2));  
	                i += bytesLength - 1;  
	            } else {  
	                str += String.fromCharCode(_arr[i]);  
	            }  
	        }  
	        return str;  
	    }  
	
	function rc4encrypt(base64,mKkey){
		var encrypt = strToByteArr(base64);
		 var x = 0;
	     var y = 0;
	     var key = initKey(mKkey);
	     var xorIndex; 
	     var result = Array(encrypt.length);
	     
	     var str = "";
	     
	     for (var i = 0; i < encrypt.length; i++) {
	            x = (x + 1) & 0xff;
	            y = ((key[x] & 0xff) + y) & 0xff;
	            var tmp = key[x];
	            key[x] = key[y];
	            key[y] = tmp;
	            xorIndex = ((key[x] & 0xff) + (key[y] & 0xff)) & 0xff;
	            var aa = encrypt[i] ^ key[xorIndex];
	             if(aa<0){
	            	aa = aa + 256;
	            }
	            aa = aa.toString(16);
	           
	            if(aa.length==1){
	            	aa = "0"+aa;
	            }
	            str += aa;
	      }
	     return str;
	}
	
	function initKey(aKey) {
        var b_key = strToByteArr(aKey);
        var state = Array(256);

        for (var i = 0; i < 256; i++) {
        	var aa = i;
        	if(i>127){
        		aa = i-256;
        	}
            state[i] = aa;
        }
        var index1 = 0;
        var index2 = 0;
        
        for (var i = 0; i < 256; i++) {
            index2 = ((b_key[index1] & 0xff) + (state[i] & 0xff) + index2) & 0xff;
            var tmp = state[i];
            state[i] = state[index2];
            state[index2] = tmp;
            index1 = (index1 + 1) % b_key.length;
        }
        return state;
    }