﻿
$(function () {
    // 设置电子地图;
    setMap();
    // 获取设备状态
    getDevStateData();
    // 获取安检门数据
    getDoardGateDate();
    // 获取安检机过包数据
    getDoardPackageDate();
    // 获取安检机报警事件类型数据
    getDoardWarningPackageDate();
    I18n.load([
        "sis_home_page_unit",
        "sis_home_page_package_sum",
        "sis_home_page_package_alarm_sum",
        "sis_home_page_gate_sum",
        "sis_home_page_state_off_line",
        "sis_home_page_state_on_line"
    ], true);
    var echarts5Array = [];
    echarts5Array.push(I18n.getValue("sis_home_page_package_sum"));
    echarts5Array.push(I18n.getValue("sis_home_page_package_alarm_sum"));

    var echarts1Array = [];
    echarts1Array.push(I18n.getValue("sis_home_page_gate_sum"));
    echarts1Array.push(I18n.getValue("sis_home_page_package_alarm_sum"));

    getVidDevStateData();

    window.setInterval(function(){
        getVidDevStateData();
    }, 60000);

    var devStateData = [];
    var sum = 0;
    var gateData = [];
    var gateOnLineCount = 0;
    var gateOnLineRatio = 0;

    var gateOffData = [];
    var gateOffLineCount = 0;
    var gateOffLineRatio = 0;

    var personArray = [];
    var alarmArray = [];
    var areaArray = [];

    var packageCountArray = [];
    var packageAlarmCountArray = [];
    var packageAreaArray = [];

    var typeArray = [];
    var countArray = [];

    var divStateData = [];
    var divSumCount = 0;

    function initDevStateSocket() {
        var clientId = Math.round(Math.random() * 10000)+"${uuid!}";
        var devClient = Web.getSocket({
            id : "devClient",
            url : "sisRTMonitor/getDeviceState",
            param:JSON.stringify({"clientId" : clientId}),
            onMessage:function(resp) {
               var devData = JSON.parse(resp.body);
                devStateData = devData.data;
                sum = devData.sum.sumCount + " " + I18n.getValue("sis_home_page_unit");
                echarts_4();
                setMap();
            }
        });
        return devClient;
    }
    var devClient = initDevStateSocket();

    function initGateDateDoardSocket() {
        var clientId = Math.round(Math.random() * 10000)+"${uuid!}";
        var gateDateClient = Web.getSocket({
            id : "gateDateClient",
            url : "sisRTMonitor/getGateDateDoard",
            param:JSON.stringify({"clientId" : clientId}),
            onMessage:function(resp) {
                var data = JSON.parse(resp.body);
                personArray = data.personArray;
                alarmArray = data.alarmArray;
                areaArray = data.areaArray;
                echarts_1();
            }
        });
        return gateDateClient;
    }
    var gateDateClient = initGateDateDoardSocket();

    function initGateStateSocket() {
        var clientId = Math.round(Math.random() * 10000)+"${uuid!}";
        var gateClient = Web.getSocket({
            id : "gateClient",
            url : "sisRTMonitor/getGateState",
            param:JSON.stringify({"clientId" : clientId}),
            onMessage:function(resp) {
                var data = JSON.parse(resp.body);
                gateData = data.gateOnLineData;
                gateOnLineCount = data.gateOnLineCount;
                gateOnLineRatio = data.gateOnLineRatio;

                gateOffData = data.gateOffLineData;
                gateOffLineCount = data.gateOffLineCount;
                gateOffLineRatio = data.gateOffLineRatio;
                echarts_31();
                // echarts_32();
                echarts_33();
            }
        });
        return gateClient;
    }
    var gateClient = initGateStateSocket();

    function getDevStateData() {
        $.ajax({
            url:"/sisDevice.do?getDevStateData",
            type:"post",
            success:function(data) {
                debugger;
                devStateData = data.data.data;
                sum = data.data.sum.sumCount + " " + I18n.getValue("sis_home_page_unit");
                echarts_4();
                gateData = data.data.gate.gateOnLineData;
                gateOnLineCount = data.data.gate.gateOnLineCount;
                gateOnLineRatio = data.data.gate.gateOnLineRatio;

                gateOffData = data.data.gate.gateOffLineData;
                gateOffLineCount = data.data.gate.gateOffLineCount;
                gateOffLineRatio = data.data.gate.gateOffLineRatio;
                echarts_31();
                // echarts_32();
                echarts_33();
            }
        });
    }

    function getDoardGateDate() {
        $.ajax({
            url:"/sisGazeTransaction.do?getAlarmGateDate",
            type:"post",
            success:function(data) {
                personArray = data.data.personArray;
                alarmArray = data.data.alarmArray;
                areaArray = data.data.areaArray;
                echarts_1();
            }
        });
    }

    function getDoardPackageDate() {
        $.ajax({
            url:"/sisPackageTransaction.do/getDevicePackageDate",
            type:"post",
            success:function(data) {
                packageCountArray = data.data.packageCountArray;
                packageAlarmCountArray = data.data.packageAlarmCountArray;
                packageAreaArray = data.data.packageAreaArray;
                echarts_5();
            }
        });
    }

    function getDoardWarningPackageDate() {
        $.ajax({
            url:"/sisPackageTransaction.do/getDeviceWarningPackageDate",
            type:"post",
            success:function(data) {
                typeArray = data.data.typeArray;
                countArray = data.data.countArray;
                echarts_6();
            }
        });
    }

    function getVidDevStateData() {
        $.ajax({
            url:"/sisDevice.do?getVidDevStateData",
            type:"post",
            success:function(data) {
                divStateData = data.data.data;
                divSumCount = data.data.sum + " " + I18n.getValue("sis_home_page_unit");
                echarts_2();
            }
        });
    }

    function initDoardPackageDateSocket() {
        var clientId = Math.round(Math.random() * 10000)+"${uuid!}";
        var doardPackageClient = Web.getSocket({
            id : "doardPackageClient",
            url : "sisRTMonitor/getDoardPackageDate",
            param:JSON.stringify({"clientId" : clientId}),
            onMessage:function(resp) {
                var data = JSON.parse(resp.body);
                packageCountArray = data.packageCountArray;
                packageAlarmCountArray = data.packageAlarmCountArray;
                packageAreaArray = data.packageAreaArray;
                echarts_5();
            }
        });
        return doardPackageClient;
    }
    var doardPackageClient = initDoardPackageDateSocket();

    function setMap() {
        //区域地图树加载完之后，回调函数，用于加载右边地图
        // var getMapUrl = "/sisMap.do?setMap";
        // setMapRightHtmlByPath(getMapUrl,"map_1");
        $.ajax({
            url:"/sisMap.do?getDoardMap",
            type:"post",
            success:function(data) {
                if (data.data != null) {
                    var width = $("#map_1").width();
                    var height = $("#map_1").height();
                    var posList = data.data.posList;
                    var path = data.data.path;
                    var imgWidth = data.data.imgWidth;
                    var imgHeight = data.data.imgHeight;

                    var divWidth;
                    var divHeight;
                    if (imgWidth < width && imgHeight < height) {
                        if (imgWidth/width > imgHeight/height) {
                            divWidth = width;
                            divHeight = imgHeight/(imgWidth/width);
                        } else if (imgWidth/width < imgHeight/height) {
                            divWidth = width/(imgHeight/height);
                            divHeight = height;
                        } else {
                            divWidth = width;
                            divHeight = height;
                        }
                    }
                    var style2 = "position: relative; width:" + divWidth + "px; height:" + divHeight + "px;";
                    $("#map_1 [label = 'map_image']").attr('style',style2);

                    $("#map_1 [label = 'map_image']").attr('src', path);

                    $("#mapPosSisDeviceId").empty();
                    for (var i=0;i<posList.length;i++) {
                        var item = posList[i];

                        var leftX;
                        var topY;
                        var path;
                        var imgObj = $("#map_1 [label = 'map_image']");

                        if (imgWidth < imgObj.width() && imgHeight < imgObj.height()) {
                            leftX = item.leftX*(imgObj.width()/imgWidth);
                            topY = item.topY*(imgObj.height()/imgHeight);
                        } else {
                            leftX = item.leftX*(imgObj.width()/imgWidth);
                            topY = item.topY*(imgObj.height()/imgHeight);
                        }
                        if (item.entityType == 'SisDevice') {
                            if (item.deviceState) {
                                path = "/public/images/deviceState/dev_satet_online.png";
                            } else {
                                path = "/public/images/deviceState/dev_satet_offline.png";
                            }
                        } else {
                            if (item.deviceState) {
                                path = "/public/images/deviceState/gate_satet_online.gif";
                            } else {
                                path = "/public/images/deviceState/gate_satet_offline.gif";
                            }
                        }


                        var html = "<div id=" + item.id + "  align=\"center\" style=\"float:left; position: absolute; z-index: 50; left: " + leftX +"px; top: " + topY +"px; width:"+item.width+"px;\">\n" +
                            "                <div id=\"sis_dev_" + item.id + "\">\n" +
                            "                    <img id=\" "+ item.id + "_image\" class=\"can_drag poPupImage " + item.entityType+ "\n" +
                            "                         style=\"width:" + item.width + "px;cursor: move;\" src=" + path + " >\n" +
                            "                </div>\n" +
                            "            </div>";
                        $("#mapPosSisDeviceId").append(html);
                    }
                } else {
                    map();
                }
            }
        });

    }

    function autoSize(Img, imgHeight, imgWidth, maxWidth, maxHeight)
    {
        var leftX;
        var topY;
        // 当图片比图片框小时不做任何改变
        if (imgWidth < maxWidth && imgHeight < maxHeight) {
            if (imgWidth/maxWidth > imgHeight/maxHeight) {
                Img.width = maxWidth;
                Img.height = imgHeight/(imgWidth/maxWidth);
            }
        }
        else //原图片宽高比例 大于 图片框宽高比例,则以框的宽为标准缩放，反之以框的高为标准缩放
        {
            if (maxWidth/ maxHeight  <= imgWidth / imgHeight) //原图片宽高比例 大于 图片框宽高比例
            {
                leftX = item.leftX * (maxWidth/imgWidth);
                topY = imgHeight;
                Img.height = maxWidth* (imgHeight / imgWidth);
            }
            else {   //原图片宽高比例 小于 图片框宽高比例
                Img.width = maxHeight  * (imgWidth / imgHeight);
                Img.height = maxHeight  ;   //以框的高度为标准
            }
        }
        return Img;
    }

    // 通过请求来设置某对象的文本
    function setMapRightHtmlByPath(path, id) {
        $.ajaxSetup({
            async : true
        });
        $.get(path, function(result)
        {
            $("#" + id).html(result);
        }, "html");
    }
    function echarts_1() {
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('echart1'));

        option = {
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'shadow'
                }
            },
            legend: {
                data:echarts1Array,
                textStyle: {
                    color: '#fff'
                }
            },
            grid: {
                left: '0%',
                top:'20%',
                right: '0%',
                bottom: '4%',
                containLabel: true
            },
            xAxis: {
                type: 'category',
                data: areaArray,
                axisLine: {
                    show: true,
                    lineStyle: {
                        color: '#fff',
                        width: 1,
                        type: "solid"
                    },
                },
                axisLabel: {
                    interval: 0,
                    formatter:function(value, index)
                    {
                        if (index % 2 != 0) {
                            return '\n\n' + value;
                        } else {
                            return value;
                        }

                    }
                }
            },
            yAxis: {
                type: 'value',
                axisLabel: {
                    //formatter: '{value} %'
                    show:true,
                    textStyle: {
                        color: "rgba(255,255,255,.6)",
                        fontSize: '12',
                    },
                },
                axisTick: {
                    show: false,
                },
                axisLine: {
                    show: true,
                    lineStyle: {
                        color: "rgba(255,255,255,.1	)",
                        width: 1,
                        type: "solid"
                    },
                },
                splitLine: {
                    lineStyle: {
                        color: "rgba(255,255,255,.1)",
                    }
                }
            },
            series: [
                {
                name: I18n.getValue("sis_home_page_gate_sum"),
                data: personArray,
                type: 'line',
                itemStyle: {
                    normal: {
                        color:'#2f89cf',
                        opacity: 1,
                        barBorderRadius: 5,
                    }
                }

            },
                {
                name: I18n.getValue("sis_home_page_package_alarm_sum"),
                data: alarmArray,
                type: 'line',
                itemStyle: {
                    normal: {
                        color:'#CE0000',
                        opacity: 1,
                        barBorderRadius: 5,
                    }
                }

            }]
        };


        // 使用刚指定的配置项和数据显示图表。
        myChart.setOption(option);
        window.addEventListener("resize",function(){
            myChart.resize();
        });
    }
    function echarts_2() {
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('echart2'));

        option = {
            tooltip: {
                trigger: 'item',
                formatter: '<br/>{b}: {c} ({d}%)'
            },
            graphic:{       //图形中间文字
                type:"text",
                left:"center",
                top:"center",
                style:{
                    text:divSumCount,
                    textAlign:"center",
                    fill:"#fff",
                    fontSize:20
                }
            },
            series: [

                {
                    type: 'pie',
                    radius: ['30%', '60%'],
                    label: {
                        formatter: '{b|{b}：}{c}  {per|{d}%}  ',
                        // backgroundColor: '#eee',
                        // borderColor: '#aaa',
                        // borderWidth: 1,
                        // borderRadius: 4,
                        rich: {
                            a: {
                                color: '#999',
                                lineHeight: 22,
                                align: 'center'
                            },
                            hr: {
                                borderColor: '#aaa',
                                width: '100%',
                                borderWidth: 0.5,
                                height: 0
                            },
                            b: {
                                fontSize: 16,
                                lineHeight: 30
                            },
                            per: {
                                padding: [2, 4],
                                borderRadius: 2
                            }
                        }
                    },
                    color: ['#066eab', '#CE0000', '#D94600'],
                    roseType: 'radius',
                    data: divStateData
                }
            ]
        };

        // 使用刚指定的配置项和数据显示图表。
        myChart.setOption(option);
        window.addEventListener("resize",function(){
            myChart.resize();
        });
    }
    function echarts_5() {
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('echart5'));

        option = {
            //  backgroundColor: '#00265f',
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'shadow'
                }
            },
            legend: {
                data: echarts5Array,
                textStyle: {
                    color: '#fff'
                }
            },
            grid: {
                left: '0%',
                top:'20%',
                right: '0%',
                bottom: '2%',
                containLabel: true
            },
            xAxis: [{
                type: 'category',
                data: packageAreaArray,
                axisLine: {
                    show: true,
                    lineStyle: {
                        color: '#fff',
                        width: 1,
                        type: "solid"
                    },
                },
                axisLabel: {
                    interval: 0,
                    formatter:function(value, index)
                    {
                        if (index % 2 != 0) {
                            return '\n\n' + value;
                        } else {
                            return value;
                        }

                    }
                }
            }],
            yAxis: [{
                type: 'value',
                axisLabel: {
                    //formatter: '{value} %'
                    show:true,
                    textStyle: {
                        color: "rgba(255,255,255,.6)",
                        fontSize: '12',
                    },
                },
                axisTick: {
                    show: false,
                },
                axisLine: {
                    show: true,
                    lineStyle: {
                        color: "rgba(255,255,255,.1	)",
                        width: 1,
                        type: "solid"
                    },
                },
                splitLine: {
                    lineStyle: {
                        color: "rgba(255,255,255,.1)",
                    }
                }
            }],
            series: [{
                name: I18n.getValue("sis_home_page_package_sum"),
                type: 'bar',
                label: {
                    show: true,
                    position: 'top'
                },
                data: packageCountArray,
                barWidth:'30%', //柱子宽度
                // barGap: 1, //柱子之间间距
                itemStyle: {
                    normal: {
                        color:'#2f89cf',
                        opacity: 1,
                        barBorderRadius: 5,
                    }
                }
            },{
                name: I18n.getValue("sis_home_page_package_alarm_sum"),
                type: 'bar',
                label: {
                    show: true,
                    position: 'top'
                },
                data: packageAlarmCountArray,
                barWidth:'30%', //柱子宽度
                // barGap: 1, //柱子之间间距
                itemStyle: {
                    normal: {
                        color:'#CE0000',
                        opacity: 1,
                        barBorderRadius: 5,
                    }
                }
            }
            ]
        };

        // 使用刚指定的配置项和数据显示图表。
        myChart.setOption(option);
        window.addEventListener("resize",function(){
            myChart.resize();
        });
    }

    function echarts_4() {
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('echart4'));

        option = {
            tooltip: {
                trigger: 'item',
                formatter: '<br/>{b}: {c} ({d}%)'
            },
            graphic:{       //图形中间文字
                type:"text",
                left:"center",
                top:"center",
                style:{
                    text:sum,
                    textAlign:"center",
                    fill:"#fff",
                    fontSize:14
                }
            },
            series: [

                {
                    type: 'pie',
                    radius: ['30%', '60%'],
                    label: {
                        formatter: '{b|{b}：}{c}  {per|{d}%}  ',
                        // backgroundColor: '#eee',
                        // borderColor: '#aaa',
                        // borderWidth: 1,
                        // borderRadius: 4,
                        rich: {
                            a: {
                                color: '#999',
                                lineHeight: 22,
                                align: 'center'
                            },
                            hr: {
                                borderColor: '#aaa',
                                width: '100%',
                                borderWidth: 0.5,
                                height: 0
                            },
                            b: {
                                fontSize: 16,
                                lineHeight: 30
                            },
                            per: {
                                padding: [2, 4],
                                borderRadius: 2
                            }
                        }
                    },
                    color: ['#066eab', '#CE0000', '#D94600'],
                    roseType: 'radius',
                    data: devStateData
                }
            ]
        };

        // 使用刚指定的配置项和数据显示图表。
        myChart.setOption(option);
        window.addEventListener("resize",function(){
            myChart.resize();
        });
    }
    function echarts_6() {
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('echart6'));

        option = {
            //  backgroundColor: '#00265f',
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'shadow'
                }
            },

            grid: {
                left: '0%',
                top:'30px',
                right: '0%',
                bottom: '2%',
                containLabel: true
            },
            xAxis: [{
                type: 'category',
                data: typeArray,
                axisLine: {
                    show: true,
                    lineStyle: {
                        color: '#fff',
                        width: 1,
                        type: "solid"
                    },
                },
                axisLabel: {
                    interval: 0,
                    formatter:function(value, index)
                    {
                        if (index % 2 != 0) {
                            return '\n\n' + value;
                        } else {
                            return value;
                        }

                    }
                }
            }],
            yAxis: [{
                type: 'value',
                axisLabel: {
                    //formatter: '{value} %'
                    show:true,
                    textStyle: {
                        color: "rgba(255,255,255,.6)",
                        fontSize: '12',
                    },
                },
                axisTick: {
                    show: false,
                },
                axisLine: {
                    show: true,
                    lineStyle: {
                        color: "rgba(255,255,255,.1	)",
                        width: 1,
                        type: "solid"
                    },
                },
                splitLine: {
                    lineStyle: {
                        color: "rgba(255,255,255,.1)",
                    }
                }
            }],
            series: [{
                type: 'bar',
                label: {
                    show: true,
                    position: 'top'
                },
                data: countArray,
                barWidth:'30%', //柱子宽度
                // barGap: 1, //柱子之间间距
                itemStyle: {
                    normal: {
                        color:'#2f89cf',
                        opacity: 1,
                        barBorderRadius: 5,
                    }
                }
            }
            ]
        };

        // 使用刚指定的配置项和数据显示图表。
        myChart.setOption(option);
        window.addEventListener("resize",function(){
            myChart.resize();
        });
    }
    function echarts_31() {
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('fb1'));
        option = {

            title: [{
                text: I18n.getValue("sis_home_page_state_on_line"),
                left: 'center',
                textStyle: {
                    color: '#00DB00',
                    fontSize:'16'
                }

            },{
                subtext: gateOnLineCount + " " + I18n.getValue("sis_home_page_unit"),
                left: '50%',
                top: '70%',
                textAlign: 'center'
            }],
            legend: {
                top:'70%',
                itemWidth: 10,
                itemHeight: 10,
                textStyle: {
                    color: 'rgba(255,255,255,.5)',
                    fontSize:'12',
                }
            },
            graphic:{       //图形中间文字
                type:"text",
                left:"center",
                top:"center",
                style:{
                    text:gateOnLineRatio + "%",
                    textAlign:"center",
                    fill:"#fff",
                    fontSize:14
                }
            },
            series: [
                {
                    roseType: 'radius',
                    type:'pie',
                    center: ['50%', '50%'],
                    radius: ['30%', '50%'],
                    color: ['#066eab', '#00DB00'],
                    label: {show:false},
                    labelLine: {show:false},
                    data:gateData
                }
            ]
        };

        // 使用刚指定的配置项和数据显示图表。
        myChart.setOption(option);
        window.addEventListener("resize",function(){
            myChart.resize();
        });
    }
    function echarts_32() {
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('fb2'));
        option = {

            title: [{
                text: I18n.getValue("sis_home_page_gate_fault"),
                left: 'center',
                textStyle: {
                    color: '#CE0000',
                    fontSize:'16'
                }

            },{
                subtext: gateOffLineCount + " " + I18n.getValue("sis_home_page_unit"),
                left: '50%',
                top: '70%',
                textAlign: 'center'
            }],
            legend: {
                top:'70%',
                itemWidth: 10,
                itemHeight: 10,
                textStyle: {
                    color: 'rgba(255,255,255,.5)',
                    fontSize:'12',
                }
            },
            graphic:{       //图形中间文字
                type:"text",
                left:"center",
                top:"center",
                style:{
                    text:gateOffLineRatio + "%",
                    textAlign:"center",
                    fill:"#fff",
                    fontSize:14
                }
            },
            series: [
                {
                    roseType: 'radius',
                    type:'pie',
                    center: ['50%', '50%'],
                    radius: ['30%', '50%'],
                    color: ['#066eab', '#CE0000'],
                    label: {show:false},
                    labelLine: {show:false},
                    data:gateOffData
                }
            ]
        };

        // 使用刚指定的配置项和数据显示图表。
        myChart.setOption(option);
        window.addEventListener("resize",function(){
            myChart.resize();
        });
    }
    function echarts_33() {
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('fb3'));
        option = {

            title: [{
                text: I18n.getValue("sis_home_page_state_off_line"),
                left: 'center',
                textStyle: {
                    color: '#D94600',
                    fontSize:'16'
                }

            },{
                subtext: gateOffLineCount + " " + I18n.getValue("sis_home_page_unit"),
                left: '50%',
                top: '70%',
                textAlign: 'center'
            }],
            legend: {
                top:'70%',
                itemWidth: 10,
                itemHeight: 10,
                textStyle: {
                    color: 'rgba(255,255,255,.5)',
                    fontSize:'12',
                }
            },
            graphic:{       //图形中间文字
                type:"text",
                left:"center",
                top:"center",
                style:{
                    text:gateOffLineRatio + "%",
                    textAlign:"center",
                    fill:"#fff",
                    fontSize:14
                }
            },
            series: [
                {
                    roseType: 'radius',
                    type:'pie',
                    center: ['50%', '50%'],
                    radius: ['30%', '50%'],
                    color: ['#066eab', '#CE0000'],
                    label: {show:false},
                    labelLine: {show:false},
                    data:gateOffData
                }
            ]
        };

        // 使用刚指定的配置项和数据显示图表。
        myChart.setOption(option);
        window.addEventListener("resize",function(){
            myChart.resize();
        });
    }
    function map() {
        // 基于准备好的dom，初始化echarts实例
        var myChart = echarts.init(document.getElementById('map_1'));
        var data = [
        ];
        var geoCoordMap = {
        };
        var convertData = function (data) {
            var res = [];
            for (var i = 0; i < data.length; i++) {
                var geoCoord = geoCoordMap[data[i].name];
                if (geoCoord) {
                    res.push({
                        name: data[i].name,
                        value: geoCoord.concat(data[i].value)
                    });
                }
            }
            return res;
        };

        option = {
            tooltip : {
                trigger: 'item',
                formatter: function (params) {
                    if(typeof(params.value)[2] == "undefined"){
                        return params.name + ' : ' + params.value;
                    }else{
                        return params.name + ' : ' + params.value[2];
                    }
                }
            },

            geo: {
                map: 'china',
                label: {
                    emphasis: {
                        show: false
                    }
                },
                roam: false,//禁止其放大缩小
                itemStyle: {
                    normal: {
                        areaColor: '#4c60ff',
                        borderColor: '#002097'
                    },
                    emphasis: {
                        areaColor: '#293fff'
                    }
                }
            },
            series : [
                {
                    type: 'scatter',
                    coordinateSystem: 'geo',
                    data: convertData(data),
                    symbolSize: function (val) {
                        return val[2] / 15;
                    },
                    label: {
                        normal: {
                            formatter: '{b}',
                            position: 'right',
                            show: false
                        },
                        emphasis: {
                            show: true
                        }
                    },
                    itemStyle: {
                        normal: {
                            color: '#ffeb7b'
                        }
                    }
                }
            ]
        };

        myChart.setOption(option);
        window.addEventListener("resize",function(){
            myChart.resize();
        });
    }

})