/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.web.listener;

import com.zkteco.zkbiosecurity.core.config.PropertiesListenerConfig;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppInitListener
implements ServletContextListener {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.log.info("WebAppInitListener init......");
        boolean dev = !"pro".equals(System.getProperty("spring.profiles.active"));
        PropertiesListenerConfig.loadAllProperties("application" + (dev ? "" : "-pro") + ".properties");
        Map<String, String> systemPropertyMap = PropertiesListenerConfig.getSystemProperty();
        for (String key : systemPropertyMap.keySet()) {
            servletContextEvent.getServletContext().setAttribute(key, (Object)systemPropertyMap.get(key));
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.log.info("WebAppInitListener destroy......");
    }
}

