/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkVidChannelRemote;
import com.zkteco.zkbiosecurity.park.service.ParkVidChannelService;
import com.zkteco.zkbiosecurity.park.utils.ParkGetLocalIpAddrUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkVidChannelItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.service.ModuleInfoService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkVidChannelController
extends BaseController
implements ParkVidChannelRemote {
    @Autowired
    private ParkVidChannelService parkVidChannelService;
    @Autowired(required=false)
    private ModuleInfoService moduleInfoService;

    @RequiresPermissions(value={"park:vidChannel"})
    public ModelAndView index() {
        return new ModelAndView("park/vidChannel/parkVidChannel");
    }

    @RequiresPermissions(value={"park:vidChannel:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkVidChannelService.getItemById(id));
        }
        return new ModelAndView("park/vidChannel/editParkVidChannel");
    }

    @RequiresPermissions(value={"park:vidChannel:edit"})
    public ZKResultMsg save(ParkVidChannelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkVidChannelService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(ParkVidChannelItem codition) {
        Pager pager = this.parkVidChannelService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkVidChannelService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getByEditIdAndOtherId(@RequestParam(value="editId") String editId, @RequestParam(value="otherId") String otherId) {
        List selectItems = this.parkVidChannelService.getByEditIdAndOtherId(this.request.getSession().getId(), editId, otherId);
        return new ZKResultMsg((Object)selectItems);
    }

    public DxGrid listByChannelId(ParkVidChannelItem codition) {
        if (codition.getChannelId() == "" || codition.getChannelId() == null) {
            codition.setChannelId("-1");
        }
        Pager pager = this.parkVidChannelService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg getByPavilioIpAddress() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        List parkVidChannelItemList = this.parkVidChannelService.getByPavilioIpAddress(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request));
        if (this.moduleInfoService.isExistModuleByCode("vid")) {
            zkResultMsg.setMsg("vid");
        } else if (this.moduleInfoService.isExistModuleByCode("vms")) {
            zkResultMsg.setMsg("vms");
        }
        zkResultMsg.setData((Object)parkVidChannelItemList);
        return zkResultMsg;
    }

    public ZKResultMsg getByPavilioId(@RequestParam(value="pavilioId") String pavilioId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        List parkVidChannelItemList = this.parkVidChannelService.getByPavilioId(pavilioId);
        if (this.moduleInfoService.isExistModuleByCode("vid")) {
            zkResultMsg.setMsg("vid");
        } else if (this.moduleInfoService.isExistModuleByCode("vms")) {
            zkResultMsg.setMsg("vms");
        }
        zkResultMsg.setData((Object)parkVidChannelItemList);
        return zkResultMsg;
    }
}

