/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.park.remote.ParkTerminalManageRemote;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.utils.ParkGetLocalIpAddrUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkTerminalManageItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkTerminalManageController
extends BaseController
implements ParkTerminalManageRemote {
    private static final Logger log = LoggerFactory.getLogger(ParkTerminalManageController.class);
    @Autowired
    private ParkPavilioService parkPavilioService;

    @RequestMapping
    @RequiresPermissions(value={"park:terminalManage"})
    public ModelAndView index() {
        ParkTerminalManageItem parkTerminalManageItem = this.parkPavilioService.getTerminalParameter(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request));
        this.request.setAttribute("parkTerminalManageItem", (Object)parkTerminalManageItem);
        return new ModelAndView("park/terminalManage/parkTerminalManage");
    }

    public ZKResultMsg heartbeat() {
        log.info("PARK_TERMINALMANAGE heartbeat ...");
        return new ZKResultMsg();
    }
}

