/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.init;

import com.zkteco.zkbiosecurity.acc.service.AccZoneService;
import com.zkteco.zkbiosecurity.acc.vo.AccZoneItem;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=34)
public class AccAdvancedInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AccZoneService accZoneService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("AccAdvancedInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initAccZone();
            this.baseSysParamService.setAlreadyInitModule("AccAdvancedInit");
        }
        this.initShowLicense();
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = null;
        AuthPermissionItem topMenuItem = null;
        AuthPermissionItem subMenuItem = null;
        AuthPermissionItem subButtonItem = null;
        systemItem = this.authPermissionService.getItemByCode("Acc");
        if (null == systemItem) {
            systemItem = new AuthPermissionItem("Acc", "acc_module", "acc", "system", "true", Integer.valueOf(3));
            systemItem = this.authPermissionService.initData(systemItem);
        }
        topMenuItem = new AuthPermissionItem("AccGlobalAccessManager", "acc_leftMenu_expertGuard", "acc:globalAccess:manager", "menu", "true", Integer.valueOf(3));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setImg("acc_seniorAccess.png");
        topMenuItem.setImgHover("acc_seniorAccess_over.png");
        topMenuItem = this.authPermissionService.initData(topMenuItem);
        subMenuItem = new AuthPermissionItem("AccZone", "acc_leftMenu_zone", "acc:zone", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accZone.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccZoneRefresh", "common_op_refresh", "acc:zone:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccZoneAdd", "common_op_new", "acc:zone:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccZoneEdit", "common_op_edit", "acc:zone:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccZoneDel", "common_op_del", "acc:zone:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccZoneQueryZoneRules", "acc_leftMenu_whatRulesInside", "acc:zone:queryZoneRules", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccReaderZone", "acc_leftMenu_readerDefine", "acc:readerZone", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accReaderZone.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccReaderZoneRefresh", "common_op_refresh", "acc:readerZone:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccReaderZoneAdd", "common_op_new", "acc:readerZone:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccReaderZoneEdit", "common_op_edit", "acc:readerZone:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccReaderZoneAddReaders", "common_op_batchNew", "acc:readerZone:addReaders", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccReaderZoneDel", "common_op_del", "acc:readerZone:del", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccZonePerson", "acc_leftMenu_whoIsInside", "acc:zonePerson", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accZonePerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccZonePersonRefresh", "common_op_refresh", "acc:zonePerson:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccZonePersonAddPerson", "pers_common_addPerson", "acc:zonePerson:addPerson", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccZonePersonDelPerson", "pers_common_delPerson", "acc:zonePerson:delPerson", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccZonePersonExport", "common_op_export", "acc:zonePerson:export", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccGlobalApb", "acc_leftMenu_gapbSet", "acc:globalApb", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accGlobalApb.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccGlobalApbRefresh", "common_op_refresh", "acc:globalApb:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalApbAdd", "common_op_new", "acc:globalApb:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalApbEdit", "common_op_edit", "acc:globalApb:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalApbDel", "common_op_del", "acc:globalApb:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalApbAddPerson", "pers_common_addPerson", "acc:globalApb:addPerson", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalApbDelPerson", "pers_common_delPerson", "acc:globalApb:delPerson", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccGlobalLinkage", "acc_leftMenu_globalLinkage", "acc:globalLinkage", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accGlobalLinkage.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccGlobalLinkageRefresh", "common_op_refresh", "acc:globalLinkage:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalLinkageAdd", "common_op_new", "acc:globalLinkage:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalLinkageEdit", "common_op_edit", "acc:globalLinkage:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalLinkageDelete", "common_op_del", "acc:globalLinkage:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalLinkageEnable", "common_enable", "acc:globalLinkage:enable", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalLinkageDisable", "common_disable", "acc:globalLinkage:disable", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalLinkageAddPerson", "pers_common_addPerson", "acc:globalLinkage:addPerson", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalLinkageDelPerson", "pers_common_delPerson", "acc:globalLinkage:delPerson", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccGlobalInterlockGroup", "acc_leftMeue_globalInterlockGroup", "acc:globalInterlockGroup", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accGlobalInterlockGroup.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockGroupRefresh", "common_op_refresh", "acc:globalInterlockGroup:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockGroupAdd", "common_op_new", "acc:globalInterlockGroup:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockGroupEdit", "common_op_edit", "acc:globalInterlockGroup:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockGroupDelete", "common_op_del", "acc:globalInterlockGroup:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockGroupAddDoor", "acc_map_addDoor", "acc:globalInterlockGroup:addDoor", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockGroupDelDoor", "acc_level_doorDelete", "acc:globalInterlockGroup:delDoor", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccGlobalInterlock", "acc_leftMenu_globalInterlock", "acc:globalInterlock", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accGlobalInterlock.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockRefresh", "common_op_refresh", "acc:globalInterlock:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockAdd", "common_op_new", "acc:globalInterlock:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockEdit", "common_op_edit", "acc:globalInterlock:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockDelete", "common_op_del", "acc:globalInterlock:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockAddGroup", "acc_globalInterlock_addGroup", "acc:globalInterlock:addGroup", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccGlobalInterlockDelGroup", "acc_globalInterlock_delGroup", "acc:globalInterlock:delGroup", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccPersonLimitZone", "acc_leftMenu_personLimit", "acc:personLimitZone", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accPersonLimitZone.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccPersonLimitZoneRefresh", "common_op_refresh", "acc:personLimitZone:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLimitZoneAdd", "common_op_new", "acc:personLimitZone:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLimitZoneEdit", "common_op_edit", "acc:personLimitZone:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLimitZoneDel", "common_op_del", "acc:personLimitZone:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLimitZoneSetZoneProperty", "acc_personLimit_setZoneProperty", "acc:personLimitZone:setZoneProperty", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccOccupancy", "acc_leftMenu_occupancy", "acc:occupancy", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accOccupancy.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccOccupancyRefresh", "common_op_refresh", "acc:occupancy:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccOccupancyAdd", "common_op_new", "acc:occupancy:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccOccupancyEdit", "common_op_edit", "acc:occupancy:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccOccupancyDel", "common_op_del", "acc:occupancy:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
    }

    private void initAccZone() {
        AccZoneItem accZoneItem = new AccZoneItem();
        accZoneItem.setCode("1");
        accZoneItem.setInitFlag(Boolean.valueOf(true));
        accZoneItem.setName(I18nUtil.i18nCode((String)"acc_zone_outside", (Object[])new Object[0]));
        accZoneItem.setRemark(I18nUtil.i18nCode((String)"acc_zone_outside", (Object[])new Object[0]));
        this.accZoneService.initData(accZoneItem);
    }

    private void initShowLicense() {
        BaseSysParamItem baseSysParamItem = new BaseSysParamItem("accadvanced.version", "true", "accadvanced license", Boolean.valueOf(true));
        this.baseSysParamService.initData(baseSysParamItem);
    }
}

