/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POSID_ACCOUNT t LEFT JOIN POSID_ACCOUNTKIND P ON P.ID=t.ACCOUNTKIND_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDAccountItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.ACCOUNT_NO")
    @GridColumn(label="posid_card_accountNum", width="120")
    private String accountNo;
    @Column(name="t.STATUS")
    @GridColumn(label="posid_account_type", width="90", format="1=posid_card_changeOperator,0=posid_account_type_comomon")
    private Integer status;
    @Column(name="P.NAME")
    @GridColumn(label="posid_leftMenu_icCard", width="120")
    private String name;
    @Column(name="t.BALANCE")
    @GridColumn(label="posid_card_blance", width="120", columnType="custom", convert="convertFen2Yuan")
    private Integer balance;
    @GridColumn(show=true, label="posid_account_money_wallet", columnType="custom", convert="convertFen2Yuan")
    private Integer posMoneyWallet;
    @GridColumn(show=true, label="posid_account_allowance_wallet", columnType="custom", convert="convertFen2Yuan")
    private Integer posAllowanceWallet;
    @Column(name="t.DEPT_CODE")
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="posid_card_deptName", width="110")
    private String deptName;
    @Column(name="t.ACCOUNT_TYPE")
    @GridColumn(label="posid_leftMenu_icCard", width="110", format="0=posid_account_type_pers", show=false)
    private Integer accountType;
    @Column(name="t.ISSUE_DATE")
    @GridColumn(label="posid_card_sendCardDate", width="240")
    private Date issueDate;
    @Column(name="t.SERIAL_NUM")
    @GridColumn(label="posid_cardManage_cardSerialNum", show=false)
    private Integer serialNum;
    @Column(name="t.IS_VALID")
    @GridColumn(label="posid_card_isValid", width="80", format="0=common_enable,1=common_disable")
    private Integer available;
    @Column(name="t.ACCOUNT_MEMBER")
    @GridColumn(label="posid_account_member", width="100", format="0=posid_card_false,1=posid_card_true")
    private Integer accountMember;
    @Column(name="t.POS_DATE")
    @GridColumn(label="posid_cardManage_posDate", show=false)
    private Date posDate;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="posid_cardManage_deptId", show=false)
    private String deptId;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="posid_cardManage_personId", show=false)
    private String personId;
    @Column(name="t.ACCOUNTKIND_ID")
    @GridColumn(label="posid_cardManage_posCardKind", show=false)
    private String posAccountKindId;
    @Column(name="p.DISCOUNT")
    @GridColumn(label="posid_iccard_discount", width="85", show=false)
    private Integer discount;
    @Column(name="p.name")
    private String accountKindName;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    private int posStart = 0;
    private int pageSize = 10;

    public PosIDAccountItem() {
    }

    public PosIDAccountItem(Boolean equals) {
        super(equals);
    }

    public PosIDAccountItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDAccountItem(String id, String personId, String personPin, String personName, String personLastName, String deptId, String deptCode, String deptName, String accountNo, Integer balance, String password, Integer serialNum, Date issueDate, Integer isValid, Integer status, Date posDate) {
        this.id = id;
        this.personId = personId;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.deptId = deptId;
        this.deptCode = deptCode;
        this.deptName = deptName;
        this.accountNo = accountNo;
        this.balance = balance;
        this.serialNum = serialNum;
        this.issueDate = issueDate;
        this.available = isValid;
        this.status = status;
        this.posDate = posDate;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public Integer getBalance() {
        return this.balance;
    }

    public Integer getPosMoneyWallet() {
        return this.posMoneyWallet;
    }

    public Integer getPosAllowanceWallet() {
        return this.posAllowanceWallet;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Integer getAccountType() {
        return this.accountType;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public Integer getSerialNum() {
        return this.serialNum;
    }

    public Integer getAvailable() {
        return this.available;
    }

    public Integer getAccountMember() {
        return this.accountMember;
    }

    public Date getPosDate() {
        return this.posDate;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPosAccountKindId() {
        return this.posAccountKindId;
    }

    public Integer getDiscount() {
        return this.discount;
    }

    public String getAccountKindName() {
        return this.accountKindName;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public int getPosStart() {
        return this.posStart;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public PosIDAccountItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDAccountItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDAccountItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDAccountItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDAccountItem setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public PosIDAccountItem setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public PosIDAccountItem setName(String name) {
        this.name = name;
        return this;
    }

    public PosIDAccountItem setBalance(Integer balance) {
        this.balance = balance;
        return this;
    }

    public PosIDAccountItem setPosMoneyWallet(Integer posMoneyWallet) {
        this.posMoneyWallet = posMoneyWallet;
        return this;
    }

    public PosIDAccountItem setPosAllowanceWallet(Integer posAllowanceWallet) {
        this.posAllowanceWallet = posAllowanceWallet;
        return this;
    }

    public PosIDAccountItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PosIDAccountItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDAccountItem setAccountType(Integer accountType) {
        this.accountType = accountType;
        return this;
    }

    public PosIDAccountItem setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public PosIDAccountItem setSerialNum(Integer serialNum) {
        this.serialNum = serialNum;
        return this;
    }

    public PosIDAccountItem setAvailable(Integer available) {
        this.available = available;
        return this;
    }

    public PosIDAccountItem setAccountMember(Integer accountMember) {
        this.accountMember = accountMember;
        return this;
    }

    public PosIDAccountItem setPosDate(Date posDate) {
        this.posDate = posDate;
        return this;
    }

    public PosIDAccountItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDAccountItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDAccountItem setPosAccountKindId(String posAccountKindId) {
        this.posAccountKindId = posAccountKindId;
        return this;
    }

    public PosIDAccountItem setDiscount(Integer discount) {
        this.discount = discount;
        return this;
    }

    public PosIDAccountItem setAccountKindName(String accountKindName) {
        this.accountKindName = accountKindName;
        return this;
    }

    public PosIDAccountItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public PosIDAccountItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDAccountItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDAccountItem setPosStart(int posStart) {
        this.posStart = posStart;
        return this;
    }

    public PosIDAccountItem setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public String toString() {
        return "PosIDAccountItem(id=" + this.getId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", accountNo=" + this.getAccountNo() + ", status=" + this.getStatus() + ", name=" + this.getName() + ", balance=" + this.getBalance() + ", posMoneyWallet=" + this.getPosMoneyWallet() + ", posAllowanceWallet=" + this.getPosAllowanceWallet() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", accountType=" + this.getAccountType() + ", issueDate=" + this.getIssueDate() + ", serialNum=" + this.getSerialNum() + ", available=" + this.getAvailable() + ", accountMember=" + this.getAccountMember() + ", posDate=" + this.getPosDate() + ", deptId=" + this.getDeptId() + ", personId=" + this.getPersonId() + ", posAccountKindId=" + this.getPosAccountKindId() + ", discount=" + this.getDiscount() + ", accountKindName=" + this.getAccountKindName() + ", notInId=" + this.getNotInId() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ", posStart=" + this.getPosStart() + ", pageSize=" + this.getPageSize() + ")";
    }
}

