/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.app.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.api.vo.AppPersonItem;
import com.zkteco.zkbiosecurity.pers.api.vo.AppUserCertTypeItem;
import com.zkteco.zkbiosecurity.pers.api.vo.AppUserResetPasswordItem;
import com.zkteco.zkbiosecurity.pers.service.PersAppBioService;
import com.zkteco.zkbiosecurity.pers.service.PersAppService;
import com.zkteco.zkbiosecurity.pers.service.PersCertificateService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.util.PersCheckUtil;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/v1/user"})
public class PersAppPersonController {
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private PersAppService persAppService;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private PersAppBioService persAppBioService;
    @Autowired
    private PersCertificateService persCertificateService;

    @RequestMapping(path={"/changeUserInfo"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg changeUserInfo(@RequestBody AppPersonItem appPersonItem) {
        PersCheckUtil.checkAppPerson(appPersonItem, null);
        return I18nUtil.i18nMsg((ZKResultMsg)this.persAppBioService.changeUserInfo(appPersonItem));
    }

    @RequestMapping(path={"/getCertType"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getCertType() {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        Map certMap = this.baseDictionaryValueService.getDictionaryValuesMap("certificateType");
        ArrayList appCertTypeItems = new ArrayList();
        if (!certMap.isEmpty()) {
            certMap.forEach((k, v) -> {
                AppUserCertTypeItem appCertTypeItem = new AppUserCertTypeItem();
                appCertTypeItem.setCertName(v);
                appCertTypeItem.setCertType(k);
                appCertTypeItems.add(appCertTypeItem);
            });
        }
        resultMsg.setData(appCertTypeItems);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/changePassword"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg changePassword(@RequestBody AppUserResetPasswordItem appUserResetPasswordItem) {
        PersPersonItem item = this.persPersonService.getItemById(appUserResetPasswordItem.getCustomerId());
        String newPassword = appUserResetPasswordItem.getNewPassword();
        String oldPassword = appUserResetPasswordItem.getOldPassword();
        if (oldPassword.equals(newPassword)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"pers_h5_pwdIsRepetition", (Object[])new Object[0]));
        }
        boolean isSucceed = this.persPersonService.changeSelfPwd(item.getPin(), oldPassword, newPassword, true);
        if (isSucceed) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"pers_h5_oldPwdIsError", (Object[])new Object[0]));
    }

    @RequestMapping(path={"/loginOut"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg logout(@RequestParam(name="access_token") String token) {
        this.persAppBioService.persLoginOut(token);
        return ZKResultMsg.successMsg();
    }

    @RequestMapping(path={"/getUserInfo"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getUserInfo(@RequestParam(name="customerId") String customerId) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"pers_h5_personIdNull", (Object[])new Object[0]);
        }
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        AppPersonItem person = this.persAppBioService.getUserInfoDetail(customerId);
        if (person != null) {
            zkResultMsg.setData((Object)person);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(path={"/getUserPage"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getUserPage(@RequestBody JSONObject data) {
        String filter = data.getString("filter");
        String deptId = data.getString("deptId");
        Integer page = data.getInteger("page");
        Integer pageSize = data.getInteger("pageSize");
        if (page == null || pageSize == null) {
            throw ZKBusinessException.errorException((String)"pers_h5_pageNull", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = this.persPersonService.getUserInfos(filter, deptId, page, pageSize);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/checkCertNumber"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg checkCertNumber(@RequestParam(value="certNumber") String certNumber, @RequestParam(value="personId", required=false) String personId, @RequestParam(value="certType") String certType) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        boolean flag = true;
        if (StringUtils.isNotBlank((CharSequence)certNumber)) {
            flag = this.persCertificateService.isExistByCertNumberAndCertTypeAndPersonIdNe(certNumber, certType, personId);
        }
        zkResultMsg.setData((Object)flag);
        return zkResultMsg;
    }
}

