/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POSID_HANDCONSUME t left join POSID_MEAL pm on t.MEAL_ID = pm.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDHandConsumeItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na", show=false)
    private String id;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="posid_handConsume_personId", show=false)
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="posid_handConsume_deptId", show=false)
    private String deptId;
    @Column(name="t.DEPT_CODE")
    @GridColumn(label="posid_handConsume_deptCode", show=false)
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="posid_handConsume_deptName", show=false)
    private String deptName;
    @Column(name="t.ACCOUNT_NO")
    @GridColumn(label="posid_card_accountNum", width="90")
    private String accountNo;
    @Column(name="t.ACCOUNT_SERIAL")
    @GridColumn(label="posid_card_cardSerial", width="80")
    private Integer accountSerial;
    @Column(name="t.MONEY")
    @GridColumn(label="posid_cus_money", width="80", columnType="custom", convert="convertFen2Yuan")
    private Integer money;
    @Column(name="t.BALANCE")
    @GridColumn(label="posid_card_blance", width="80", columnType="custom", convert="convertFen2Yuan")
    private Integer balance;
    @Column(name="t.MONEY_WALLET")
    @GridColumn(label="posid_card_money_wallet", width="100", columnType="custom", convert="convertFen2Yuan")
    private Integer moneyWallet;
    @Column(name="t.ALLOWANCE_WALLET")
    @GridColumn(label="posid_card_subBlance", width="100", columnType="custom", convert="convertFen2Yuan")
    private Integer allowanceWallet;
    @Column(name="t.CONSUME_ORDER")
    @GridColumn(label="posid_consume_order", width="120", format="0=posid_system_onlyCash,1=posid_system_onlySubsidy,2=posid_system_firstCash,3=posid_system_firstSubsidy")
    private Integer consumeOrder;
    @Column(name="t.HALLING_ID")
    @GridColumn(label="posid_transaction_hallingId", show=false)
    private String hallingId;
    @Column(name="t.HALLING_CODE")
    @GridColumn(label="posid_transaction_hallingCode", show=false)
    private String hallingCode;
    @Column(name="t.HALLING_NAME")
    @GridColumn(label="posid_diningHall_name", width="110")
    private String hallingName;
    @Column(name="pm.NAME")
    @GridColumn(label="posid_cus_meal")
    private String mealName;
    @Column(name="pm.CODE")
    @GridColumn(label="posid_meal_code", show=false)
    private String mealCode;
    @Column(name="t.MEAL_ID")
    @GridColumn(label="posid_transaction_posMeal", show=false)
    private String mealId;
    @Column(name="t.DEVICE_ID")
    @GridColumn(label="posid_handConsume_posDevice", show=false)
    private String posDeviceId;
    @Column(name="t.DEVICE_SN")
    @GridColumn(label="common_dev_sn", width="150")
    private String deviceSn;
    @Column(name="t.DEVICE_ALIAS")
    @GridColumn(label="common_dev_name", width="150")
    private String deviceAlias;
    @Column(name="t.DATE_TIME")
    @GridColumn(label="posid_cus_time", width="130")
    private Date dateTime;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="posid_cus_creatTime", width="130")
    private Date createTime;
    @Column(name="t.CREATER_CODE")
    @GridColumn(label="posid_card_creatOperator", width="110")
    private String createrName;
    @Column(name="t.STATUS")
    @GridColumn(label="posid_handConsume_status", show=false)
    private Integer status;
    @Condition(value="t.DATE_TIME", equalTag=">=", toDate=true)
    private String startDatetimeBegin;
    @Condition(value="t.DATE_TIME", equalTag="<=", toDate=true)
    private String startDatetimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;

    public PosIDHandConsumeItem(String id) {
        this.id = id;
    }

    public PosIDHandConsumeItem() {
    }

    public PosIDHandConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosIDHandConsumeItem(String id, String personId, String personPin, String personName, String personLastName, String deptId, String deptCode, String deptName, String accountNo, Integer accountSerial, Integer money, Integer balance, Integer moneyWallet, Integer allowanceWallet, Integer consumeOrder, String hallingId, String hallingCode, String hallingName, String mealName, String mealCode, String mealId, String posDeviceId, String deviceSn, String deviceAlias, Date dateTime, Date createTime, String createrName, Integer status, String startDatetimeBegin, String startDatetimeEnd, String inDeptId, String likeName) {
        this.id = id;
        this.personId = personId;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.deptId = deptId;
        this.deptCode = deptCode;
        this.deptName = deptName;
        this.accountNo = accountNo;
        this.accountSerial = accountSerial;
        this.money = money;
        this.balance = balance;
        this.moneyWallet = moneyWallet;
        this.allowanceWallet = allowanceWallet;
        this.consumeOrder = consumeOrder;
        this.hallingId = hallingId;
        this.hallingCode = hallingCode;
        this.hallingName = hallingName;
        this.mealName = mealName;
        this.mealCode = mealCode;
        this.mealId = mealId;
        this.posDeviceId = posDeviceId;
        this.deviceSn = deviceSn;
        this.deviceAlias = deviceAlias;
        this.dateTime = dateTime;
        this.createTime = createTime;
        this.createrName = createrName;
        this.status = status;
        this.startDatetimeBegin = startDatetimeBegin;
        this.startDatetimeEnd = startDatetimeEnd;
        this.inDeptId = inDeptId;
        this.likeName = likeName;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public Integer getAccountSerial() {
        return this.accountSerial;
    }

    public Integer getMoney() {
        return this.money;
    }

    public Integer getBalance() {
        return this.balance;
    }

    public Integer getMoneyWallet() {
        return this.moneyWallet;
    }

    public Integer getAllowanceWallet() {
        return this.allowanceWallet;
    }

    public Integer getConsumeOrder() {
        return this.consumeOrder;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getHallingCode() {
        return this.hallingCode;
    }

    public String getHallingName() {
        return this.hallingName;
    }

    public String getMealName() {
        return this.mealName;
    }

    public String getMealCode() {
        return this.mealCode;
    }

    public String getMealId() {
        return this.mealId;
    }

    public String getPosDeviceId() {
        return this.posDeviceId;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getDeviceAlias() {
        return this.deviceAlias;
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public PosIDHandConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDHandConsumeItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDHandConsumeItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDHandConsumeItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDHandConsumeItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDHandConsumeItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDHandConsumeItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PosIDHandConsumeItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDHandConsumeItem setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public PosIDHandConsumeItem setAccountSerial(Integer accountSerial) {
        this.accountSerial = accountSerial;
        return this;
    }

    public PosIDHandConsumeItem setMoney(Integer money) {
        this.money = money;
        return this;
    }

    public PosIDHandConsumeItem setBalance(Integer balance) {
        this.balance = balance;
        return this;
    }

    public PosIDHandConsumeItem setMoneyWallet(Integer moneyWallet) {
        this.moneyWallet = moneyWallet;
        return this;
    }

    public PosIDHandConsumeItem setAllowanceWallet(Integer allowanceWallet) {
        this.allowanceWallet = allowanceWallet;
        return this;
    }

    public PosIDHandConsumeItem setConsumeOrder(Integer consumeOrder) {
        this.consumeOrder = consumeOrder;
        return this;
    }

    public PosIDHandConsumeItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDHandConsumeItem setHallingCode(String hallingCode) {
        this.hallingCode = hallingCode;
        return this;
    }

    public PosIDHandConsumeItem setHallingName(String hallingName) {
        this.hallingName = hallingName;
        return this;
    }

    public PosIDHandConsumeItem setMealName(String mealName) {
        this.mealName = mealName;
        return this;
    }

    public PosIDHandConsumeItem setMealCode(String mealCode) {
        this.mealCode = mealCode;
        return this;
    }

    public PosIDHandConsumeItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosIDHandConsumeItem setPosDeviceId(String posDeviceId) {
        this.posDeviceId = posDeviceId;
        return this;
    }

    public PosIDHandConsumeItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public PosIDHandConsumeItem setDeviceAlias(String deviceAlias) {
        this.deviceAlias = deviceAlias;
        return this;
    }

    public PosIDHandConsumeItem setDateTime(Date dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    public PosIDHandConsumeItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public PosIDHandConsumeItem setCreaterName(String createrName) {
        this.createrName = createrName;
        return this;
    }

    public PosIDHandConsumeItem setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public PosIDHandConsumeItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDHandConsumeItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDHandConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDHandConsumeItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String toString() {
        return "PosIDHandConsumeItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptId=" + this.getDeptId() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", accountNo=" + this.getAccountNo() + ", accountSerial=" + this.getAccountSerial() + ", money=" + this.getMoney() + ", balance=" + this.getBalance() + ", moneyWallet=" + this.getMoneyWallet() + ", allowanceWallet=" + this.getAllowanceWallet() + ", consumeOrder=" + this.getConsumeOrder() + ", hallingId=" + this.getHallingId() + ", hallingCode=" + this.getHallingCode() + ", hallingName=" + this.getHallingName() + ", mealName=" + this.getMealName() + ", mealCode=" + this.getMealCode() + ", mealId=" + this.getMealId() + ", posDeviceId=" + this.getPosDeviceId() + ", deviceSn=" + this.getDeviceSn() + ", deviceAlias=" + this.getDeviceAlias() + ", dateTime=" + this.getDateTime() + ", createTime=" + this.getCreateTime() + ", createrName=" + this.getCreaterName() + ", status=" + this.getStatus() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ")";
    }
}

