/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

@From(after="PATROL_TRANSACTION t ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class PatrolTransactionTodayItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0, show=false)
    private String id;
    @Column(name="t.EVENT_TIME")
    @GridColumn(label="common_time", width="125")
    private Date eventTime;
    @Column(name="t.DEV_ALIAS")
    @GridColumn(label="common_dev_name", width="100")
    private String devAlias;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", width="100")
    private String lastName;
    @Column(name="t.CARD_NO")
    @GridColumn(label="pers_card_cardNo", width="100")
    private String cardNo;
    @Column(name="t.DEV_MODULE")
    @GridColumn(label="patrol_point_devModule", width="110", format="acc=patrol_point_accmodel")
    private String devModule;
    @Column(name="t.ROUTE_NAME")
    @GridColumn(label="patrol_route_name", width="100")
    private String routeName;
    @Column(name="t.PATROL_POINT_NAME")
    @GridColumn(label="patrol_point_name", width="100")
    private String patrolPointName;
    @Column(name="t.VERIFY_MODE_NAME")
    @GridColumn(label="common_verifyMode_entiy", width="100", i18n=true)
    private String verifyModeName;
    @Column(name="t.AREA_NAME")
    @GridColumn(label="base_area_name", width="100")
    private String areaName;
    @Column(name="t.DESCRIPTION")
    @GridColumn(label="common_remark", width="100")
    private String description;
    @Column(name="t.UNIQUE_KEY")
    @GridColumn(label="patrol_transaction_uniqueKey", show=false)
    private String uniqueKey;
    @Column(name="t.DEV_SN")
    @GridColumn(label="patrol_transaction_devSn", show=false)
    private String devSn;
    @Column(name="t.DEV_ID")
    @GridColumn(label="patrol_transaction_devId", show=false)
    private String devId;
    @Column(name="t.VERIFY_MODE_NO")
    @GridColumn(label="patrol_transaction_verifyModeNo", show=false)
    private Short verifyModeNo;
    @Column(name="t.PATROL_POINT_ID")
    @GridColumn(label="patrol_transaction_patrolPointId", show=false)
    private String patrolPointId;
    @Column(name="t.ROUTE_ID")
    @GridColumn(label="patrol_transaction_routeId", show=false)
    private String routeId;
    @Column(name="t.GROUP_ID")
    @GridColumn(label="patrol_transaction_groupId", show=false)
    private String groupId;
    @Column(name="t.GROUP_NAME")
    @GridColumn(label="patrol_transaction_groupName", show=false)
    private String groupName;
    @Column(name="t.PATROL_POINT_STATUS")
    @GridColumn(label="patrol_transaction_patrolPointStatus", show=false)
    private Short patrolPointStatus;
    @Column(name="t.EVENT_TIME", equalTag=">")
    private Date eventTimeBegin;
    @Column(name="t.EVENT_TIME", equalTag="<")
    private Date eventTimeEnd;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;

    public PatrolTransactionTodayItem(String id) {
        this.id = id;
    }

    public PatrolTransactionTodayItem() {
    }

    public PatrolTransactionTodayItem(Boolean equals) {
        super(equals);
    }

    public PatrolTransactionTodayItem(String id, Timestamp eventTime, String devAlias, String pin, String name, String lastName, String cardNo, String devModule, String routeName, String patrolPointName, String verifyModeName, String areaName, String description, String uniqueKey, String devSn, String devId, Short verifyModeNo, String patrolPointId, String routeId, String groupId, String groupName, Short patrolPointStatus) {
        this.id = id;
        this.eventTime = eventTime;
        this.devAlias = devAlias;
        this.pin = pin;
        this.name = name;
        this.lastName = lastName;
        this.cardNo = cardNo;
        this.devModule = devModule;
        this.routeName = routeName;
        this.patrolPointName = patrolPointName;
        this.verifyModeName = verifyModeName;
        this.areaName = areaName;
        this.description = description;
        this.uniqueKey = uniqueKey;
        this.devSn = devSn;
        this.devId = devId;
        this.verifyModeNo = verifyModeNo;
        this.patrolPointId = patrolPointId;
        this.routeId = routeId;
        this.groupId = groupId;
        this.groupName = groupName;
        this.patrolPointStatus = patrolPointStatus;
    }

    public String getId() {
        return this.id;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getDevModule() {
        return this.devModule;
    }

    public String getRouteName() {
        return this.routeName;
    }

    public String getPatrolPointName() {
        return this.patrolPointName;
    }

    public String getVerifyModeName() {
        return this.verifyModeName;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getDevId() {
        return this.devId;
    }

    public Short getVerifyModeNo() {
        return this.verifyModeNo;
    }

    public String getPatrolPointId() {
        return this.patrolPointId;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Short getPatrolPointStatus() {
        return this.patrolPointStatus;
    }

    public Date getEventTimeBegin() {
        return this.eventTimeBegin;
    }

    public Date getEventTimeEnd() {
        return this.eventTimeEnd;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public PatrolTransactionTodayItem setId(String id) {
        this.id = id;
        return this;
    }

    public PatrolTransactionTodayItem setEventTime(Date eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public PatrolTransactionTodayItem setDevAlias(String devAlias) {
        this.devAlias = devAlias;
        return this;
    }

    public PatrolTransactionTodayItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PatrolTransactionTodayItem setName(String name) {
        this.name = name;
        return this;
    }

    public PatrolTransactionTodayItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PatrolTransactionTodayItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PatrolTransactionTodayItem setDevModule(String devModule) {
        this.devModule = devModule;
        return this;
    }

    public PatrolTransactionTodayItem setRouteName(String routeName) {
        this.routeName = routeName;
        return this;
    }

    public PatrolTransactionTodayItem setPatrolPointName(String patrolPointName) {
        this.patrolPointName = patrolPointName;
        return this;
    }

    public PatrolTransactionTodayItem setVerifyModeName(String verifyModeName) {
        this.verifyModeName = verifyModeName;
        return this;
    }

    public PatrolTransactionTodayItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public PatrolTransactionTodayItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public PatrolTransactionTodayItem setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
        return this;
    }

    public PatrolTransactionTodayItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PatrolTransactionTodayItem setDevId(String devId) {
        this.devId = devId;
        return this;
    }

    public PatrolTransactionTodayItem setVerifyModeNo(Short verifyModeNo) {
        this.verifyModeNo = verifyModeNo;
        return this;
    }

    public PatrolTransactionTodayItem setPatrolPointId(String patrolPointId) {
        this.patrolPointId = patrolPointId;
        return this;
    }

    public PatrolTransactionTodayItem setRouteId(String routeId) {
        this.routeId = routeId;
        return this;
    }

    public PatrolTransactionTodayItem setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public PatrolTransactionTodayItem setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public PatrolTransactionTodayItem setPatrolPointStatus(Short patrolPointStatus) {
        this.patrolPointStatus = patrolPointStatus;
        return this;
    }

    public PatrolTransactionTodayItem setEventTimeBegin(Date eventTimeBegin) {
        this.eventTimeBegin = eventTimeBegin;
        return this;
    }

    public PatrolTransactionTodayItem setEventTimeEnd(Date eventTimeEnd) {
        this.eventTimeEnd = eventTimeEnd;
        return this;
    }

    public PatrolTransactionTodayItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String toString() {
        return "PatrolTransactionTodayItem(id=" + this.getId() + ", eventTime=" + this.getEventTime() + ", devAlias=" + this.getDevAlias() + ", pin=" + this.getPin() + ", name=" + this.getName() + ", lastName=" + this.getLastName() + ", cardNo=" + this.getCardNo() + ", devModule=" + this.getDevModule() + ", routeName=" + this.getRouteName() + ", patrolPointName=" + this.getPatrolPointName() + ", verifyModeName=" + this.getVerifyModeName() + ", areaName=" + this.getAreaName() + ", description=" + this.getDescription() + ", uniqueKey=" + this.getUniqueKey() + ", devSn=" + this.getDevSn() + ", devId=" + this.getDevId() + ", verifyModeNo=" + this.getVerifyModeNo() + ", patrolPointId=" + this.getPatrolPointId() + ", routeId=" + this.getRouteId() + ", groupId=" + this.getGroupId() + ", groupName=" + this.getGroupName() + ", patrolPointStatus=" + this.getPatrolPointStatus() + ", eventTimeBegin=" + this.getEventTimeBegin() + ", eventTimeEnd=" + this.getEventTimeEnd() + ", likeName=" + this.getLikeName() + ")";
    }
}

