/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.io.FileInputStream;
import java.io.IOException;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.ccache.CCacheInputStream;
import sun.security.krb5.internal.ccache.FileCredentialsCache;

class KinitOptions {
    public boolean validate = false;
    public short forwardable = (short)-1;
    public short proxiable = (short)-1;
    public boolean renew = false;
    public KerberosTime lifetime;
    public KerberosTime renewable_lifetime;
    public String target_service;
    public String keytab_file;
    public String cachename;
    private PrincipalName principal;
    public String realm;
    char[] password = null;
    public boolean keytab;
    private boolean DEBUG = Krb5.DEBUG;
    private boolean includeAddresses = true;
    private boolean useKeytab = false;
    private String ktabName;

    public KinitOptions() throws RuntimeException, RealmException {
        this.cachename = FileCredentialsCache.getDefaultCacheName();
        if (this.cachename == null) {
            throw new RuntimeException("default cache name error");
        }
        this.principal = this.getDefaultPrincipal();
    }

    public void setKDCRealm(String r) throws RealmException {
        this.realm = r;
    }

    public String getKDCRealm() {
        if (this.realm == null && this.principal != null) {
            return this.principal.getRealmString();
        }
        return null;
    }

    public KinitOptions(String[] args) throws KrbException, RuntimeException, IOException {
        String p = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-f")) {
                this.forwardable = 1;
                continue;
            }
            if (args[i].equals("-p")) {
                this.proxiable = 1;
                continue;
            }
            if (args[i].equals("-c")) {
                if (args[i + 1].startsWith("-")) {
                    throw new IllegalArgumentException("input format  not correct:  -c  option must be followed by the cache name");
                }
                this.cachename = args[++i];
                if (this.cachename.length() < 5 || !this.cachename.substring(0, 5).equalsIgnoreCase("FILE:")) continue;
                this.cachename = this.cachename.substring(5);
                continue;
            }
            if (args[i].equals("-A")) {
                this.includeAddresses = false;
                continue;
            }
            if (args[i].equals("-k")) {
                this.useKeytab = true;
                continue;
            }
            if (args[i].equals("-t")) {
                if (this.ktabName != null) {
                    throw new IllegalArgumentException("-t option/keytab file name repeated");
                }
                if (i + 1 >= args.length) {
                    throw new IllegalArgumentException("-t option requires keytab file name");
                }
                this.ktabName = args[++i];
                this.useKeytab = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-help")) {
                this.printHelp();
                System.exit(0);
                continue;
            }
            if (p == null) {
                p = args[i];
                try {
                    this.principal = new PrincipalName(p);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("invalid Principal name: " + p + e.getMessage());
                }
            }
            if (this.password == null) {
                this.password = args[i].toCharArray();
                continue;
            }
            throw new IllegalArgumentException("too many parameters");
        }
        if (this.cachename == null) {
            this.cachename = FileCredentialsCache.getDefaultCacheName();
            if (this.cachename == null) {
                throw new RuntimeException("default cache name error");
            }
        }
        if (this.principal == null) {
            this.principal = this.getDefaultPrincipal();
        }
    }

    PrincipalName getDefaultPrincipal() {
        block12: {
            try {
                CCacheInputStream cis = new CCacheInputStream(new FileInputStream(this.cachename));
                int version = cis.readVersion();
                if (version == 1284) {
                    cis.readTag();
                } else if (version == 1281 || version == 1282) {
                    cis.setNativeByteOrder();
                }
                PrincipalName p = cis.readPrincipal(version);
                cis.close();
                if (this.DEBUG) {
                    System.out.println(">>>KinitOptions principal name from the cache is :" + p);
                }
                return p;
            }
            catch (IOException e) {
                if (this.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (RealmException e) {
                if (!this.DEBUG) break block12;
                e.printStackTrace();
            }
        }
        String username = System.getProperty("user.name");
        if (this.DEBUG) {
            System.out.println(">>>KinitOptions default username is :" + username);
        }
        try {
            PrincipalName p = new PrincipalName(username);
            return p;
        }
        catch (RealmException e) {
            if (this.DEBUG) {
                System.out.println("Exception in getting principal name " + e.getMessage());
                e.printStackTrace();
            }
            return null;
        }
    }

    void printHelp() {
        System.out.println("Usage: kinit [-A] [-f] [-p] [-c cachename] [[-k [-t keytab_file_name]] [principal] [password]");
        System.out.println("\tavailable options to Kerberos 5 ticket request:");
        System.out.println("\t    -A   do not include addresses");
        System.out.println("\t    -f   forwardable");
        System.out.println("\t    -p   proxiable");
        System.out.println("\t    -c   cache name (i.e., FILE:\\d:\\myProfiles\\mykrb5cache)");
        System.out.println("\t    -k   use keytab");
        System.out.println("\t    -t   keytab file name");
        System.out.println("\t    principal   the principal name (i.e., qweadf@ATHENA.MIT.EDU qweadf)");
        System.out.println("\t    password   the principal's Kerberos password");
    }

    public boolean getAddressOption() {
        return this.includeAddresses;
    }

    public boolean useKeytabFile() {
        return this.useKeytab;
    }

    public String keytabFileName() {
        return this.ktabName;
    }

    public PrincipalName getPrincipal() {
        return this.principal;
    }
}

