/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.ReplayCache;
import sun.security.krb5.internal.rcache.AuthTime;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class DflCache
extends ReplayCache {
    private static final int KRB5_RV_VNO = 1281;
    private static final int EXCESSREPS = 30;
    private final String source;
    private static int uid;

    public DflCache(String source) {
        this.source = source;
    }

    private static String defaultPath() {
        return AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir"));
    }

    private static String defaultFile(String server) {
        int slash = server.indexOf(47);
        if (slash == -1) {
            slash = server.indexOf(64);
        }
        if (slash != -1) {
            server = server.substring(0, slash);
        }
        if (uid != -1) {
            server = server + "_" + uid;
        }
        return server;
    }

    private static Path getFileName(String source, String server) {
        String file;
        String path;
        if (source.equals("dfl")) {
            path = DflCache.defaultPath();
            file = DflCache.defaultFile(server);
        } else if (source.startsWith("dfl:")) {
            source = source.substring(4);
            int pos = source.lastIndexOf(47);
            int pos1 = source.lastIndexOf(92);
            if (pos1 > pos) {
                pos = pos1;
            }
            if (pos == -1) {
                path = DflCache.defaultPath();
                file = source;
            } else if (new File(source).isDirectory()) {
                path = source;
                file = DflCache.defaultFile(server);
            } else {
                path = null;
                file = source;
            }
        } else {
            throw new IllegalArgumentException();
        }
        return new File(path, file).toPath();
    }

    @Override
    public void checkAndStore(KerberosTime currTime, AuthTimeWithHash time) throws KrbApErrException {
        try {
            this.checkAndStore0(currTime, time);
        }
        catch (IOException ioe) {
            KrbApErrException ke = new KrbApErrException(60);
            ke.initCause(ioe);
            throw ke;
        }
    }

    private synchronized void checkAndStore0(KerberosTime currTime, AuthTimeWithHash time) throws IOException, KrbApErrException {
        Path p = DflCache.getFileName(this.source, time.server);
        int missed = 0;
        try (Storage s = new Storage();){
            try {
                missed = s.loadAndCheck(p, time, currTime);
            }
            catch (IOException ioe) {
                Storage.create(p);
                missed = s.loadAndCheck(p, time, currTime);
            }
            s.append(time);
        }
        if (missed > 30) {
            Storage.expunge(p, currTime);
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.sun.security.auth.module.UnixSystem");
            uid = (int)((Long)clazz.getMethod("getUid", new Class[0]).invoke(clazz.newInstance(), new Object[0])).longValue();
        }
        catch (Exception e) {
            uid = -1;
        }
    }

    private static class Storage
    implements Closeable {
        SeekableByteChannel chan;

        private Storage() {
        }

        private static void create(Path p) throws IOException {
            SeekableByteChannel newChan = Storage.createNoClose(p);
            Throwable throwable = null;
            if (newChan != null) {
                if (throwable != null) {
                    try {
                        newChan.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    newChan.close();
                }
            }
            Storage.makeMine(p);
        }

        private static void makeMine(Path p) throws IOException {
            try {
                HashSet<PosixFilePermission> attrs = new HashSet<PosixFilePermission>();
                attrs.add(PosixFilePermission.OWNER_READ);
                attrs.add(PosixFilePermission.OWNER_WRITE);
                Files.setPosixFilePermissions(p, attrs);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        private static SeekableByteChannel createNoClose(Path p) throws IOException {
            SeekableByteChannel newChan = Files.newByteChannel(p, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            ByteBuffer buffer = ByteBuffer.allocate(6);
            buffer.putShort((short)1281);
            buffer.order(ByteOrder.nativeOrder());
            buffer.putInt(KerberosTime.getDefaultSkew());
            buffer.flip();
            newChan.write(buffer);
            return newChan;
        }

        private static void expunge(Path p, KerberosTime currTime) throws IOException {
            Path p2 = Files.createTempFile(p.getParent(), "rcache", null, new FileAttribute[0]);
            try (SeekableByteChannel oldChan = Files.newByteChannel(p, new OpenOption[0]);){
                SeekableByteChannel newChan = Storage.createNoClose(p2);
                Throwable throwable = null;
                try {
                    long timeLimit = currTime.getSeconds() - Storage.readHeader(oldChan);
                    try {
                        while (true) {
                            AuthTime at = AuthTime.readFrom(oldChan);
                            if ((long)at.ctime <= timeLimit) continue;
                            ByteBuffer bb = ByteBuffer.wrap(at.encode(true));
                            newChan.write(bb);
                        }
                    }
                    catch (BufferUnderflowException e) {
                        if (newChan != null) {
                            if (throwable != null) {
                                try {
                                    newChan.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                newChan.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (newChan != null) {
                            if (throwable != null) {
                                try {
                                    newChan.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                newChan.close();
                            }
                        }
                        throw throwable4;
                    }
                }
            }
            Storage.makeMine(p2);
            Files.move(p2, p, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }

        private int loadAndCheck(Path p, AuthTimeWithHash time, KerberosTime currTime) throws IOException, KrbApErrException {
            int missed = 0;
            if (Files.isSymbolicLink(p)) {
                throw new IOException("Symlink not accepted");
            }
            try {
                Set<PosixFilePermission> perms = Files.getPosixFilePermissions(p, new LinkOption[0]);
                if (uid != -1 && (Integer)Files.getAttribute(p, "unix:uid", new LinkOption[0]) != uid) {
                    throw new IOException("Not mine");
                }
                if (perms.contains((Object)PosixFilePermission.GROUP_READ) || perms.contains((Object)PosixFilePermission.GROUP_WRITE) || perms.contains((Object)PosixFilePermission.GROUP_EXECUTE) || perms.contains((Object)PosixFilePermission.OTHERS_READ) || perms.contains((Object)PosixFilePermission.OTHERS_WRITE) || perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
                    throw new IOException("Accessible by someone else");
                }
            }
            catch (UnsupportedOperationException perms) {
                // empty catch block
            }
            this.chan = Files.newByteChannel(p, StandardOpenOption.WRITE, StandardOpenOption.READ);
            long timeLimit = currTime.getSeconds() - Storage.readHeader(this.chan);
            long pos = 0L;
            boolean seeNewButNotSame = false;
            try {
                while (true) {
                    pos = this.chan.position();
                    AuthTime a = AuthTime.readFrom(this.chan);
                    if (a instanceof AuthTimeWithHash) {
                        if (time.equals(a)) {
                            throw new KrbApErrException(34);
                        }
                        if (time.isSameIgnoresHash(a)) {
                            seeNewButNotSame = true;
                        }
                    } else if (time.isSameIgnoresHash(a) && !seeNewButNotSame) {
                        throw new KrbApErrException(34);
                    }
                    if ((long)a.ctime < timeLimit) {
                        ++missed;
                        continue;
                    }
                    --missed;
                }
            }
            catch (BufferUnderflowException e) {
                this.chan.position(pos);
                return missed;
            }
        }

        private static int readHeader(SeekableByteChannel chan) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(6);
            chan.read(bb);
            if (bb.getShort(0) != 1281) {
                throw new IOException("Not correct rcache version");
            }
            bb.order(ByteOrder.nativeOrder());
            return bb.getInt(2);
        }

        private void append(AuthTimeWithHash at) throws IOException {
            ByteBuffer bb = ByteBuffer.wrap(at.encode(true));
            this.chan.write(bb);
            bb = ByteBuffer.wrap(at.encode(false));
            this.chan.write(bb);
        }

        @Override
        public void close() throws IOException {
            if (this.chan != null) {
                this.chan.close();
            }
            this.chan = null;
        }
    }
}

