/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.SortedMap;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.SunClipboard;
import sun.awt.windows.WDataTransferer;

final class WClipboard
extends SunClipboard {
    private boolean isClipboardViewerRegistered;

    WClipboard() {
        super("System");
    }

    @Override
    public long getID() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setContentsNative(Transferable contents) {
        SortedMap<Long, DataFlavor> formatMap = WDataTransferer.getInstance().getFormatsForTransferable(contents, WClipboard.getDefaultFlavorTable());
        this.openClipboard(this);
        try {
            for (Long format : formatMap.keySet()) {
                DataFlavor flavor = (DataFlavor)formatMap.get(format);
                try {
                    byte[] bytes = WDataTransferer.getInstance().translateTransferable(contents, flavor, format);
                    this.publishClipboardData(format, bytes);
                }
                catch (IOException e) {
                    if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref") && e instanceof NotSerializableException) continue;
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.closeClipboard();
        }
    }

    private void lostSelectionOwnershipImpl() {
        this.lostOwnershipImpl();
    }

    @Override
    protected void clearNativeContext() {
    }

    @Override
    public native void openClipboard(SunClipboard var1) throws IllegalStateException;

    @Override
    public native void closeClipboard();

    private native void publishClipboardData(long var1, byte[] var3);

    private static native void init();

    @Override
    protected native long[] getClipboardFormats();

    @Override
    protected native byte[] getClipboardData(long var1) throws IOException;

    @Override
    protected void registerClipboardViewerChecked() {
        if (!this.isClipboardViewerRegistered) {
            this.registerClipboardViewer();
            this.isClipboardViewerRegistered = true;
        }
    }

    private native void registerClipboardViewer();

    @Override
    protected void unregisterClipboardViewerChecked() {
    }

    private void handleContentsChanged() {
        if (!this.areFlavorListenersRegistered()) {
            return;
        }
        long[] formats = null;
        try {
            this.openClipboard(null);
            formats = this.getClipboardFormats();
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            this.closeClipboard();
        }
        this.checkChange(formats);
    }

    @Override
    protected Transferable createLocaleTransferable(long[] formats) throws IOException {
        boolean found = false;
        for (int i = 0; i < formats.length; ++i) {
            if (formats[i] != 16L) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        byte[] localeData = null;
        try {
            localeData = this.getClipboardData(16L);
        }
        catch (IOException ioexc) {
            return null;
        }
        final byte[] localeDataFinal = localeData;
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataTransferer.javaTextEncodingFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.equals(DataTransferer.javaTextEncodingFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(flavor)) {
                    return localeDataFinal;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }

    static {
        WClipboard.init();
    }
}

