/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.ChoicePeer;
import sun.awt.SunToolkit;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

final class WChoicePeer
extends WComponentPeer
implements ChoicePeer {
    private WindowListener windowListener;

    @Override
    public Dimension getMinimumSize() {
        FontMetrics fm = this.getFontMetrics(((Choice)this.target).getFont());
        Choice c = (Choice)this.target;
        int w = 0;
        int i = c.getItemCount();
        while (i-- > 0) {
            w = Math.max(fm.stringWidth(c.getItem(i)), w);
        }
        return new Dimension(28 + w, Math.max(fm.getHeight() + 6, 15));
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public native void select(int var1);

    @Override
    public void add(String item, int index) {
        this.addItem(item, index);
    }

    @Override
    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    @Override
    public native void removeAll();

    @Override
    public native void remove(int var1);

    public void addItem(String item, int index) {
        this.addItems(new String[]{item}, index);
    }

    public native void addItems(String[] var1, int var2);

    @Override
    public synchronized native void reshape(int var1, int var2, int var3, int var4);

    WChoicePeer(Choice target) {
        super(target);
    }

    @Override
    native void create(WComponentPeer var1);

    @Override
    void initialize() {
        WWindowPeer wpeer;
        Window parentWindow;
        Choice opt = (Choice)this.target;
        int itemCount = opt.getItemCount();
        if (itemCount > 0) {
            String[] items = new String[itemCount];
            for (int i = 0; i < itemCount; ++i) {
                items[i] = opt.getItem(i);
            }
            this.addItems(items, 0);
            if (opt.getSelectedIndex() >= 0) {
                this.select(opt.getSelectedIndex());
            }
        }
        if ((parentWindow = SunToolkit.getContainingWindow((Component)this.target)) != null && (wpeer = (WWindowPeer)parentWindow.getPeer()) != null) {
            this.windowListener = new WindowAdapter(){

                @Override
                public void windowIconified(WindowEvent e) {
                    WChoicePeer.this.closeList();
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    WChoicePeer.this.closeList();
                }
            };
            wpeer.addWindowListener(this.windowListener);
        }
        super.initialize();
    }

    @Override
    protected void disposeImpl() {
        WWindowPeer wpeer;
        Window parentWindow = SunToolkit.getContainingWindow((Component)this.target);
        if (parentWindow != null && (wpeer = (WWindowPeer)parentWindow.getPeer()) != null) {
            wpeer.removeWindowListener(this.windowListener);
        }
        super.disposeImpl();
    }

    void handleAction(final int index) {
        final Choice c = (Choice)this.target;
        WToolkit.executeOnEventHandlerThread(c, new Runnable(){

            @Override
            public void run() {
                c.select(index);
                WChoicePeer.this.postEvent(new ItemEvent(c, 701, c.getItem(index), 1));
            }
        });
    }

    int getDropDownHeight() {
        Choice c = (Choice)this.target;
        FontMetrics fm = this.getFontMetrics(c.getFont());
        int maxItems = Math.min(c.getItemCount(), 8);
        return fm.getHeight() * maxItems;
    }

    native void closeList();
}

