/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;

final class SimpleMethodHandle
extends BoundMethodHandle {
    static final BoundMethodHandle.SpeciesData SPECIES_DATA = BoundMethodHandle.SpeciesData.EMPTY;

    private SimpleMethodHandle(MethodType type, LambdaForm form) {
        super(type, form);
    }

    static BoundMethodHandle make(MethodType type, LambdaForm form) {
        return new SimpleMethodHandle(type, form);
    }

    @Override
    public BoundMethodHandle.SpeciesData speciesData() {
        return SPECIES_DATA;
    }

    @Override
    BoundMethodHandle copyWith(MethodType mt, LambdaForm lf) {
        return SimpleMethodHandle.make(mt, lf);
    }

    @Override
    String internalProperties() {
        return "\n& Class=" + this.getClass().getSimpleName();
    }

    @Override
    public int fieldCount() {
        return 0;
    }

    @Override
    final BoundMethodHandle copyWithExtendL(MethodType mt, LambdaForm lf, Object narg) {
        return BoundMethodHandle.bindSingle(mt, lf, narg);
    }

    @Override
    final BoundMethodHandle copyWithExtendI(MethodType mt, LambdaForm lf, int narg) {
        try {
            return SPECIES_DATA.extendWith(LambdaForm.BasicType.I_TYPE).constructor().invokeBasic(mt, lf, narg);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
    }

    @Override
    final BoundMethodHandle copyWithExtendJ(MethodType mt, LambdaForm lf, long narg) {
        try {
            return SPECIES_DATA.extendWith(LambdaForm.BasicType.J_TYPE).constructor().invokeBasic(mt, lf, narg);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
    }

    @Override
    final BoundMethodHandle copyWithExtendF(MethodType mt, LambdaForm lf, float narg) {
        try {
            return SPECIES_DATA.extendWith(LambdaForm.BasicType.F_TYPE).constructor().invokeBasic(mt, lf, narg);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
    }

    @Override
    final BoundMethodHandle copyWithExtendD(MethodType mt, LambdaForm lf, double narg) {
        try {
            return SPECIES_DATA.extendWith(LambdaForm.BasicType.D_TYPE).constructor().invokeBasic(mt, lf, narg);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
    }
}

