/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.SerializationTester;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

public class DragGestureEvent
extends EventObject {
    private static final long serialVersionUID = 9080172649166731306L;
    private transient List events;
    private DragSource dragSource;
    private Component component;
    private Point origin;
    private int action;

    public DragGestureEvent(DragGestureRecognizer dgr, int act, Point ori, List<? extends InputEvent> evs) {
        super(dgr);
        this.component = dgr.getComponent();
        if (this.component == null) {
            throw new IllegalArgumentException("null component");
        }
        this.dragSource = dgr.getDragSource();
        if (this.dragSource == null) {
            throw new IllegalArgumentException("null DragSource");
        }
        if (evs == null || evs.isEmpty()) {
            throw new IllegalArgumentException("null or empty list of events");
        }
        if (act != 1 && act != 2 && act != 0x40000000) {
            throw new IllegalArgumentException("bad action");
        }
        if (ori == null) {
            throw new IllegalArgumentException("null origin");
        }
        this.events = evs;
        this.action = act;
        this.origin = ori;
    }

    public DragGestureRecognizer getSourceAsDragGestureRecognizer() {
        return (DragGestureRecognizer)this.getSource();
    }

    public Component getComponent() {
        return this.component;
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public Point getDragOrigin() {
        return this.origin;
    }

    public Iterator<InputEvent> iterator() {
        return this.events.iterator();
    }

    public Object[] toArray() {
        return this.events.toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.events.toArray(array);
    }

    public int getDragAction() {
        return this.action;
    }

    public InputEvent getTriggerEvent() {
        return this.getSourceAsDragGestureRecognizer().getTriggerEvent();
    }

    public void startDrag(Cursor dragCursor, Transferable transferable) throws InvalidDnDOperationException {
        this.dragSource.startDrag(this, dragCursor, transferable, null);
    }

    public void startDrag(Cursor dragCursor, Transferable transferable, DragSourceListener dsl) throws InvalidDnDOperationException {
        this.dragSource.startDrag(this, dragCursor, transferable, dsl);
    }

    public void startDrag(Cursor dragCursor, Image dragImage, Point imageOffset, Transferable transferable, DragSourceListener dsl) throws InvalidDnDOperationException {
        this.dragSource.startDrag(this, dragCursor, dragImage, imageOffset, transferable, dsl);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(SerializationTester.test(this.events) ? this.events : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        List newEvents;
        ObjectInputStream.GetField f = s.readFields();
        DragSource newDragSource = (DragSource)f.get("dragSource", null);
        if (newDragSource == null) {
            throw new InvalidObjectException("null DragSource");
        }
        this.dragSource = newDragSource;
        Component newComponent = (Component)f.get("component", null);
        if (newComponent == null) {
            throw new InvalidObjectException("null component");
        }
        this.component = newComponent;
        Point newOrigin = (Point)f.get("origin", null);
        if (newOrigin == null) {
            throw new InvalidObjectException("null origin");
        }
        this.origin = newOrigin;
        int newAction = f.get("action", 0);
        if (newAction != 1 && newAction != 2 && newAction != 0x40000000) {
            throw new InvalidObjectException("bad action");
        }
        this.action = newAction;
        try {
            newEvents = (List)f.get("events", null);
        }
        catch (IllegalArgumentException e) {
            newEvents = (List)s.readObject();
        }
        if (newEvents != null && newEvents.isEmpty()) {
            throw new InvalidObjectException("empty list of events");
        }
        if (newEvents == null) {
            newEvents = Collections.emptyList();
        }
        this.events = newEvents;
    }
}

