/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccParamRemote;
import com.zkteco.zkbiosecurity.acc.service.AccLinkageService;
import com.zkteco.zkbiosecurity.acc.service.AccParamService;
import com.zkteco.zkbiosecurity.acc.service.AccTransactionAutoExportService;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccParamController
extends BaseController
implements AccParamRemote {
    @Autowired
    private AccParamService accParamService;
    @Autowired
    private AccLinkageService accLinkageService;
    @Autowired
    private AccTransactionAutoExportService accTransactionAutoExportService;

    @RequiresPermissions(value={"acc:param:refresh"})
    public ModelAndView index() {
        Map accParams = this.accParamService.getAccParams();
        this.request.setAttribute("accParams", (Object)accParams);
        this.request.setAttribute("showSMS", (Object)this.accLinkageService.checkShowSMS());
        this.request.setAttribute("transactionAutoExportEnable", (Object)StringUtils.isNotBlank((CharSequence)this.accTransactionAutoExportService.createCron()));
        return new ModelAndView("acc/param/accParams");
    }

    @RequiresPermissions(value={"acc:param:edit"})
    @LogRequest(module="acc_module", object="common_leftMenu_paramSet", opType="common_op_edit", opContent="common_op_edit")
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        String downNewLogHours = this.request.getParameter("down_event_hours");
        params.put("acc.downNewlog", downNewLogHours);
        StringBuffer StrBuf = new StringBuffer("0 0 ").append(downNewLogHours).append(" * * ?");
        params.put("acc.downNewLogExpression", StrBuf.toString());
        String receiver = this.request.getParameter("mail");
        if (receiver != null) {
            params.put("acc.receiver", receiver.replaceAll(";", ","));
        } else {
            params.put("acc.receiver", "");
        }
        String smsReceiver = this.request.getParameter("smsReceiver");
        if (StringUtils.isNotBlank((CharSequence)smsReceiver)) {
            params.put("acc.smsReceiver", smsReceiver.replaceAll(";", ","));
        } else {
            params.put("acc.smsReceiver", "");
        }
        this.accParamService.saveItem(params);
        this.accTransactionAutoExportService.changeAutoProcessorTime();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

