/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccDeviceEventRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceEventService;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceEventItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccDeviceEventController
extends BaseController
implements AccDeviceEventRemote {
    @Autowired
    private AccDeviceEventService accDeviceEventService;

    @RequiresPermissions(value={"acc:deviceEvent"})
    public ModelAndView index() {
        return new ModelAndView("acc/deviceEvent/accDeviceEvent");
    }

    @RequiresPermissions(value={"acc:deviceEvent:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accDeviceEventService.getItemById(id));
        }
        return new ModelAndView("acc/deviceEvent/editAccDeviceEvent");
    }

    @RequiresPermissions(value={"acc:deviceEvent:edit"})
    @LogRequest(module="acc_module", object="common_leftMenu_event", opType="common_op_edit", requestParams={"name"}, opContent="common_event_name")
    public ZKResultMsg save(AccDeviceEventItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String fileOpType = this.request.getParameter("opType");
        String syncAllDevic = this.request.getParameter("syncAllDevic");
        this.accDeviceEventService.saveItem(item, fileOpType, syncAllDevic);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:deviceEvent:refresh"})
    public DxGrid list(AccDeviceEventItem codition) {
        Pager pager = this.accDeviceEventService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:deviceEvent:del"})
    public ZKResultMsg del(String ids) {
        this.accDeviceEventService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:deviceEvent:setSound"})
    public ZKResultMsg setSound(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String fileOpType = this.request.getParameter("opType");
            String baseMediaFileId = this.request.getParameter("baseMediaFileId");
            String baseMediaFileName = this.request.getParameter("baseMediaFileName");
            String baseMediaFilePath = this.request.getParameter("baseMediaFilePath");
            String baseMediaFileSize = this.request.getParameter("baseMediaFileSize");
            String baseMediaFileSuffix = this.request.getParameter("baseMediaFileSuffix");
            this.accDeviceEventService.setSound(ids, fileOpType, baseMediaFileId, baseMediaFileName, baseMediaFilePath, baseMediaFileSize, baseMediaFileSuffix);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem tree() {
        List eventList = this.accDeviceEventService.getAllEventNameDistinct();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (AccDeviceEventItem event : eventList) {
            TreeItem item = new TreeItem();
            item.setId(event.getName());
            item.setText(I18nUtil.i18nCode((String)event.getName(), (Object[])new Object[0]));
            item.setParent(new TreeItem("0"));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }
}

