/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.api.controller;

import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/accLevel"})
public class AccCloudApiLevelController {
    private static final Logger log = LoggerFactory.getLogger(AccCloudApiLevelController.class);
    @Autowired
    private AccLevelService accLevelService;

    @ResponseBody
    @ApiPermissions(moduleCode="acc", moduleName="acc_module")
    @RequestMapping(value={"/getLevelByAuth"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getLevelByAuth(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg rs = null;
        try {
            Map dataMap = zkMessage.getContent();
            String areaCodes = (String)dataMap.get("areaCodes");
            int page = (Integer)dataMap.get("page");
            int pageSize = (Integer)dataMap.get("pageSize");
            rs = this.accLevelService.getLevelByAreaCodes(areaCodes, page, pageSize);
        }
        catch (Exception e) {
            log.error("api accLevel/getLevelByAuth error ", (Throwable)e);
            rs = ZKResultMsg.failMsg();
        }
        return I18nUtil.i18nMsg((ZKResultMsg)rs);
    }

    @ResponseBody
    @ApiPermissions(moduleCode="acc", moduleName="acc_module")
    @RequestMapping(value={"/getPersonLevelDoor"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getPersonLevelDoor(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg rs = null;
        try {
            Map dataMap = zkMessage.getContent();
            String personPin = (String)dataMap.get("personPin");
            boolean isAdmin = MapUtils.getBoolean((Map)dataMap, (Object)"isAdmin", (Boolean)false);
            rs = this.accLevelService.getPersonLevelDoor(personPin, isAdmin);
        }
        catch (Exception e) {
            log.error("api accLevel/getPersonLevelDoor error ", (Throwable)e);
            rs = ZKResultMsg.failMsg();
        }
        return I18nUtil.i18nMsg((ZKResultMsg)rs);
    }

    @ResponseBody
    @ApiPermissions(moduleCode="acc", moduleName="acc_module")
    @RequestMapping(value={"/getLevelByPin"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getLevelByPin(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg rs = null;
        try {
            Map dataMap = zkMessage.getContent();
            String personPins = (String)dataMap.get("personPins");
            rs = this.accLevelService.getLevelByPersonPin(personPins);
        }
        catch (Exception e) {
            log.error("api accLevel/getPersonLevelDoor error ", (Throwable)e);
            rs = ZKResultMsg.failMsg();
        }
        return I18nUtil.i18nMsg((ZKResultMsg)rs);
    }
}

