/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.chausie;

import com.zkteco.zkbiosecurity.guard.chausie.JarSignatureValidator;
import com.zkteco.zkbiosecurity.guard.chausie.exceptions.ValidatorException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class VerifyJar {
    public static final String VERIFIED = "valid";
    public String file;
    private final JarSignatureValidator jv = new JarSignatureValidator();
    private boolean quiet = false;

    private static String getBuildDate() {
        try {
            URLClassLoader cl = (URLClassLoader)VerifyJar.class.getClassLoader();
            URL url = cl.findResource("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(url.openStream());
            return manifest.getMainAttributes().getValue("Built-Date");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getVersion() {
        String version = VerifyJar.class.getPackage().getImplementationVersion();
        return version == null ? "0.0.0" : version;
    }

    public static void main(String[] args) throws Exception {
        VerifyJar v = new VerifyJar();
        v.parseParameters(args);
        if (v.file == null) {
            VerifyJar.showHelp();
            System.exit(-1);
        }
        v.run();
    }

    private static void showHelp() {
        String dt = VerifyJar.getBuildDate();
        System.err.println("chausie Jar Verifier " + VerifyJar.getVersion() + (dt == null ? "" : " (" + dt + ")"));
        System.err.println("Usage:");
        System.err.println("   verify_jar <parameters> <jar_file>");
        System.err.println("Parameters:");
        System.err.println("  -trusted-keystore <file>  :  keystore with trusted CA certificates");
        System.err.println("  -ocsp  :  use OCSP for certificate verification");
        System.err.println("  -ocsp-responder <url>  :  OCSP responder to use (default: from the signer's certificate)");
        System.err.println("  -crl <file>  :  certificate revocation list file");
        System.err.println("  -skip-key-usage  :  do not check key usage attributes on the signer certificate");
        System.err.println("  -quiet  :  write nothing to stdout and limit warning messages");
        System.err.println("  -skip-trust-check  :  skip certificate trust check");
        System.err.println("  -time <time>  :  check signature validity at the given point in time (yyyy-MM-dd[ HH:mm[:ss[.S]]])");
        System.err.println("  -debug  :  print debug information");
    }

    private Date parseDate(String d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        try {
            return sdf.parse(d);
        }
        catch (Exception exception) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return sdf.parse(d);
            }
            catch (Exception exception2) {
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                try {
                    return sdf.parse(d);
                }
                catch (Exception exception3) {
                    sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        return sdf.parse(d);
                    }
                    catch (Exception exception4) {
                        return null;
                    }
                }
            }
        }
    }

    public void parseParameters(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String par = args[i];
            if ("-skip-trust-check".equalsIgnoreCase(par)) {
                this.jv.setSkipTrustCheck(true);
                continue;
            }
            if ("-date".equalsIgnoreCase(par)) {
                String d = args[++i];
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    d = d + " " + args[++i];
                }
                this.jv.setVerificationDate(this.parseDate(d));
                continue;
            }
            if ("-quiet".equalsIgnoreCase(par)) {
                this.quiet = true;
                this.jv.setQuiet(this.quiet);
                continue;
            }
            if ("-debug".equalsIgnoreCase(par)) {
                Logger logger = Logger.getLogger("");
                ConsoleHandler handler = new ConsoleHandler();
                handler.setFormatter(new MyFormatter());
                handler.setLevel(Level.ALL);
                logger.addHandler(handler);
                logger.setLevel(Level.ALL);
                continue;
            }
            if ("-trusted-keystore".equalsIgnoreCase(par)) {
                this.jv.setTrustedKeystore(args[++i]);
                continue;
            }
            if ("-ocsp".equalsIgnoreCase(par)) {
                this.jv.setUseOCSP(true);
                continue;
            }
            if ("-ocsp-responder".equalsIgnoreCase(par)) {
                this.jv.setUseOCSP(true);
                this.jv.setOcspResponderURL(args[++i]);
                continue;
            }
            if ("-crl".equalsIgnoreCase(par)) {
                this.jv.getCrlFileNames().add(args[++i]);
                continue;
            }
            if ("-skip-key-usage".equalsIgnoreCase(par)) {
                this.jv.setSkipCertUsage(true);
                continue;
            }
            if (this.file == null && !par.startsWith("-")) {
                this.file = par;
                continue;
            }
            System.err.println("Unkown command '" + par + "'");
            VerifyJar.showHelp();
            System.exit(255);
        }
    }

    private void run() {
        try {
            this.jv.verifyJar(new JarFile(this.file));
            if (!this.quiet) {
                System.out.println(VERIFIED);
            }
            System.exit(0);
        }
        catch (ValidatorException e) {
            String errMsg = e.getStdErrMessage();
            String outMsg = e.getStdOutMessage();
            int code = e.getExitCode();
            if (!this.quiet && outMsg != null) {
                System.out.println(outMsg);
            }
            if (errMsg != null) {
                System.err.println(errMsg);
            }
            System.exit(code);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (!this.quiet) {
                System.out.println("error");
            }
            System.exit(6);
        }
    }

    private static class MyFormatter
    extends Formatter {
        private final DateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");

        private MyFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder builder = new StringBuilder(1000);
            builder.append(this.df.format(new Date(record.getMillis()))).append(" - ");
            builder.append("[").append(record.getSourceClassName()).append(".");
            builder.append(record.getSourceMethodName()).append("] - ");
            builder.append("[").append(record.getLevel()).append("] - ");
            builder.append(this.formatMessage(record));
            builder.append("\n");
            if (record.getThrown() != null) {
                builder.append(" Exception! " + record.getThrown().getMessage());
            }
            return builder.toString();
        }

        @Override
        public String getHead(Handler h) {
            return super.getHead(h);
        }

        @Override
        public String getTail(Handler h) {
            return super.getTail(h);
        }
    }
}

