/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vid.remote.VidTransactionRemote;
import com.zkteco.zkbiosecurity.vid.service.VidTransactionService;
import com.zkteco.zkbiosecurity.vid.vo.VidTransactionItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VidTransactionController
extends BaseController
implements VidTransactionRemote {
    @Autowired
    private VidTransactionService vidTransactionService;

    @RequiresPermissions(value={"vid:transaction"})
    public ModelAndView index() {
        return new ModelAndView("vid/transaction/vidTransaction");
    }

    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.vidTransactionService.getItemById(id));
        }
        return new ModelAndView("vid/transaction/editVidTransaction");
    }

    public ZKResultMsg save(VidTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.vidTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(VidTransactionItem condition) {
        if (Objects.nonNull(condition.getFileType()) && condition.getFileType() == 2) {
            condition.setStatus(Short.valueOf((short)0));
        }
        if (condition.getFileType() != null && condition.getFileType() != 1 && condition.getFileType() != 2) {
            condition.setFileType(null);
        }
        Pager pager = this.vidTransactionService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="vid_module", object="vid_leftMenu_vidTransaction", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData(@RequestParam(value="ids") String ids) {
        this.vidTransactionService.clearData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAllCapture(VidTransactionItem condition) {
        ZKResultMsg ret = new ZKResultMsg();
        condition.setStatus(Short.valueOf((short)0));
        if (condition.getFileType() != 1 && condition.getFileType() != 2) {
            condition.setFileType(null);
        }
        String currentPage = this.request.getParameter("currentPage");
        String pageSizeStr = this.request.getParameter("pageSize");
        int pageNo = StringUtils.isBlank((CharSequence)currentPage) ? 0 : Integer.valueOf(currentPage);
        int pageSize = StringUtils.isBlank((CharSequence)pageSizeStr) ? 50 : Integer.valueOf(pageSizeStr);
        Pager pager = this.vidTransactionService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, pageNo, pageSize);
        List vidTransactionItemList = pager.getData();
        for (VidTransactionItem vidTransactionItem : vidTransactionItemList) {
            vidTransactionItem.setStartTimeStr(DateUtil.dateToString((Date)vidTransactionItem.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        ret.setData((Object)vidTransactionItemList);
        return ret;
    }

    public ZKResultMsg isExistCapture() {
        File file;
        String filePath;
        ZKResultMsg ret = new ZKResultMsg();
        String id = this.request.getParameter("id");
        VidTransactionItem vidTransaction = this.vidTransactionService.getItemById(id);
        if (null != vidTransaction && StringUtils.isNotBlank((CharSequence)(filePath = vidTransaction.getFilePath())) && !(file = new File(filePath)).exists()) {
            ret.setRet("fail");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVidCapture() {
        FileInputStream fStream = null;
        try {
            String id = this.request.getParameter("id");
            String ptype = this.request.getParameter("ptype");
            VidTransactionItem vidTransaction = this.vidTransactionService.getItemById(id);
            String filePath = vidTransaction.getFilePath();
            File file = new File(filePath);
            if (ptype != null) {
                int index = filePath.lastIndexOf(File.separator);
                String newFilePath = filePath.substring(0, index) + File.separator + ptype + filePath.substring(index);
                File newFile = new File(newFilePath);
                if (newFile.exists()) {
                    file = newFile;
                } else if (file.exists()) {
                    File f = new File(filePath.substring(0, index) + File.separator + ptype);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    ImgEncodeUtil.createZoomImage((File)file, (File)newFile, (int)160, (int)120);
                    file = newFile;
                }
            }
            fStream = new FileInputStream(file);
            int lenght = fStream.available();
            byte[] data = new byte[lenght];
            fStream.read(data);
            this.response.getOutputStream().write(data);
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        finally {
            if (fStream != null) {
                try {
                    fStream.close();
                }
                catch (IOException e) {
                    this.log.error("exception", (Throwable)e);
                }
            }
        }
        return null;
    }

    public ZKResultMsg getVideoFile() {
        String id = this.request.getParameter("id");
        Map retMap = this.vidTransactionService.getVideoFileValidate(id);
        ZKResultMsg ret = (ZKResultMsg)retMap.get("ret");
        if (null != ret) {
            return I18nUtil.i18nMsg((ZKResultMsg)ret);
        }
        String filePath = retMap.get("filePath").toString();
        File file = (File)retMap.get("file");
        int index = filePath.lastIndexOf(File.separator);
        String fileName = filePath.substring(index + 1);
        if (file.isDirectory() && file.listFiles().length > 0) {
            File childFile = file.listFiles()[0];
            fileName = fileName.substring(0, fileName.lastIndexOf(".")) + childFile.getName().substring(childFile.getName().lastIndexOf("."));
        }
        this.response.setCharacterEncoding("utf-8");
        this.response.setContentType("multipart/form-data");
        this.response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        try {
            int length;
            FileInputStream inputStream = new FileInputStream(filePath);
            ServletOutputStream os = this.response.getOutputStream();
            byte[] b = new byte[2048];
            while ((length = ((InputStream)inputStream).read(b)) > 0) {
                os.write(b, 0, length);
            }
            os.close();
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        return null;
    }

    public InputStream getDownVideoFile() {
        String filePath = this.request.getParameter("filePath");
        FileInputStream fStream = null;
        File file = new File(filePath);
        try {
            if (file.isFile()) {
                fStream = new FileInputStream(file);
            } else if (file.listFiles().length > 0) {
                fStream = new FileInputStream(file.listFiles()[0]);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        return fStream;
    }

    public String batchDownloadPic(@RequestParam(value="ids") String ids) {
        this.vidTransactionService.batchDownloadPic(ids);
        return null;
    }
}

