/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cmd.sec.multimcard;

import com.zkteco.zkbiosecurity.cmd.sec.device.CmdDevice;
import com.zkteco.zkbiosecurity.cmd.sec.doorparameters.CmdDoorParameters;
import com.zkteco.zkbiosecurity.cmd.sec.doorparameters.CmdDoorParametersConstructor;
import com.zkteco.zkbiosecurity.cmd.sec.multimcard.CmdMultimCard;
import java.util.ArrayList;
import java.util.Collection;

public class CmdMultimCardConstructor {
    public static String setCmdMultimCard(CmdDevice cmdDevice, Collection<CmdMultimCard> cmdMultimCards) {
        if (cmdMultimCards != null && cmdMultimCards.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            cmdMultimCards.stream().forEach(cmdMultimCard -> {
                String cmd = String.format("Index=%d\tDoorId=%d\tGroup1=%d\tGroup2=%d\tGroup3=%d\tGroup4=%d\tGroup5=%d\r\n", cmdMultimCard.getIndex(), cmdMultimCard.getDoorNo(), cmdMultimCard.getGroup1(), cmdMultimCard.getGroup2(), cmdMultimCard.getGroup3(), cmdMultimCard.getGroup4(), cmdMultimCard.getGroup5());
                if ("1".equals(cmdDevice.getAccSupportFunList(26))) {
                    cmd = cmd.replace("\r\n", "\tDevID=" + cmdMultimCard.getDevId() + "\r\n");
                }
                cmdContent.append(cmd);
            });
            return CmdMultimCard.SET_MULTIMPERSON_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delMultimCard(Collection<Long> indexs) {
        if (indexs != null && indexs.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            indexs.forEach(index -> cmdContent.append(String.format("Index=%s", index)));
            return CmdMultimCard.DEL_MULTIMPERSON_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delAllMultimCard() {
        return CmdMultimCard.DEL_MULTIMPERSON_HEAD + "*\r\n";
    }

    private static String setMultimCardOpt(CmdDevice cmdDevice, Collection<Short> doorNos, boolean openOrClose) {
        if (doorNos != null && doorNos.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            ArrayList<CmdDoorParameters> cmdDoorParametersList = new ArrayList<CmdDoorParameters>();
            doorNos.forEach(doorNo -> {
                if ("1".equals(cmdDevice.getAccSupportFunList(21))) {
                    cmdDoorParametersList.add(new CmdDoorParameters((Short)doorNo, "DoorMultiCardOpenDoor", openOrClose ? "1" : "0", cmdDevice.getId()));
                } else {
                    cmdContent.append(String.format("Door%sMultiCardOpenDoor=%s", doorNo, openOrClose ? "1" : "0") + ",");
                }
            });
            if ("1".equals(cmdDevice.getAccSupportFunList(21))) {
                return CmdDoorParametersConstructor.setDoorParameters(cmdDevice, cmdDoorParametersList);
            }
            String tempCmd = cmdContent.toString();
            return "SET OPTIONS " + tempCmd.substring(0, tempCmd.length() - 1) + "\r\n";
        }
        return null;
    }

    public static String enableMultimCard(CmdDevice cmdDevice, Collection<Short> doorNos) {
        return CmdMultimCardConstructor.setMultimCardOpt(cmdDevice, doorNos, true);
    }

    public static String disableMultimCard(CmdDevice cmdDevice, Collection<Short> doorNos) {
        return CmdMultimCardConstructor.setMultimCardOpt(cmdDevice, doorNos, false);
    }
}

