/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkShopRemote;
import com.zkteco.zkbiosecurity.park.service.ParkShopService;
import com.zkteco.zkbiosecurity.park.vo.ParkShopItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkShopController
extends BaseController
implements ParkShopRemote {
    @Autowired
    private ParkShopService parkShopService;

    @RequiresPermissions(value={"park:shop"})
    public ModelAndView index() {
        return new ModelAndView("park/shop/parkShop");
    }

    @RequiresPermissions(value={"park:shop:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkShopService.getItemById(id));
        }
        return new ModelAndView("park/shop/editParkShop");
    }

    @RequiresPermissions(value={"park:shop:edit"})
    @LogRequest(module="park_module", object="park_shop", opType="park_shop_edit", requestParams={"name"}, opContent="park_shop_name")
    public ZKResultMsg save(ParkShopItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkShopService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"park:shop:refresh"})
    public DxGrid list(ParkShopItem codition) {
        Pager pager = this.parkShopService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_shop", opType="park_shop_del", requestParams={"names"}, opContent="park_shop_del")
    @RequiresPermissions(value={"park:shop:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkShopService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkShopService.isNotExist(name);
    }

    public ZKResultMsg getAllShop() {
        List selectItems = this.parkShopService.getAllShop();
        return new ZKResultMsg((Object)selectItems);
    }
}

