/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkProvinceRemote;
import com.zkteco.zkbiosecurity.park.service.ParkProvinceService;
import com.zkteco.zkbiosecurity.park.vo.ParkProvinceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkProvinceController
extends BaseController
implements ParkProvinceRemote {
    @Autowired
    private ParkProvinceService parkProvinceService;

    @RequiresPermissions(value={"park:province"})
    public ModelAndView index() {
        return new ModelAndView("park/province/parkProvince");
    }

    @RequiresPermissions(value={"park:province:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkProvinceService.getItemById(id));
        }
        return new ModelAndView("park/province/editParkProvince");
    }

    @RequiresPermissions(value={"park:province:edit"})
    @LogRequest(module="park_module", object="park_province", opType="common_op_edit", requestParams={"dictValue"}, opContent="park_province_name")
    public ZKResultMsg save(ParkProvinceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkProvinceService.saveItem(item);
        this.parkProvinceService.updateProvinceDictionary();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"park:province:refresh"})
    public DxGrid list(ParkProvinceItem condition) {
        Pager pager = this.parkProvinceService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="park_module", object="park_province", opType="common_op_del", requestParams={"names"}, opContent="park_province_name")
    @RequiresPermissions(value={"park:province:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkProvinceService.deleteByIds(ids);
        this.parkProvinceService.updateProvinceDictionary();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(@RequestParam(value="dictValue", required=false) String dictValue) {
        return this.parkProvinceService.isNotExist(dictValue);
    }
}

