/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.park.remote.ParkMonthlyReportRemote;
import com.zkteco.zkbiosecurity.park.service.ParkMonthlyReportService;
import com.zkteco.zkbiosecurity.park.vo.ParkMonthlyReportItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkMonthlyReportController
extends ExportController
implements ParkMonthlyReportRemote {
    @Autowired
    private ParkMonthlyReportService parkMonthlyReportService;

    @RequiresPermissions(value={"park:monthlyReport"})
    public ModelAndView index() {
        return new ModelAndView("park/monthlyReport/parkMonthlyReport");
    }

    public DxGrid list(ParkMonthlyReportItem codition) {
        Pager pager = this.parkMonthlyReportService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_leftMenu_monthlyReport", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"park:monthlyReport:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        ParkMonthlyReportItem parkMonthlyReportItem = new ParkMonthlyReportItem();
        this.setConditionValue((BaseItem)parkMonthlyReportItem);
        List itemList = this.parkMonthlyReportService.getItemsDataBySql(parkMonthlyReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, ParkMonthlyReportItem.class);
    }
}

