/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkDisplayDeviceRemote;
import com.zkteco.zkbiosecurity.park.service.ParkDisplayDeviceService;
import com.zkteco.zkbiosecurity.park.vo.ParkDisplayDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkDisplayDeviceController
extends BaseController
implements ParkDisplayDeviceRemote {
    @Autowired
    private ParkDisplayDeviceService parkDisplayDeviceService;

    @RequiresPermissions(value={"park:displayDevice"})
    public ModelAndView index() {
        return new ModelAndView("park/displayDevice/parkDisplayDevice");
    }

    @RequiresPermissions(value={"park:displayDevice:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkDisplayDeviceService.getItemById(id));
        }
        return new ModelAndView("park/displayDevice/editParkDisplayDevice");
    }

    @RequiresPermissions(value={"park:displayDevice:edit"})
    @LogRequest(module="park_module", object="park_displayDevice", opType="common_op_edit", requestParams={"name"}, opContent="park_device_name")
    public ZKResultMsg save(ParkDisplayDeviceItem item) {
        this.parkDisplayDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid list(ParkDisplayDeviceItem codition) {
        Pager pager = this.parkDisplayDeviceService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:displayDevice:del"})
    @LogRequest(module="park_module", object="park_displayDevice", opType="common_op_del", requestParams={"names"}, opContent="park_device_name")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkDisplayDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkDisplayDeviceService.isNotExist(name);
    }

    public boolean isNotExistIP(@RequestParam(value="ipAddress") String ipAddress) {
        return this.parkDisplayDeviceService.isNotExistIP(ipAddress);
    }
}

