/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkChannelAccModelRemote;
import com.zkteco.zkbiosecurity.park.service.ParkChannelService;
import com.zkteco.zkbiosecurity.park.vo.ParkChannelAccModelItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkChannelAccModelController
extends BaseController
implements ParkChannelAccModelRemote {
    @Autowired
    private ParkChannelService parkChannelService;

    @RequiresPermissions(value={"park:channel"})
    public ModelAndView index() {
        return new ModelAndView("park/channel/parkChannelAccModel");
    }

    @RequiresPermissions(value={"park:channel:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        this.request.setAttribute("item", (Object)this.parkChannelService.getItemByIdAccModel(id));
        return new ModelAndView("park/channel/editParkChannelAccModel");
    }

    @RequiresPermissions(value={"park:channel:edit"})
    public ZKResultMsg save(ParkChannelAccModelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkChannelService.saveItemAccModel(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(ParkChannelAccModelItem codition) {
        Pager pager = this.parkChannelService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkChannelService.deleteByIdsAccModel(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

