/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkBlackWhiteRemote;
import com.zkteco.zkbiosecurity.park.service.ParkBlackWhiteService;
import com.zkteco.zkbiosecurity.park.utils.ParkI18nUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkBlackWhiteItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkBlackWhiteController
extends BaseController
implements ParkBlackWhiteRemote {
    @Autowired
    private ParkBlackWhiteService parkBlackWhiteService;

    @RequiresPermissions(value={"park:blackWhite"})
    public ModelAndView index() {
        return new ModelAndView("park/blackWhite/parkBlackWhite");
    }

    @RequiresPermissions(value={"park:blackWhite:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        ParkBlackWhiteItem item = this.parkBlackWhiteService.getItemById(id);
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("park/blackWhite/editParkBlackWhite");
    }

    @RequiresPermissions(value={"park:blackWhite:edit"})
    @LogRequest(module="park_module", object="park_blackWhite", opType="park_blackWhite_edit", requestParams={"carNumber"}, opContent="park_carNumber")
    public ZKResultMsg save(ParkBlackWhiteItem item) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemtList = (List)this.parkBlackWhiteService.saveItem(item).getData();
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemtList));
        return res;
    }

    public DxGrid list(ParkBlackWhiteItem codition) {
        Pager pager = this.parkBlackWhiteService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:blackWhite:del"})
    @LogRequest(module="park_module", object="park_blackWhite", opType="park_blackWhite_del", requestParams={"names"}, opContent="park_blackWhite_del")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemtList = this.parkBlackWhiteService.delByIds(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemtList));
        return res;
    }

    public boolean isNotExist(@RequestParam(value="carNumber", required=false) String carNumber) {
        return this.parkBlackWhiteService.isNotExist(carNumber);
    }

    @RequiresPermissions(value={"park:blackWhite:syncWhite"})
    public ZKResultMsg syncWhite() {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemtList = this.parkBlackWhiteService.syncWhite();
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemtList));
        return res;
    }

    @RequiresPermissions(value={"park:blackWhite:syncBlack"})
    public ZKResultMsg syncBlack() {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemtList = this.parkBlackWhiteService.syncBlack();
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemtList));
        return res;
    }
}

