/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.websocket;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.sis.util.SicmConstUtil;
import com.zkteco.zkbiosecurity.sis.util.SicmDataUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.apache.log4j.Logger;
import org.springframework.data.redis.core.StringRedisTemplate;

public abstract class SicmWebsocketInfo {
    public StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringUtil.getBean((String)"stringRedisTemplate");
    public String SN;
    public short connect = 0;
    public String actionName = "CONNECT";
    public String actionNo = "1001";
    public static int onlineWSCount;
    public static Map<String, SicmWebsocketInfo> totalWebsocketInfoMap;
    public final Logger logger = Logger.getLogger(this.getClass());
    public static final String module = "sis";
    public long heartbeat = 0L;
    public int heartbeatDif = 60000;
    public String rtLogQueneName = "RT_LOGS_" + "sis".toUpperCase();
    public static final Set<String> activeQueneNameSet;
    public String dangerQueneName = "DANGER_LOGS_" + "sis".toUpperCase();
    public static final Set<String> dangerQueneNameSet;
    public String queryQueneName = "QUERY_LOGS_" + "sis".toUpperCase();
    public static final Set<String> queryQueneNameSet;

    public int getOnlineWSCount() {
        return onlineWSCount;
    }

    public abstract void sendMsg(ByteBuffer var1);

    public abstract void sendMsg(String var1);

    public abstract void onClose(Session var1, CloseReason var2) throws Exception;

    public void updateDevOperateState(String actionName, String actionNo) {
        try {
            if (!this.actionName.equals(actionName) || !this.actionNo.equals(actionNo)) {
                JSONObject devStateJson = new JSONObject();
                String devStateKey = "SIS_DEV_OPERATE_STATE_" + this.SN;
                if (("-1001".equals(actionNo) || "-307".equals(actionNo)) && module.equals(module)) {
                    String string = DateUtil.dateToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                }
                this.actionName = actionName == null ? this.actionName : actionName;
                this.actionNo = actionNo == null ? this.actionNo : actionNo;
                devStateJson.put("actionName", (Object)this.actionName);
                devStateJson.put("actionNo", (Object)this.actionNo);
                devStateJson.put("cmdCount", (Object)0);
                this.stringRedisTemplate.opsForValue().set((Object)devStateKey, (Object)devStateJson.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("--------set sis devSn:" + this.SN + "operate state failed! error:"), (Throwable)e);
        }
    }

    public void updateDevConnState(int curConnState, boolean flag) {
        try {
            if (1 == curConnState) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.heartbeat >= (long)(SicmConstUtil.SISDEV_HEARTBEAT_DIF / 2)) {
                    this.heartbeat = currentTime;
                    this.stringRedisTemplate.opsForValue().set((Object)("SICM_SISDEV_HEARTBEAT_" + this.SN), (Object)String.valueOf(this.heartbeat));
                }
                if (flag) {
                    this.updateDevOperateState(this.actionName, "0");
                }
            } else if (0 == curConnState) {
                if (flag) {
                    this.updateDevOperateState(this.actionName, "-1001");
                }
            } else if (2 == curConnState && flag) {
                this.updateDevOperateState(this.actionName, "-1002");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"exception", (Throwable)e);
        }
    }

    public void getCmdAndSend() {
        boolean isImme = false;
        try {
            Object cmd = null;
            List cmdList = this.stringRedisTemplate.opsForList().range((Object)("WEBSOCKET_DOWNLOAD_COMMON_CMD_" + this.SN), 0L, 10L);
            if (cmdList != null && cmdList.size() > 0) {
                for (String devCmd : cmdList) {
                    boolean cmdCount = false;
                    if (!cmdCount) {
                        this.updateDevOperateState(devCmd.split("\\|")[2], "0");
                    }
                    this.logger.info((Object)("----send cmd=" + devCmd.split("\\|")[2]));
                    this.sendMsg(SicmDataUtil.strToByteBuffer(devCmd.split("\\|")[2]));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"websocket getCmdAndSend() error", (Throwable)e);
        }
    }

    public void getImmeCmdAndSend() {
        List immeCmdList = new ArrayList();
        try {
            immeCmdList = this.stringRedisTemplate.opsForList().range((Object)("WEBSOCKET_TELECONTROL_CMD_" + this.SN), 0L, 10L);
            if (immeCmdList != null && immeCmdList.size() > 0) {
                for (String devCmd : immeCmdList) {
                    boolean cmdCount = false;
                    if (!cmdCount) {
                        this.updateDevOperateState(devCmd.split("\\|")[2], "0");
                    }
                    this.sendMsg(SicmDataUtil.strToByteBuffer(devCmd.split("\\|")[2]));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"websocket getImmeCmdAndSend() error", (Throwable)e);
        }
    }

    public void clearDevCommonCmd() {
        String key = "WEBSOCKET_DOWNLOAD_COMMON_CMD_" + this.SN;
        if (this.stringRedisTemplate.hasKey((Object)key).booleanValue()) {
            this.stringRedisTemplate.delete((Object)key);
        }
    }

    public void clearDevOperateState() {
        try {
            String devStateKey = "SIS_DEV_OPERATE_STATE_" + this.SN;
            if (this.stringRedisTemplate.hasKey((Object)devStateKey).booleanValue()) {
                this.stringRedisTemplate.delete((Object)devStateKey);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("--------clear sis devSn:" + this.SN + "operate state failed! error:"), (Throwable)e);
        }
    }

    public void clearDevConnState() {
        try {
            String devStateKey = SicmConstUtil.SIS_DEVICE_MONITOR + this.SN;
            if (this.stringRedisTemplate.hasKey((Object)devStateKey).booleanValue()) {
                this.stringRedisTemplate.delete((Object)devStateKey);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("--------clear sis devSn:" + this.SN + "connect state failed! error:"), (Throwable)e);
        }
    }

    public void clearDevHeartbeat() {
        try {
            String devStateKey = "SICM_SISDEV_HEARTBEAT_" + this.SN;
            if (this.stringRedisTemplate.hasKey((Object)devStateKey).booleanValue()) {
                this.stringRedisTemplate.delete((Object)devStateKey);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("--------clear sis devSn:" + this.SN + "heartbeat failed! error:"), (Throwable)e);
        }
    }

    static {
        totalWebsocketInfoMap = new ConcurrentHashMap<String, SicmWebsocketInfo>();
        activeQueneNameSet = new HashSet<String>();
        dangerQueneNameSet = new HashSet<String>();
        queryQueneNameSet = new HashSet<String>();
    }
}

