/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.websocket;

import com.alibaba.druid.util.StringUtils;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.thread.SicmGateSocketThread;
import com.zkteco.zkbiosecurity.sis.util.SicmDataUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SicmGateDeviceInfo {
    private static Logger logger = Logger.getLogger(SicmGateDeviceInfo.class);
    private StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringUtil.getBean((String)"stringRedisTemplate");
    public SicmGateSocketThread monitorThread = null;
    public String name;
    public String devIp;
    private Socket socket;
    private OutputStream outputStream = null;
    public static final String module = "sis";
    public static Map<String, SicmGateDeviceInfo> allGateDeviceMap = new ConcurrentHashMap<String, SicmGateDeviceInfo>();
    public String rtLogQueneName = "RT_LOGS_" + "sis".toUpperCase() + "_" + "gate".toUpperCase();
    public static final Set<String> activeQueneNameSet = new HashSet<String>();
    public String queryQueneName = "QUERY_LOGS_" + "sis".toUpperCase() + "_" + "gate".toUpperCase();
    public static final Set<String> queryQueneNameSet = new HashSet<String>();
    private SisDeviceService sisDeviceService = (SisDeviceService)SpringUtil.getBean(SisDeviceService.class);

    public SicmGateDeviceInfo() {
    }

    public SicmGateDeviceInfo(String deviceIp, Socket socket) {
        this.devIp = deviceIp;
        this.socket = socket;
    }

    public String getDevIp() {
        return this.devIp;
    }

    public void setDevIp(String devIp) {
        this.devIp = devIp;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public List<String> getCmdAndSend() {
        if (!this.stringRedisTemplate.hasKey((Object)("GATE_DEVICE_COMMON_CMD_" + this.devIp)).booleanValue()) {
            return null;
        }
        List cmdList = this.stringRedisTemplate.opsForList().range((Object)("GATE_DEVICE_COMMON_CMD_" + this.devIp), 0L, 10L);
        if (cmdList.size() > 0) {
            try {
                this.outputStream = this.socket.getOutputStream();
                for (String devCmd : cmdList) {
                    logger.info((Object)("\u5b89\u68c0\u95e8\u4e0b\u53d1\u666e\u901a\u6307\u4ee4===========" + devCmd));
                    byte[] cmdByteArray = SicmDataUtil.hexToByteArray(StringUtils.subString((String)devCmd.split("\\|")[1], (String)"[", (String)"]"));
                    this.outputStream.write(cmdByteArray);
                    this.outputStream.flush();
                    this.stringRedisTemplate.opsForList().remove((Object)("GATE_DEVICE_COMMON_CMD_" + this.devIp), 1L, (Object)devCmd);
                    Thread.sleep(1000L);
                }
            }
            catch (IOException | InterruptedException e) {
                if (this.stringRedisTemplate.hasKey((Object)("SIS_GATE_DEVICE_STATUS_" + this.devIp)).booleanValue()) {
                    this.stringRedisTemplate.opsForValue().set((Object)("SIS_GATE_DEVICE_STATUS_" + this.devIp), (Object)"1");
                    this.sisDeviceService.setBoradGateStatusData();
                }
                logger.error((Object)("getCmdAndSend exception: " + e));
            }
        }
        return cmdList;
    }

    public void getImmeCmdAndSend() {
        List immeCmdList;
        if (this.stringRedisTemplate.hasKey((Object)("GAT_IMIDEIL_CMD_" + this.devIp)).booleanValue() && (immeCmdList = this.stringRedisTemplate.opsForList().range((Object)("GAT_IMIDEIL_CMD_" + this.devIp), 0L, 10L)) != null && immeCmdList.size() > 0) {
            try {
                this.outputStream = this.socket.getOutputStream();
                for (String devCmd : immeCmdList) {
                    logger.info((Object)("\u5b89\u68c0\u95e8\u4e0b\u53d1\u7d27\u6025\u6307\u4ee4===========" + devCmd));
                    byte[] cmdByteArray = SicmDataUtil.hexToByteArray(StringUtils.subString((String)devCmd.split("\\|")[1], (String)"[", (String)"]"));
                    this.outputStream.write(cmdByteArray);
                    this.outputStream.flush();
                    this.stringRedisTemplate.opsForList().remove((Object)("GAT_IMIDEIL_CMD_" + this.devIp), 1L, (Object)devCmd);
                    Thread.sleep(1000L);
                }
            }
            catch (IOException | InterruptedException e) {
                if (this.stringRedisTemplate.hasKey((Object)("SIS_GATE_DEVICE_STATUS_" + this.devIp)).booleanValue()) {
                    this.stringRedisTemplate.opsForValue().set((Object)("SIS_GATE_DEVICE_STATUS_" + this.devIp), (Object)"1");
                    this.sisDeviceService.setBoradGateStatusData();
                }
                logger.error((Object)("getImmeCmdAndSend excepion: " + e));
            }
        }
    }
}

