/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.router;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.service.SisTransactionService;
import com.zkteco.zkbiosecurity.sis.websocket.SicmWebsocketInfo;
import org.apache.log4j.Logger;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SicmDataRouter {
    private StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringUtil.getBean((String)"stringRedisTemplate");
    private Logger logger = Logger.getLogger(this.getClass());
    private SisDeviceService sisDeviceService = (SisDeviceService)SpringUtil.getBean(SisDeviceService.class);
    private SisTransactionService sisTransactionService = (SisTransactionService)SpringUtil.getBean(SisTransactionService.class);

    public boolean sendRTLog(String sn, JSONObject data) {
        boolean ret = true;
        JSONObject rtLogJson = new JSONObject();
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient != null) {
                rtLogJson.put(sn, (Object)data);
                this.stringRedisTemplate.opsForList().rightPush((Object)websocketClient.rtLogQueneName, (Object)rtLogJson.toString());
                if ("sis".equals("sis") && !SicmWebsocketInfo.activeQueneNameSet.contains(websocketClient.rtLogQueneName)) {
                    SicmWebsocketInfo.activeQueneNameSet.add(websocketClient.rtLogQueneName);
                    this.stringRedisTemplate.opsForSet().add((Object)"SIS_RTLOG_QUENE_NAME_SET", (Object[])new String[]{websocketClient.rtLogQueneName});
                }
            } else {
                this.logger.info((Object)"-----------sendRTLog error----sn not in totalWebsocketInfoMap----------");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Sicm sendRTLog() error", (Throwable)e);
        }
        return ret;
    }

    public boolean sendDangerLog(String sn, JSONObject data) {
        boolean ret = true;
        JSONObject rtLogJson = new JSONObject();
        try {
            this.sisTransactionService.dangerUpload(sn, data);
        }
        catch (Exception e) {
            this.logger.error((Object)"Sicm sendDangerLog() error", (Throwable)e);
        }
        return ret;
    }

    public boolean sendQueryLog(String sn, JSONObject data) {
        boolean ret = true;
        JSONObject rtLogJson = new JSONObject();
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient != null) {
                rtLogJson.put(sn, (Object)data);
                JSONObject object = (JSONObject)data.get((Object)"data");
                Integer workMode = (Integer)object.get((Object)"work_mode");
                if (workMode != null) {
                    String value = workMode.toString();
                    this.sisDeviceService.convertAndSend(sn, value);
                }
                this.stringRedisTemplate.opsForList().rightPush((Object)websocketClient.queryQueneName, (Object)rtLogJson.toString());
                if ("sis".equals("sis") && !SicmWebsocketInfo.queryQueneNameSet.contains(websocketClient.queryQueneName)) {
                    SicmWebsocketInfo.queryQueneNameSet.add(websocketClient.queryQueneName);
                    this.stringRedisTemplate.opsForSet().add((Object)"SIS_QUERYLOG_QUENE_NAME_SET", (Object[])new String[]{websocketClient.queryQueneName});
                }
            } else {
                this.logger.info((Object)"-----------sendQueryLog error----sn not in totalWebsocketInfoMap----------");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Sicm sendQueryLog() error", (Throwable)e);
        }
        return ret;
    }

    public void sendRTDate(String sn, JSONObject textJsonContent) {
        this.sisDeviceService.sendRTLog(sn, textJsonContent);
    }
}

