/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.distributor;

import com.zkteco.zkbiosecurity.sis.service.SisDevCmdService;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.util.SicmDeviceDataUtil;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceItem;
import com.zkteco.zkbiosecurity.sis.websocket.SicmWebsocketInfo;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Order(value=111003)
public class SisDeviceMonitorServer
implements CommandLineRunner {
    Logger logger = Logger.getLogger(SisDeviceMonitorServer.class);
    @Autowired
    private SisDeviceService sisDeviceService;
    @Autowired
    private SisDevCmdService sisDevCmdService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public void run(String ... strings) {
        new SicmDeviceMonitorThread("SicmDeviceMonitorThread").start();
        new SicmImmeCmdDownloadThread("SicmImmeCmdDownloadThread").start();
        new SicmCmdDownloadThread("SicmCmdDownloadThread").start();
    }

    class SicmImmeCmdDownloadThread
    extends Thread {
        SicmImmeCmdDownloadThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(10000L);
                    while (true) {
                        Map<String, SicmWebsocketInfo> websocketMap = SicmWebsocketInfo.totalWebsocketInfoMap;
                        SisDeviceMonitorServer.this.logger.debug((Object)("--------------------------SicmImmeCmdDownloadThread----websocketMap size=" + websocketMap.size()));
                        for (String key : websocketMap.keySet()) {
                            websocketMap.get(key).getImmeCmdAndSend();
                        }
                        Thread.sleep(1500L);
                    }
                }
                catch (Exception e) {
                    SisDeviceMonitorServer.this.logger.error((Object)"exception", (Throwable)e);
                    this.run();
                    continue;
                }
                break;
            }
        }
    }

    class SicmCmdDownloadThread
    extends Thread {
        SicmCmdDownloadThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(30000L);
                    while (true) {
                        Map<String, SicmWebsocketInfo> websocketMap = SicmWebsocketInfo.totalWebsocketInfoMap;
                        SisDeviceMonitorServer.this.logger.debug((Object)("--------------------------SicmCmdDownloadThread----websocketMap size=" + websocketMap.size()));
                        for (String key : websocketMap.keySet()) {
                            websocketMap.get(key).getCmdAndSend();
                        }
                        Thread.sleep(10000L);
                    }
                }
                catch (Exception e) {
                    SisDeviceMonitorServer.this.logger.error((Object)"exception", (Throwable)e);
                    this.run();
                    continue;
                }
                break;
            }
        }
    }

    class SicmDeviceMonitorThread
    extends Thread {
        SicmDeviceDataUtil sicmDeviceDataUtil = new SicmDeviceDataUtil();

        SicmDeviceMonitorThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(30000L);
                while (true) {
                    List deviceList = SisDeviceMonitorServer.this.sisDeviceService.getAllDevice();
                    for (SisDeviceItem device : deviceList) {
                        SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(device.getSn());
                        if (websocketClient != null) {
                            if (websocketClient.connect == 2) {
                                websocketClient.updateDevConnState(2, true);
                                continue;
                            }
                            if (System.currentTimeMillis() - websocketClient.heartbeat < (long)websocketClient.heartbeatDif) {
                                String temp = (String)SisDeviceMonitorServer.this.stringRedisTemplate.opsForValue().get((Object)("SICM_SISDEV_HEARTBEAT_" + device.getSn()));
                                long l = websocketClient.heartbeat = temp != null ? Long.valueOf(temp) : 0L;
                                if (System.currentTimeMillis() - websocketClient.heartbeat > (long)websocketClient.heartbeatDif) {
                                    websocketClient.updateDevConnState(0, true);
                                    continue;
                                }
                                websocketClient.updateDevConnState(1, true);
                                new SicmDeviceDataUtil().updateDevState(device.getSn(), (short)1, "CONNECT", "1");
                                continue;
                            }
                            if (System.currentTimeMillis() - websocketClient.heartbeat >= 0L) continue;
                            websocketClient.heartbeat = System.currentTimeMillis();
                            SisDeviceMonitorServer.this.stringRedisTemplate.opsForValue().set((Object)("SICM_SISDEV_HEARTBEAT_" + device.getSn()), (Object)(websocketClient.heartbeat + ""));
                            continue;
                        }
                        new SicmDeviceDataUtil().updateDevState(device.getSn(), (short)0, "DISCONNECT", "0");
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (Exception e) {
                SisDeviceMonitorServer.this.logger.error((Object)"exception", (Throwable)e);
                return;
            }
        }
    }
}

