/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import sun.security.ssl.Authenticator;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.EngineArgs;
import sun.security.ssl.EngineWriter;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLEngineImpl;

final class EngineOutputRecord
extends OutputRecord {
    private SSLEngineImpl engine;
    private EngineWriter writer;
    private boolean finishedMsg = false;

    EngineOutputRecord(byte type, SSLEngineImpl engine) {
        super(type, EngineOutputRecord.recordSize(type));
        this.engine = engine;
        this.writer = engine.writer;
    }

    private static int recordSize(byte type) {
        switch (type) {
            case 20: 
            case 21: {
                return 539;
            }
            case 22: {
                return 16921;
            }
            case 23: {
                return 0;
            }
        }
        throw new RuntimeException("Unknown record type: " + type);
    }

    void setFinishedMsg() {
        this.finishedMsg = true;
    }

    @Override
    public void flush() throws IOException {
        this.finishedMsg = false;
    }

    boolean isFinishedMsg() {
        return this.finishedMsg;
    }

    @Override
    void writeBuffer(OutputStream s, byte[] buf, int off, int len, int debugOffset) throws IOException {
        ByteBuffer netBB = (ByteBuffer)ByteBuffer.allocate(len).put(buf, off, len).flip();
        this.writer.putOutboundData(netBB);
    }

    void write(Authenticator authenticator, CipherBox writeCipher) throws IOException {
        switch (this.contentType()) {
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            default: {
                throw new RuntimeException("unexpected byte buffers");
            }
        }
        if (!this.isEmpty()) {
            this.encrypt(authenticator, writeCipher);
            this.write((OutputStream)null, false, (ByteArrayOutputStream)null);
        }
    }

    void write(EngineArgs ea, Authenticator authenticator, CipherBox writeCipher) throws IOException {
        int length;
        assert (this.contentType() == 23);
        if (authenticator == MAC.NULL) {
            return;
        }
        if (ea.getAppRemaining() == 0) {
            return;
        }
        if (this.engine.needToSplitPayload(writeCipher, this.protocolVersion)) {
            this.write(ea, authenticator, writeCipher, 1);
            ea.resetLim();
            length = Math.min(ea.getAppRemaining(), 15846);
        } else {
            length = Math.min(ea.getAppRemaining(), 16384);
        }
        if (length > 0) {
            this.write(ea, authenticator, writeCipher, length);
        }
    }

    void write(EngineArgs ea, Authenticator authenticator, CipherBox writeCipher, int length) throws IOException {
        MAC signer;
        ByteBuffer dstBB = ea.netData;
        int dstPos = dstBB.position();
        int dstLim = dstBB.limit();
        int dstData = dstPos + 5 + writeCipher.getExplicitNonceSize();
        dstBB.position(dstData);
        ea.gather(length);
        dstBB.limit(dstBB.position());
        dstBB.position(dstData);
        if (authenticator instanceof MAC && (signer = (MAC)authenticator).MAClen() != 0) {
            byte[] hash = signer.compute(this.contentType(), dstBB, false);
            dstBB.limit(dstBB.limit() + hash.length);
            dstBB.put(hash);
            dstBB.limit(dstBB.position());
            dstBB.position(dstData);
        }
        if (!writeCipher.isNullCipher()) {
            if (this.protocolVersion.v >= ProtocolVersion.TLS11.v && (writeCipher.isCBCMode() || writeCipher.isAEADMode())) {
                byte[] nonce = writeCipher.createExplicitNonce(authenticator, this.contentType(), dstBB.remaining());
                dstBB.position(dstPos + 5);
                dstBB.put(nonce);
                if (!writeCipher.isAEADMode()) {
                    dstBB.position(dstPos + 5);
                }
            }
            writeCipher.encrypt(dstBB, dstLim);
            if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake") && this.contentType() == 20)) {
                System.out.println(Thread.currentThread().getName() + ", WRITE: " + this.protocolVersion + " " + InputRecord.contentName(this.contentType()) + ", length = " + length);
            }
        } else {
            dstBB.position(dstBB.limit());
        }
        int packetLength = dstBB.limit() - dstPos - 5;
        dstBB.put(dstPos, this.contentType());
        dstBB.put(dstPos + 1, this.protocolVersion.major);
        dstBB.put(dstPos + 2, this.protocolVersion.minor);
        dstBB.put(dstPos + 3, (byte)(packetLength >> 8));
        dstBB.put(dstPos + 4, (byte)packetLength);
        dstBB.limit(dstLim);
    }
}

