/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.locale.provider.JRELocaleConstants;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.logging.PlatformLogger;

public final class LocaleServiceProviderPool {
    private static ConcurrentMap<Class<? extends LocaleServiceProvider>, LocaleServiceProviderPool> poolOfPools = new ConcurrentHashMap<Class<? extends LocaleServiceProvider>, LocaleServiceProviderPool>();
    private ConcurrentMap<LocaleProviderAdapter.Type, LocaleServiceProvider> providers = new ConcurrentHashMap<LocaleProviderAdapter.Type, LocaleServiceProvider>();
    private ConcurrentMap<Locale, List<LocaleProviderAdapter.Type>> providersCache = new ConcurrentHashMap<Locale, List<LocaleProviderAdapter.Type>>();
    private Set<Locale> availableLocales = null;
    private Class<? extends LocaleServiceProvider> providerClass;
    static final Class<LocaleServiceProvider>[] spiClasses = new Class[]{BreakIteratorProvider.class, CollatorProvider.class, DateFormatProvider.class, DateFormatSymbolsProvider.class, DecimalFormatSymbolsProvider.class, NumberFormatProvider.class, CurrencyNameProvider.class, LocaleNameProvider.class, TimeZoneNameProvider.class, CalendarDataProvider.class};
    private static List<LocaleProviderAdapter.Type> NULL_LIST = Collections.emptyList();

    public static LocaleServiceProviderPool getPool(Class<? extends LocaleServiceProvider> providerClass) {
        LocaleServiceProviderPool newPool;
        LocaleServiceProviderPool pool = (LocaleServiceProviderPool)poolOfPools.get(providerClass);
        if (pool == null && (pool = poolOfPools.putIfAbsent(providerClass, newPool = new LocaleServiceProviderPool(providerClass))) == null) {
            pool = newPool;
        }
        return pool;
    }

    private LocaleServiceProviderPool(Class<? extends LocaleServiceProvider> c) {
        this.providerClass = c;
        for (LocaleProviderAdapter.Type type : LocaleProviderAdapter.getAdapterPreference()) {
            LocaleServiceProvider provider;
            LocaleProviderAdapter lda = LocaleProviderAdapter.forType(type);
            if (lda == null || (provider = lda.getLocaleServiceProvider(c)) == null) continue;
            this.providers.putIfAbsent(type, provider);
        }
    }

    static void config(Class<? extends Object> caller, String message) {
        PlatformLogger logger = PlatformLogger.getLogger(caller.getCanonicalName());
        logger.config(message);
    }

    public static Locale[] getAllAvailableLocales() {
        return (Locale[])AllAvailableLocales.allAvailableLocales.clone();
    }

    public Locale[] getAvailableLocales() {
        HashSet<Locale> locList = new HashSet<Locale>();
        locList.addAll(this.getAvailableLocaleSet());
        locList.addAll(Arrays.asList(LocaleProviderAdapter.forJRE().getAvailableLocales()));
        Locale[] tmp = new Locale[locList.size()];
        locList.toArray(tmp);
        return tmp;
    }

    private synchronized Set<Locale> getAvailableLocaleSet() {
        if (this.availableLocales == null) {
            this.availableLocales = new HashSet<Locale>();
            for (LocaleServiceProvider lsp : this.providers.values()) {
                Locale[] locales;
                for (Locale locale : locales = lsp.getAvailableLocales()) {
                    this.availableLocales.add(LocaleServiceProviderPool.getLookupLocale(locale));
                }
            }
        }
        return this.availableLocales;
    }

    boolean hasProviders() {
        return this.providers.size() != 1 || this.providers.get((Object)LocaleProviderAdapter.Type.JRE) == null && this.providers.get((Object)LocaleProviderAdapter.Type.FALLBACK) == null;
    }

    public <P extends LocaleServiceProvider, S> S getLocalizedObject(LocalizedObjectGetter<P, S> getter, Locale locale, Object ... params) {
        return this.getLocalizedObjectImpl(getter, locale, true, null, params);
    }

    public <P extends LocaleServiceProvider, S> S getLocalizedObject(LocalizedObjectGetter<P, S> getter, Locale locale, String key, Object ... params) {
        return this.getLocalizedObjectImpl(getter, locale, false, key, params);
    }

    private <P extends LocaleServiceProvider, S> S getLocalizedObjectImpl(LocalizedObjectGetter<P, S> getter, Locale locale, boolean isObjectProvider, String key, Object ... params) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (!this.hasProviders()) {
            return getter.getObject((LocaleServiceProvider)this.providers.get((Object)LocaleProviderAdapter.defaultLocaleProviderAdapter), locale, key, params);
        }
        List<Locale> lookupLocales = LocaleServiceProviderPool.getLookupLocales(locale);
        Set<Locale> available = this.getAvailableLocaleSet();
        for (Locale current : lookupLocales) {
            if (!available.contains(current)) continue;
            for (LocaleProviderAdapter.Type type : this.findProviders(current)) {
                LocaleServiceProvider lsp = (LocaleServiceProvider)this.providers.get((Object)type);
                S providersObj = getter.getObject(lsp, locale, key, params);
                if (providersObj != null) {
                    return providersObj;
                }
                if (!isObjectProvider) continue;
                LocaleServiceProviderPool.config(LocaleServiceProviderPool.class, "A locale sensitive service provider returned null for a localized objects,  which should not happen.  provider: " + lsp + " locale: " + locale);
            }
        }
        return null;
    }

    private List<LocaleProviderAdapter.Type> findProviders(Locale locale) {
        List<LocaleProviderAdapter.Type> providersList = (List<LocaleProviderAdapter.Type>)this.providersCache.get(locale);
        if (providersList == null) {
            List<LocaleProviderAdapter.Type> val;
            for (LocaleProviderAdapter.Type type : LocaleProviderAdapter.getAdapterPreference()) {
                LocaleServiceProvider lsp = (LocaleServiceProvider)this.providers.get((Object)type);
                if (lsp == null || !lsp.isSupportedLocale(locale)) continue;
                if (providersList == null) {
                    providersList = new ArrayList<LocaleProviderAdapter.Type>(2);
                }
                providersList.add(type);
            }
            if (providersList == null) {
                providersList = NULL_LIST;
            }
            if ((val = this.providersCache.putIfAbsent(locale, providersList)) != null) {
                providersList = val;
            }
        }
        return providersList;
    }

    static List<Locale> getLookupLocales(Locale locale) {
        List<Locale> lookupLocales = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales("", locale);
        return lookupLocales;
    }

    static Locale getLookupLocale(Locale locale) {
        Locale lookupLocale = locale;
        if (locale.hasExtensions() && !locale.equals(JRELocaleConstants.JA_JP_JP) && !locale.equals(JRELocaleConstants.TH_TH_TH)) {
            Locale.Builder locbld = new Locale.Builder();
            try {
                locbld.setLocale(locale);
                locbld.clearExtensions();
                lookupLocale = locbld.build();
            }
            catch (IllformedLocaleException e) {
                LocaleServiceProviderPool.config(LocaleServiceProviderPool.class, "A locale(" + locale + ") has non-empty extensions, but has illformed fields.");
                lookupLocale = new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant());
            }
        }
        return lookupLocale;
    }

    public static interface LocalizedObjectGetter<P extends LocaleServiceProvider, S> {
        public S getObject(P var1, Locale var2, String var3, Object ... var4);
    }

    private static class AllAvailableLocales {
        static final Locale[] allAvailableLocales;

        private AllAvailableLocales() {
        }

        static {
            HashSet all = new HashSet();
            for (Class<LocaleServiceProvider> c : spiClasses) {
                LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(c);
                all.addAll(pool.getAvailableLocaleSet());
            }
            allAvailableLocales = all.toArray(new Locale[0]);
        }
    }
}

