/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.kerberos.KeyTab;
import sun.security.krb5.Config;
import sun.security.krb5.KrbAsReqBuilder;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.tools.KinitOptions;
import sun.security.util.Password;

public class Kinit {
    private KinitOptions options;
    private static final boolean DEBUG = Krb5.DEBUG;

    public static void main(String[] args) {
        try {
            Kinit kinit = new Kinit(args);
        }
        catch (Exception e) {
            String msg = null;
            msg = e instanceof KrbException ? ((KrbException)e).krbErrorMessage() + " " + ((KrbException)e).returnCodeMessage() : e.getMessage();
            if (msg != null) {
                System.err.println("Exception: " + msg);
            } else {
                System.out.println("Exception: " + e);
            }
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private Kinit(String[] args) throws IOException, RealmException, KrbException {
        KrbAsReqBuilder builder;
        this.options = args == null || args.length == 0 ? new KinitOptions() : new KinitOptions(args);
        String princName = null;
        PrincipalName principal = this.options.getPrincipal();
        if (principal != null) {
            princName = principal.toString();
        }
        if (DEBUG) {
            System.out.println("Principal is " + principal);
        }
        char[] psswd = this.options.password;
        boolean useKeytab = this.options.useKeytabFile();
        if (!useKeytab) {
            if (princName == null) {
                throw new IllegalArgumentException(" Can not obtain principal name");
            }
            if (psswd == null) {
                System.out.print("Password for " + princName + ":");
                System.out.flush();
                psswd = Password.readPassword(System.in);
                if (DEBUG) {
                    System.out.println(">>> Kinit console input " + new String(psswd));
                }
            }
            builder = new KrbAsReqBuilder(principal, psswd);
        } else {
            if (DEBUG) {
                System.out.println(">>> Kinit using keytab");
            }
            if (princName == null) {
                throw new IllegalArgumentException("Principal name must be specified.");
            }
            String ktabName = this.options.keytabFileName();
            if (ktabName != null && DEBUG) {
                System.out.println(">>> Kinit keytab file name: " + ktabName);
            }
            builder = new KrbAsReqBuilder(principal, ktabName == null ? KeyTab.getInstance() : KeyTab.getInstance(new File(ktabName)));
        }
        KDCOptions opt = new KDCOptions();
        Kinit.setOptions(1, this.options.forwardable, opt);
        Kinit.setOptions(3, this.options.proxiable, opt);
        builder.setOptions(opt);
        String realm = this.options.getKDCRealm();
        if (realm == null) {
            realm = Config.getInstance().getDefaultRealm();
        }
        if (DEBUG) {
            System.out.println(">>> Kinit realm name is " + realm);
        }
        PrincipalName sname = PrincipalName.tgsService(realm, realm);
        builder.setTarget(sname);
        if (DEBUG) {
            System.out.println(">>> Creating KrbAsReq");
        }
        if (this.options.getAddressOption()) {
            builder.setAddresses(HostAddresses.getLocalAddresses());
        }
        builder.action();
        Credentials credentials = builder.getCCreds();
        builder.destroy();
        CredentialsCache cache = CredentialsCache.create(principal, this.options.cachename);
        if (cache == null) {
            throw new IOException("Unable to create the cache file " + this.options.cachename);
        }
        cache.update(credentials);
        cache.save();
        if (this.options.password == null) {
            System.out.println("New ticket is stored in cache file " + this.options.cachename);
        } else {
            Arrays.fill(this.options.password, '0');
        }
        if (psswd != null) {
            Arrays.fill(psswd, '0');
        }
        this.options = null;
    }

    private static void setOptions(int flag, int option, KDCOptions opt) {
        switch (option) {
            case 0: {
                break;
            }
            case -1: {
                opt.set(flag, false);
                break;
            }
            case 1: {
                opt.set(flag, true);
            }
        }
    }
}

