/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.InvalidPathException;
import sun.nio.fs.WindowsPathType;

class WindowsPathParser {
    private static final String reservedChars = "<>:\"|?*";

    private WindowsPathParser() {
    }

    static Result parse(String input) {
        return WindowsPathParser.parse(input, true);
    }

    static Result parseNormalizedPath(String input) {
        return WindowsPathParser.parse(input, false);
    }

    private static Result parse(String input, boolean requireToNormalize) {
        String root = "";
        WindowsPathType type = null;
        int len = input.length();
        int off = 0;
        if (len > 1) {
            char c0 = input.charAt(0);
            char c1 = input.charAt(1);
            boolean c = false;
            int next = 2;
            if (WindowsPathParser.isSlash(c0) && WindowsPathParser.isSlash(c1)) {
                type = WindowsPathType.UNC;
                off = WindowsPathParser.nextNonSlash(input, next, len);
                if (off == (next = WindowsPathParser.nextSlash(input, off, len))) {
                    throw new InvalidPathException(input, "UNC path is missing hostname");
                }
                String host = input.substring(off, next);
                off = WindowsPathParser.nextNonSlash(input, next, len);
                if (off == (next = WindowsPathParser.nextSlash(input, off, len))) {
                    throw new InvalidPathException(input, "UNC path is missing sharename");
                }
                root = "\\\\" + host + "\\" + input.substring(off, next) + "\\";
                off = next;
            } else if (WindowsPathParser.isLetter(c0) && c1 == ':') {
                char c2;
                if (len > 2 && WindowsPathParser.isSlash(c2 = input.charAt(2))) {
                    root = c2 == '\\' ? input.substring(0, 3) : input.substring(0, 2) + '\\';
                    off = 3;
                    type = WindowsPathType.ABSOLUTE;
                } else {
                    root = input.substring(0, 2);
                    off = 2;
                    type = WindowsPathType.DRIVE_RELATIVE;
                }
            }
        }
        if (off == 0) {
            if (len > 0 && WindowsPathParser.isSlash(input.charAt(0))) {
                type = WindowsPathType.DIRECTORY_RELATIVE;
                root = "\\";
            } else {
                type = WindowsPathType.RELATIVE;
            }
        }
        if (requireToNormalize) {
            StringBuilder sb = new StringBuilder(input.length());
            sb.append(root);
            return new Result(type, root, WindowsPathParser.normalize(sb, input, off));
        }
        return new Result(type, root, input);
    }

    private static String normalize(StringBuilder sb, String path, int off) {
        int len = path.length();
        int start = off = WindowsPathParser.nextNonSlash(path, off, len);
        char lastC = '\u0000';
        while (off < len) {
            char c = path.charAt(off);
            if (WindowsPathParser.isSlash(c)) {
                if (lastC == ' ') {
                    throw new InvalidPathException(path, "Trailing char <" + lastC + ">", off - 1);
                }
                sb.append(path, start, off);
                off = WindowsPathParser.nextNonSlash(path, off, len);
                if (off != len) {
                    sb.append('\\');
                }
                start = off;
                continue;
            }
            if (WindowsPathParser.isInvalidPathChar(c)) {
                throw new InvalidPathException(path, "Illegal char <" + c + ">", off);
            }
            lastC = c;
            ++off;
        }
        if (start != off) {
            if (lastC == ' ') {
                throw new InvalidPathException(path, "Trailing char <" + lastC + ">", off - 1);
            }
            sb.append(path, start, off);
        }
        return sb.toString();
    }

    private static final boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private static final int nextNonSlash(String path, int off, int end) {
        while (off < end && WindowsPathParser.isSlash(path.charAt(off))) {
            ++off;
        }
        return off;
    }

    private static final int nextSlash(String path, int off, int end) {
        char c;
        while (off < end && !WindowsPathParser.isSlash(c = path.charAt(off))) {
            if (WindowsPathParser.isInvalidPathChar(c)) {
                throw new InvalidPathException(path, "Illegal character [" + c + "] in path", off);
            }
            ++off;
        }
        return off;
    }

    private static final boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static final boolean isInvalidPathChar(char ch) {
        return ch < ' ' || reservedChars.indexOf(ch) != -1;
    }

    static class Result {
        private final WindowsPathType type;
        private final String root;
        private final String path;

        Result(WindowsPathType type, String root, String path) {
            this.type = type;
            this.root = root;
            this.path = path;
        }

        WindowsPathType type() {
            return this.type;
        }

        String root() {
            return this.root;
        }

        String path() {
            return this.path;
        }
    }
}

