/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import javax.management.openmbean.CompositeData;
import sun.management.LockInfoCompositeData;

public class LockInfo {
    private String className;
    private int identityHashCode;

    public LockInfo(String className, int identityHashCode) {
        if (className == null) {
            throw new NullPointerException("Parameter className cannot be null");
        }
        this.className = className;
        this.identityHashCode = identityHashCode;
    }

    LockInfo(Object lock) {
        this.className = lock.getClass().getName();
        this.identityHashCode = System.identityHashCode(lock);
    }

    public String getClassName() {
        return this.className;
    }

    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public static LockInfo from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        if (cd instanceof LockInfoCompositeData) {
            return ((LockInfoCompositeData)cd).getLockInfo();
        }
        return LockInfoCompositeData.toLockInfo(cd);
    }

    public String toString() {
        return this.className + '@' + Integer.toHexString(this.identityHashCode);
    }
}

