/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.threadpool;

import com.sun.corba.se.impl.orbutil.threadpool.ThreadPoolImpl;
import com.sun.corba.se.impl.orbutil.threadpool.TimeoutException;
import com.sun.corba.se.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.se.spi.monitoring.MonitoredObject;
import com.sun.corba.se.spi.monitoring.MonitoringFactories;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import com.sun.corba.se.spi.orbutil.threadpool.WorkQueue;
import java.util.LinkedList;

public class WorkQueueImpl
implements WorkQueue {
    private ThreadPool workerThreadPool;
    private LinkedList theWorkQueue = new LinkedList();
    private long workItemsAdded = 0L;
    private long workItemsDequeued = 1L;
    private long totalTimeInQueue = 0L;
    private String name;
    private MonitoredObject workqueueMonitoredObject;

    public WorkQueueImpl() {
        this.name = "default-workqueue";
        this.initializeMonitoring();
    }

    public WorkQueueImpl(ThreadPool workerThreadPool) {
        this(workerThreadPool, "default-workqueue");
    }

    public WorkQueueImpl(ThreadPool workerThreadPool, String name) {
        this.workerThreadPool = workerThreadPool;
        this.name = name;
        this.initializeMonitoring();
    }

    private void initializeMonitoring() {
        this.workqueueMonitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.name, "Monitoring for a Work Queue");
        LongMonitoredAttributeBase b1 = new LongMonitoredAttributeBase("totalWorkItemsAdded", "Total number of Work items added to the Queue"){

            @Override
            public Object getValue() {
                return new Long(WorkQueueImpl.this.totalWorkItemsAdded());
            }
        };
        this.workqueueMonitoredObject.addAttribute(b1);
        LongMonitoredAttributeBase b2 = new LongMonitoredAttributeBase("workItemsInQueue", "Number of Work items in the Queue to be processed"){

            @Override
            public Object getValue() {
                return new Long(WorkQueueImpl.this.workItemsInQueue());
            }
        };
        this.workqueueMonitoredObject.addAttribute(b2);
        LongMonitoredAttributeBase b3 = new LongMonitoredAttributeBase("averageTimeInQueue", "Average time a work item waits in the work queue"){

            @Override
            public Object getValue() {
                return new Long(WorkQueueImpl.this.averageTimeInQueue());
            }
        };
        this.workqueueMonitoredObject.addAttribute(b3);
    }

    MonitoredObject getMonitoredObject() {
        return this.workqueueMonitoredObject;
    }

    @Override
    public synchronized void addWork(Work work) {
        ++this.workItemsAdded;
        work.setEnqueueTime(System.currentTimeMillis());
        this.theWorkQueue.addLast(work);
        ((ThreadPoolImpl)this.workerThreadPool).notifyForAvailableWork(this);
    }

    synchronized Work requestWork(long waitTime) throws TimeoutException, InterruptedException {
        ((ThreadPoolImpl)this.workerThreadPool).incrementNumberOfAvailableThreads();
        if (this.theWorkQueue.size() != 0) {
            Work workItem = (Work)this.theWorkQueue.removeFirst();
            this.totalTimeInQueue += System.currentTimeMillis() - workItem.getEnqueueTime();
            ++this.workItemsDequeued;
            ((ThreadPoolImpl)this.workerThreadPool).decrementNumberOfAvailableThreads();
            return workItem;
        }
        try {
            long remainingWaitTime = waitTime;
            long finishTime = System.currentTimeMillis() + waitTime;
            do {
                this.wait(remainingWaitTime);
                if (this.theWorkQueue.size() == 0) continue;
                Work workItem = (Work)this.theWorkQueue.removeFirst();
                this.totalTimeInQueue += System.currentTimeMillis() - workItem.getEnqueueTime();
                ++this.workItemsDequeued;
                ((ThreadPoolImpl)this.workerThreadPool).decrementNumberOfAvailableThreads();
                return workItem;
            } while ((remainingWaitTime = finishTime - System.currentTimeMillis()) > 0L);
            ((ThreadPoolImpl)this.workerThreadPool).decrementNumberOfAvailableThreads();
            throw new TimeoutException();
        }
        catch (InterruptedException ie) {
            ((ThreadPoolImpl)this.workerThreadPool).decrementNumberOfAvailableThreads();
            throw ie;
        }
    }

    @Override
    public void setThreadPool(ThreadPool workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    @Override
    public ThreadPool getThreadPool() {
        return this.workerThreadPool;
    }

    @Override
    public long totalWorkItemsAdded() {
        return this.workItemsAdded;
    }

    @Override
    public int workItemsInQueue() {
        return this.theWorkQueue.size();
    }

    @Override
    public synchronized long averageTimeInQueue() {
        return this.totalTimeInQueue / this.workItemsDequeued;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

