/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscapeUnescapeUtil {
    private static Logger logger = LoggerFactory.getLogger(EscapeUnescapeUtil.class);

    public static String escape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        for (int i = 0; i < src.length(); ++i) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String unescape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static String transferredMeaning(String src) {
        src = src.replace("%2B", "+");
        src = src.replace("%26", "&");
        src = src.replace("%25", "%");
        src = src.replace("%2F", "/");
        src = src.replace("%3F", "?");
        src = src.replace("%23", "#");
        src = src.replace("%3D", "=");
        src = src.replace("%20", " ");
        return src;
    }

    public static void main(String[] args) {
        String tmp = "~!@#$%^&*()_+|\\=-,./?><;'][{}\"";
        logger.debug("testing escape : " + tmp);
        tmp = EscapeUnescapeUtil.escape(tmp);
        logger.debug(tmp);
        logger.debug("testing unescape :" + tmp);
        logger.debug(EscapeUnescapeUtil.unescape(tmp));
    }
}

