/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseMediaFileRemote;
import com.zkteco.zkbiosecurity.system.service.BaseMediaFileService;
import com.zkteco.zkbiosecurity.system.utils.BaseMediaFileUtil;
import com.zkteco.zkbiosecurity.system.vo.BaseMediaFileItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/baseMediaFile.do"})
public class BaseMediaFileController
extends BaseController
implements BaseMediaFileRemote {
    private static final Logger log = LoggerFactory.getLogger(BaseMediaFileController.class);
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;
    @Autowired
    private BaseMediaFileService baseMediaFileService;

    @RequiresPermissions(value={"system:mediaFile"})
    public ModelAndView index() {
        return new ModelAndView("system/mediaFile/baseMediaFile");
    }

    @RequiresPermissions(value={"system:mediaFile:add", "system:mediaFile:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.baseMediaFileService.getItemById(id));
        }
        return new ModelAndView("system/mediaFile/editBaseMediaFile");
    }

    @RequiresPermissions(value={"system:mediaFile:add", "system:mediaFile:edit"})
    @LogRequest(module="base_module", object="base_leftMenu_AudioFile", opType="common_op_edit", requestParams={"name"}, opContent="base_file_alias")
    public ZKResultMsg save(@RequestParam(value="file", required=false) MultipartFile file, BaseMediaFileItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.baseMediaFileService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"system:mediaFile:refresh"})
    public DxGrid list(BaseMediaFileItem condition) {
        Pager pager = this.baseMediaFileService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"system:mediaFile:del"})
    @LogRequest(module="base_module", object="base_leftMenu_AudioFile", opType="common_op_del", requestParams={"names"}, opContent="base_file_alias")
    public ZKResultMsg del(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        boolean ret = this.baseMediaFileService.deleteByIds(ids, this.systemFilePath);
        if (!ret) {
            retMsg.setRet("fail");
            retMsg.setMsg(I18nUtil.i18nCode((String)"common_prompt_initDataCanNotDel", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public String valid(String name, String fileId) {
        BaseMediaFileItem item = this.baseMediaFileService.getItemByName(name, fileId);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg saveUploadFile(@RequestParam(value="upload", required=false) MultipartFile upload, @RequestParam(value="delPath", required=false) String delPath) {
        ZKResultMsg retMsg = new ZKResultMsg();
        JSONObject msgJson = new JSONObject();
        try {
            if (upload != null && !upload.isEmpty()) {
                if (BaseMediaFileUtil.validatorFileSize(upload)) {
                    retMsg.setRet("fail");
                    retMsg.setMsg(I18nUtil.i18nCode((String)"base_file_sizeError", (Object[])new Object[0]));
                } else {
                    String fileSize = BaseMediaFileUtil.getFileSize(upload);
                    String uploadFileName = upload.getOriginalFilename();
                    int lastIndexOf = uploadFileName.lastIndexOf("\\");
                    if (lastIndexOf > 0) {
                        uploadFileName = uploadFileName.substring(lastIndexOf + 1, uploadFileName.length());
                    }
                    if (uploadFileName.length() <= 30) {
                        String uploadContentType;
                        String filePath;
                        if (StringUtils.isNotBlank((CharSequence)delPath)) {
                            this.deleteCatchFile(delPath);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(filePath = BaseMediaFileUtil.saveFileToServer(uploadContentType = uploadFileName.substring(uploadFileName.lastIndexOf(".") + 1, uploadFileName.length()), upload, this.systemFilePath)))) {
                            String fileSuffix = filePath.substring(filePath.indexOf(".") + 1);
                            if (filePath.startsWith("/")) {
                                filePath = filePath.substring(1);
                            }
                            msgJson.put("name", (Object)uploadFileName);
                            msgJson.put("path", (Object)filePath);
                            msgJson.put("size", (Object)fileSize);
                            msgJson.put("suffix", (Object)fileSuffix);
                            retMsg.setData((Object)msgJson);
                        } else {
                            retMsg.setRet("fail");
                            retMsg.setMsg(I18nUtil.i18nCode((String)"base_file_typeRemind", (Object[])new Object[0]));
                        }
                    } else {
                        retMsg.setRet("fail");
                        retMsg.setMsg(I18nUtil.i18nCode((String)"base_file_lengthRemind", (Object[])new Object[0]));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("BaseMediaFileController saveUploadFile error");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public TreeItem getMediaFileList() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        List fileList = this.baseMediaFileService.getByCondition(new BaseMediaFileItem());
        for (BaseMediaFileItem baseMediaFileItem : fileList) {
            item = new TreeItem();
            item.setId(baseMediaFileItem.getId());
            item.setText(baseMediaFileItem.getName());
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getFileWebUrl() {
        String id = this.request.getParameter("fileId");
        String tempPath = "";
        if (StringUtils.isNotBlank((CharSequence)id)) {
            tempPath = this.baseMediaFileService.getItemById(id).getPath();
        }
        return new ZKResultMsg((Object)tempPath);
    }

    private void deleteCatchFile(String filePath) throws Exception {
        String delFilePath = BaseMediaFileUtil.getLocalUrl() + "\\" + filePath;
        BaseMediaFileUtil.deleteFile(delFilePath);
    }
}

