/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseCerTypeRemote;
import com.zkteco.zkbiosecurity.system.service.BaseCerTypeService;
import com.zkteco.zkbiosecurity.system.vo.BaseCerTypeItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class BaseCerTypeController
extends BaseController
implements BaseCerTypeRemote {
    @Autowired
    private BaseCerTypeService baseCerTypeService;
    @Autowired
    private BaseLicenseProvider baseLicenseProvider;

    @RequiresPermissions(value={"system:cerType"})
    public ModelAndView index() {
        ModelAndView mv = new ModelAndView("system/cerType/baseCerType");
        mv.addObject("visPlaceControlCount", (Object)this.baseLicenseProvider.getVisPlaceControlCount());
        return mv;
    }

    @RequiresPermissions(value={"system:cerType:add", "system:cerType:edit"})
    public ModelAndView editCerType(@RequestParam(name="id", required=false) String id) {
        ModelAndView addView = new ModelAndView("system/cerType/editCerType");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            addView.addObject("cerType", (Object)this.baseCerTypeService.findById(id));
        }
        return addView;
    }

    @LogRequest(module="base_module", object="pers_cert_type", opType="common_op_edit", requestParams={"dictValue"}, opContent="pers_cert_type")
    public ZKResultMsg saveCerType(BaseCerTypeItem baseCerTypeItem) {
        this.baseCerTypeService.editCerType(baseCerTypeItem);
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"system:cerType:refresh"})
    public DxGrid list(BaseCerTypeItem condition) {
        Pager pager = this.baseCerTypeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="base_module", object="pers_cert_type", opType="common_op_del", requestParams={"ids"}, opContent="pers_cert_type")
    @RequiresPermissions(value={"system:cerType:del"})
    public ZKResultMsg delCerTypeByIds(String ids) {
        ZKResultMsg res = ZKResultMsg.successMsg();
        this.baseCerTypeService.deleteByIds(ids);
        return res;
    }
}

