/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vid.remote.VidLinkageEventRemote;
import com.zkteco.zkbiosecurity.vid.service.VidLinkageEventService;
import com.zkteco.zkbiosecurity.vid.service.VidTransactionService;
import com.zkteco.zkbiosecurity.vid.vo.VidLinkageEventItem;
import com.zkteco.zkbiosecurity.vid.vo.VidTransactionItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VidLinkageEventController
extends BaseController
implements VidLinkageEventRemote {
    @Autowired
    private VidLinkageEventService vidLinkageEventService;
    @Autowired
    private VidTransactionService vidTransactionService;

    @RequiresPermissions(value={"vid:linkageEvent:view"})
    public ModelAndView index() {
        return new ModelAndView("vid/linkageEvent/vidLinkageEvent");
    }

    @RequiresPermissions(value={"vid:linkageEvent:edit"})
    @LogRequest
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.vidLinkageEventService.getItemById(id));
        }
        return new ModelAndView("vid/linkageEvent/editVidLinkageEvent");
    }

    @RequiresPermissions(value={"vid:linkageEvent:edit"})
    public ZKResultMsg save(VidLinkageEventItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.vidLinkageEventService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(VidLinkageEventItem condition) {
        Pager pager = this.vidLinkageEventService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.vidLinkageEventService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg viewLinkData() {
        ZKResultMsg ret = new ZKResultMsg();
        ArrayList data = new ArrayList();
        String vidLinkageHandle = this.request.getParameter("vidLinkageHandle");
        if (vidLinkageHandle.contains("_")) {
            vidLinkageHandle = vidLinkageHandle.split("_")[1];
        }
        String fileType = this.request.getParameter("fileType");
        List eventList = this.vidLinkageEventService.findByVidLinkageHandleIn((Collection)StrUtil.strToList((String)vidLinkageHandle));
        String filePath = null;
        for (VidLinkageEventItem event : eventList) {
            VidTransactionItem transactionItem = this.vidTransactionService.getItemById(event.getTransactionId());
            filePath = transactionItem.getFilePath();
            HashMap<String, String> tempRet = new HashMap<String, String>();
            if (filePath != null && transactionItem.getFileType() == Short.parseShort(fileType)) {
                if (filePath.startsWith("vid_device_record")) {
                    tempRet.put("id", transactionItem.getId());
                    tempRet.put("channelName", transactionItem.getChannelName());
                } else {
                    File file = new File(filePath);
                    if (file.exists()) {
                        tempRet.put("id", transactionItem.getId());
                        tempRet.put("channelName", transactionItem.getChannelName());
                    }
                }
            }
            if (tempRet.size() <= 0) continue;
            data.add(tempRet);
            ret.setData(data);
        }
        return ret;
    }
}

