/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vid.remote.VidChannelRemote;
import com.zkteco.zkbiosecurity.vid.service.VidChannel2EntityService;
import com.zkteco.zkbiosecurity.vid.service.VidChannelService;
import com.zkteco.zkbiosecurity.vid.service.VidParamsService;
import com.zkteco.zkbiosecurity.vid.vo.VidChannelItem;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VidChannelController
extends BaseController
implements VidChannelRemote {
    @Autowired
    private VidChannelService vidChannelService;
    @Autowired
    private VidChannel2EntityService channel2EntityService;
    @Autowired
    private VidParamsService vidParamsService;

    @RequiresPermissions(value={"vid:channel"})
    public ModelAndView index() {
        return new ModelAndView("vid/channel/vidChannel");
    }

    @LogRequest(module="vid_module", object="vid_leftMenu_vidChannel", opType="common_op_edit", requestParams={"id"}, opContent="vid_channel_num")
    @RequiresPermissions(value={"vid:channel:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.vidChannelService.getItemById(id));
        }
        return new ModelAndView("vid/channel/editVidChannel");
    }

    @RequiresPermissions(value={"vid:channel:edit"})
    public ZKResultMsg save(VidChannelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.vidChannelService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(VidChannelItem condition) {
        Pager pager = this.vidChannelService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="vid_module", object="vid_leftMenu_vidChannel", opType="common_op_del", requestParams={"ids"}, opContent="vid_channel_num")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.vidChannelService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="vid_module", object="vid_leftMenu_vidChannel", opType="common_enable", requestParams={"ids"}, opContent="vid_channel_num")
    public ZKResultMsg enable(@RequestParam(value="ids") String ids) {
        this.vidChannelService.enableChannel(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="vid_module", object="vid_leftMenu_vidChannel", opType="common_disable", requestParams={"ids"}, opContent="vid_channel_num")
    public ZKResultMsg disable(@RequestParam(value="ids") String ids) {
        this.vidChannelService.disableChannel(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validateName(@RequestParam(value="name") String name) {
        boolean ret = false;
        VidChannelItem vidChannelItem = this.vidChannelService.validateName(name);
        if (vidChannelItem == null) {
            ret = true;
        }
        return String.valueOf(ret);
    }

    public ZKResultMsg getDevByChannelId() {
        String chId = this.request.getParameter("channelId");
        ZKResultMsg ret = this.vidChannelService.getDevByChannelId(chId);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg checkChannel() {
        ZKResultMsg ret = new ZKResultMsg();
        List channelList = this.vidChannelService.getByCondition(new VidChannelItem());
        if (channelList == null || channelList.size() <= 0) {
            ret.setRet("fail");
            ret.setMsg("common_vid_noDev");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ModelAndView getVidPreview() {
        String channelId = this.request.getParameter("channelId");
        this.request.setAttribute("channelId", (Object)channelId);
        String vidDevice = this.request.getParameter("vidDevice");
        this.request.setAttribute("vidDevice", (Object)vidDevice);
        String loadPlugins = (String)this.vidParamsService.getVidParams().get("vid.loadPlugins");
        this.request.setAttribute("loadPlugins", (Object)loadPlugins);
        return new ModelAndView("vid/preview/opVidPreview");
    }

    public ModelAndView getChannelByEntityId() {
        String id = this.request.getParameter("id");
        String entityName = this.request.getParameter("entityName");
        String gridName = this.request.getParameter("gridName");
        this.request.setAttribute("entityId", (Object)id);
        this.request.setAttribute("entityName", (Object)entityName);
        this.request.setAttribute("gridName", (Object)gridName);
        String channel2EntityIds = this.channel2EntityService.getBindChannelIds(Arrays.asList(id), entityName);
        this.request.setAttribute("value", (Object)channel2EntityIds);
        return new ModelAndView("vid/channel/selectChannelContent");
    }

    public Map<String, Object> capture(@RequestParam(value="param") Map<String, Object> param) {
        return this.vidChannelService.capture(param);
    }

    public Map<String, Object> getChannelInfo() {
        return this.vidChannelService.getChannelInfo(true);
    }
}

