/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.GregorianChange;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.Nanos;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TDS;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSType;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TDSWriter {
    private static Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.Writer");
    private final String traceID;
    private final TDSChannel tdsChannel;
    private final SQLServerConnection con;
    private boolean dataIsLoggable = true;
    private TDSCommand command = null;
    private byte tdsMessageType;
    private volatile int sendResetConnection = 0;
    private int currentPacketSize = 0;
    private static final int TDS_PACKET_HEADER_SIZE = 8;
    private static final byte[] placeholderHeader = new byte[8];
    private byte[] valueBytes = new byte[256];
    private volatile int packetNum = 0;
    private ByteBuffer stagingBuffer;
    private ByteBuffer socketBuffer;
    private ByteBuffer logBuffer;

    public final String toString() {
        return this.traceID;
    }

    void setDataLoggable(boolean bl) {
        this.dataIsLoggable = bl;
    }

    TDSWriter(TDSChannel tDSChannel, SQLServerConnection sQLServerConnection) {
        this.tdsChannel = tDSChannel;
        this.con = sQLServerConnection;
        this.traceID = "TDSWriter@" + Integer.toHexString(this.hashCode()) + " (" + sQLServerConnection.toString() + ")";
    }

    void preparePacket() throws SQLServerException {
        if (this.tdsChannel.isLoggingPackets()) {
            Arrays.fill(this.logBuffer.array(), (byte)-2);
            this.logBuffer.clear();
        }
        this.writeBytes(placeholderHeader);
    }

    void writeMessageHeader() throws SQLServerException {
        if ((1 == this.tdsMessageType || 14 == this.tdsMessageType || 3 == this.tdsMessageType) && this.con.isYukonOrLater()) {
            this.writeInt(22);
            this.writeInt(18);
            this.writeShort((short)2);
            this.writeBytes(this.con.getTransactionDescriptor());
            this.writeInt(1);
        }
    }

    void startMessage(TDSCommand tDSCommand, byte by) throws SQLServerException {
        this.command = tDSCommand;
        this.tdsMessageType = by;
        this.packetNum = 0;
        this.dataIsLoggable = true;
        int n2 = this.con.getTDSPacketSize();
        if (this.currentPacketSize != n2) {
            this.socketBuffer = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
            this.stagingBuffer = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
            this.logBuffer = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
            this.currentPacketSize = n2;
        }
        this.socketBuffer.position(this.socketBuffer.limit());
        this.stagingBuffer.clear();
        this.preparePacket();
        this.writeMessageHeader();
    }

    final void endMessage() throws SQLServerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " Finishing TDS message");
        }
        this.writePacket(1);
    }

    final void resetPooledConnection() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " resetPooledConnection");
        }
        this.sendResetConnection = 8;
    }

    void writeByte(byte by) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 1) {
            this.stagingBuffer.put(by);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(by);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 1);
                }
            }
        } else {
            this.valueBytes[0] = by;
            this.writeWrappedBytes(this.valueBytes, 1);
        }
    }

    void writeChar(char c2) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putChar(c2);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putChar(c2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            Util.writeShort((short)c2, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeShort(short s2) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putShort(s2);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putShort(s2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            Util.writeShort(s2, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeInt(int n2) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 4) {
            this.stagingBuffer.putInt(n2);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putInt(n2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 4);
                }
            }
        } else {
            Util.writeInt(n2, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 4);
        }
    }

    void writeLong(long l2) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 8) {
            this.stagingBuffer.putLong(l2);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putLong(l2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 8);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(l2 >> 0 & 0xFFL);
            this.valueBytes[1] = (byte)(l2 >> 8 & 0xFFL);
            this.valueBytes[2] = (byte)(l2 >> 16 & 0xFFL);
            this.valueBytes[3] = (byte)(l2 >> 24 & 0xFFL);
            this.valueBytes[4] = (byte)(l2 >> 32 & 0xFFL);
            this.valueBytes[5] = (byte)(l2 >> 40 & 0xFFL);
            this.valueBytes[6] = (byte)(l2 >> 48 & 0xFFL);
            this.valueBytes[7] = (byte)(l2 >> 56 & 0xFFL);
            this.writeWrappedBytes(this.valueBytes, 8);
        }
    }

    void writeBytes(byte[] byArray) throws SQLServerException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    void writeBytes(byte[] byArray, int n2, int n3) throws SQLServerException {
        int n4;
        assert (n3 <= byArray.length);
        int n5 = 0;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " Writing " + n3 + " bytes");
        }
        while ((n4 = n3 - n5) > 0) {
            if (0 == this.stagingBuffer.remaining()) {
                this.writePacket(0);
            }
            if (n4 > this.stagingBuffer.remaining()) {
                n4 = this.stagingBuffer.remaining();
            }
            this.stagingBuffer.put(byArray, n2 + n5, n4);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, n2 + n5, n4);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n4);
                }
            }
            n5 += n4;
        }
    }

    void writeWrappedBytes(byte[] byArray, int n2) throws SQLServerException {
        assert (n2 <= byArray.length);
        assert (this.stagingBuffer.remaining() < n2);
        assert (n2 <= this.stagingBuffer.capacity());
        int n3 = this.stagingBuffer.remaining();
        if (n3 > 0) {
            this.stagingBuffer.put(byArray, 0, n3);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, 0, n3);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n3);
                }
            }
        }
        this.writePacket(0);
        this.stagingBuffer.put(byArray, n3, n2 - n3);
        if (this.tdsChannel.isLoggingPackets()) {
            if (this.dataIsLoggable) {
                this.logBuffer.put(byArray, n3, n2 - n3);
            } else {
                this.logBuffer.position(this.logBuffer.position() + n3);
            }
        }
    }

    void writeString(String string) throws SQLServerException {
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4 = 2 * (n3 - n2);
            if (n4 > this.valueBytes.length) {
                n4 = this.valueBytes.length;
            }
            int n5 = 0;
            while (n5 < n4) {
                char c2 = string.charAt(n2++);
                this.valueBytes[n5++] = (byte)(c2 >> 0 & 0xFF);
                this.valueBytes[n5++] = (byte)(c2 >> 8 & 0xFF);
            }
            this.writeBytes(this.valueBytes, 0, n5);
        }
    }

    void writeStream(InputStream inputStream, long l2, boolean bl) throws SQLServerException {
        MessageFormat messageFormat;
        Object[] objectArray;
        int n2;
        assert (-1L == l2 || l2 >= 0L);
        long l3 = 0L;
        byte[] byArray = new byte[4 * this.currentPacketSize];
        int n3 = 0;
        do {
            for (n2 = 0; -1 != n3 && n2 < byArray.length; n2 += n3) {
                try {
                    n3 = inputStream.read(byArray, n2, byArray.length - n2);
                }
                catch (IOException iOException) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                    Object[] objectArray2 = new Object[]{iOException.toString()};
                    this.error(objectArray.format(objectArray2), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET);
                }
                if (-1 == n3) break;
                if (n3 >= 0 && n3 <= byArray.length - n2) continue;
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                objectArray = new Object[]{SQLServerException.getErrString("R_streamReadReturnedInvalidValue")};
                this.error(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET);
            }
            if (bl) {
                this.writeInt(n2);
            }
            this.writeBytes(byArray, 0, n2);
            l3 += (long)n2;
        } while (-1 != n3 || n2 > 0);
        if (-1L != l2 && l3 != l2) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            objectArray = new Object[]{l2, l3};
            this.error(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_LENGTH_MISMATCH, DriverError.NOT_SET);
        }
    }

    void writeReader(Reader reader, long l2, boolean bl) throws SQLServerException {
        Object[] objectArray;
        int n2;
        assert (-1L == l2 || l2 >= 0L);
        long l3 = 0L;
        char[] cArray = new char[2 * this.currentPacketSize];
        byte[] byArray = new byte[4 * this.currentPacketSize];
        int n3 = 0;
        do {
            for (n2 = 0; -1 != n3 && n2 < cArray.length; n2 += n3) {
                try {
                    n3 = reader.read(cArray, n2, cArray.length - n2);
                }
                catch (IOException iOException) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                    Object[] objectArray2 = new Object[]{iOException.toString()};
                    this.error(objectArray.format(objectArray2), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET);
                }
                if (-1 == n3) break;
                if (n3 >= 0 && n3 <= cArray.length - n2) continue;
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                objectArray = new Object[]{SQLServerException.getErrString("R_streamReadReturnedInvalidValue")};
                this.error(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET);
            }
            if (bl) {
                this.writeInt(2 * n2);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[2 * i2] = (byte)(cArray[i2] >> 0 & 0xFF);
                byArray[2 * i2 + 1] = (byte)(cArray[i2] >> 8 & 0xFF);
            }
            this.writeBytes(byArray, 0, 2 * n2);
            l3 += (long)n2;
        } while (-1 != n3 || n2 > 0);
        if (-1L != l2 && l3 != l2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            objectArray = new Object[]{l2, l3};
            this.error(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_LENGTH_MISMATCH, DriverError.NOT_SET);
        }
    }

    final void error(String string, SQLState sQLState, DriverError driverError) throws SQLServerException {
        assert (null != this.command);
        this.command.interrupt(string);
        throw new SQLServerException(string, sQLState, driverError, null);
    }

    final boolean sendAttention() throws SQLServerException {
        if (this.packetNum > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": sending attention...");
            }
            ++this.tdsChannel.numMsgsSent;
            this.startMessage(this.command, (byte)6);
            this.endMessage();
            return true;
        }
        return false;
    }

    private final void writePacket(int n2) throws SQLServerException {
        boolean bl;
        boolean bl2 = bl = 1 == (1 & n2);
        if (null != this.command && 6 != this.tdsMessageType) {
            this.command.checkForInterrupt();
        }
        this.writePacketHeader(n2 | this.sendResetConnection);
        this.sendResetConnection = 0;
        this.flush(bl);
        if (bl) {
            this.flush(bl);
            ++this.tdsChannel.numMsgsSent;
        }
        if (16 == this.tdsMessageType && 1 == this.packetNum && 0 == this.con.getNegotiatedEncryptionLevel()) {
            this.tdsChannel.disableSSL();
        }
        if (null != this.command && 6 != this.tdsMessageType && bl) {
            this.command.onRequestComplete();
        }
    }

    private final void writePacketHeader(int n2) {
        int n3 = this.stagingBuffer.position();
        ++this.packetNum;
        this.stagingBuffer.put(0, this.tdsMessageType);
        this.stagingBuffer.put(1, (byte)n2);
        this.stagingBuffer.put(2, (byte)(n3 >> 8 & 0xFF));
        this.stagingBuffer.put(3, (byte)(n3 >> 0 & 0xFF));
        this.stagingBuffer.put(4, (byte)(this.tdsChannel.getSPID() >> 8 & 0xFF));
        this.stagingBuffer.put(5, (byte)(this.tdsChannel.getSPID() >> 0 & 0xFF));
        this.stagingBuffer.put(6, (byte)(this.packetNum % 256));
        this.stagingBuffer.put(7, (byte)0);
        if (this.tdsChannel.isLoggingPackets()) {
            this.logBuffer.put(0, this.tdsMessageType);
            this.logBuffer.put(1, (byte)n2);
            this.logBuffer.put(2, (byte)(n3 >> 8 & 0xFF));
            this.logBuffer.put(3, (byte)(n3 >> 0 & 0xFF));
            this.logBuffer.put(4, (byte)(this.tdsChannel.getSPID() >> 8 & 0xFF));
            this.logBuffer.put(5, (byte)(this.tdsChannel.getSPID() >> 0 & 0xFF));
            this.logBuffer.put(6, (byte)(this.packetNum % 256));
            this.logBuffer.put(7, (byte)0);
        }
    }

    void flush(boolean bl) throws SQLServerException {
        this.tdsChannel.write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
        this.socketBuffer.position(this.socketBuffer.limit());
        if (this.stagingBuffer.position() >= 8) {
            ByteBuffer byteBuffer = this.stagingBuffer;
            this.stagingBuffer = this.socketBuffer;
            this.socketBuffer = byteBuffer;
            this.socketBuffer.flip();
            this.stagingBuffer.clear();
            if (this.tdsChannel.isLoggingPackets()) {
                this.tdsChannel.logPacket(this.logBuffer.array(), 0, this.socketBuffer.limit(), this.toString() + " sending packet (" + this.socketBuffer.limit() + " bytes)");
            }
            if (!bl) {
                this.preparePacket();
            }
            this.tdsChannel.write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
            this.socketBuffer.position(this.socketBuffer.limit());
        }
    }

    private void writeRPCNameValType(String string, boolean bl, TDSType tDSType) throws SQLServerException {
        int n2 = 0;
        if (null != string) {
            n2 = string.length() + 1;
        }
        this.writeByte((byte)n2);
        if (n2 > 0) {
            this.writeChar('@');
            this.writeString(string);
        }
        this.writeByte((byte)(bl ? 1 : 0));
        this.writeByte(tDSType.byteValue());
    }

    void writeRPCBit(String string, Boolean bl, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, TDSType.BITN);
        this.writeByte((byte)1);
        if (null == bl) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeByte((byte)(bl != false ? 1 : 0));
        }
    }

    void writeRPCByte(String string, Byte by, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)1);
        if (null == by) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeByte(by);
        }
    }

    void writeRPCShort(String string, Short s2, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)2);
        if (null == s2) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)2);
            this.writeShort(s2);
        }
    }

    void writeRPCInt(String string, Integer n2, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)4);
        if (null == n2) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)4);
            this.writeInt(n2);
        }
    }

    void writeRPCLong(String string, Long l2, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)8);
        if (null == l2) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)8);
            this.writeLong(l2);
        }
    }

    void writeRPCReal(String string, Float f2, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.FLOATN);
        if (null == f2) {
            this.writeByte((byte)4);
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)4);
            this.writeByte((byte)4);
            this.writeInt(Float.floatToRawIntBits(f2.floatValue()));
        }
    }

    void writeRPCDouble(String string, Double d2, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.FLOATN);
        int n2 = 8;
        this.writeByte((byte)n2);
        if (null == d2) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)n2);
            long l2 = Double.doubleToLongBits(d2);
            long l3 = 255L;
            int n3 = 0;
            for (int i2 = 0; i2 < 8; ++i2) {
                this.writeByte((byte)((l2 & l3) >> n3));
                n3 += 8;
                l3 <<= 8;
            }
        }
    }

    void writeRPCBigDecimal(String string, BigDecimal bigDecimal, int n2, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.DECIMALN);
        this.writeByte((byte)17);
        this.writeByte((byte)38);
        byte[] byArray = DDC.convertBigDecimalToBytes(bigDecimal, n2);
        this.writeBytes(byArray, 0, byArray.length);
    }

    void writeVMaxHeader(long l2, boolean bl, SQLCollation sQLCollation) throws SQLServerException {
        this.writeShort((short)-1);
        if (null != sQLCollation) {
            sQLCollation.writeCollation(this);
        }
        if (bl) {
            this.writeLong(-1L);
        } else if (-1L == l2) {
            this.writeLong(-2L);
        } else {
            this.writeLong(l2);
        }
    }

    void writeRPCStringUnicode(String string) throws SQLServerException {
        this.writeRPCStringUnicode(null, string, false, null);
    }

    void writeRPCStringUnicode(String string, String string2, boolean bl, SQLCollation sQLCollation) throws SQLServerException {
        boolean bl2;
        boolean bl3;
        boolean bl4 = string2 == null;
        int n2 = bl4 ? 0 : 2 * string2.length();
        boolean bl5 = bl3 = n2 <= 8000;
        if (null == sQLCollation) {
            sQLCollation = this.con.getDatabaseCollation();
        }
        boolean bl6 = bl2 = this.con.isYukonOrLater() && (!bl3 || bl);
        if (bl2) {
            this.writeRPCNameValType(string, bl, TDSType.NVARCHAR);
            this.writeVMaxHeader(n2, bl4, sQLCollation);
            if (!bl4) {
                if (n2 > 0) {
                    this.writeInt(n2);
                    this.writeString(string2);
                }
                this.writeInt(0);
            }
        } else {
            if (bl3) {
                this.writeRPCNameValType(string, bl, TDSType.NVARCHAR);
                this.writeShort((short)8000);
            } else {
                this.writeRPCNameValType(string, bl, TDSType.NTEXT);
                this.writeInt(Integer.MAX_VALUE);
            }
            sQLCollation.writeCollation(this);
            if (bl4) {
                this.writeShort((short)-1);
            } else {
                if (bl3) {
                    this.writeShort((short)n2);
                } else {
                    this.writeInt(n2);
                }
                if (0 != n2) {
                    this.writeString(string2);
                }
            }
        }
    }

    void writeRPCByteArray(String string, byte[] byArray, boolean bl, JDBCType jDBCType, SQLCollation sQLCollation) throws SQLServerException {
        TDSType tDSType;
        boolean bl2 = byArray == null;
        int n2 = bl2 ? 0 : byArray.length;
        boolean bl3 = n2 <= 8000;
        boolean bl4 = this.con.isYukonOrLater() && (!bl3 || bl);
        switch (jDBCType) {
            default: {
                tDSType = bl3 || bl4 ? TDSType.BIGVARBINARY : TDSType.IMAGE;
                sQLCollation = null;
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: 
            case CLOB: {
                TDSType tDSType2 = tDSType = bl3 || bl4 ? TDSType.BIGVARCHAR : TDSType.TEXT;
                if (null != sQLCollation) break;
                sQLCollation = this.con.getDatabaseCollation();
                break;
            }
            case NCHAR: 
            case NVARCHAR: 
            case LONGNVARCHAR: 
            case NCLOB: {
                TDSType tDSType3 = tDSType = bl3 || bl4 ? TDSType.NVARCHAR : TDSType.NTEXT;
                if (null != sQLCollation) break;
                sQLCollation = this.con.getDatabaseCollation();
            }
        }
        this.writeRPCNameValType(string, bl, tDSType);
        if (bl4) {
            this.writeVMaxHeader(n2, bl2, sQLCollation);
            if (!bl2) {
                if (n2 > 0) {
                    this.writeInt(n2);
                    this.writeBytes(byArray);
                }
                this.writeInt(0);
            }
        } else {
            if (bl3) {
                this.writeShort((short)8000);
            } else {
                this.writeInt(Integer.MAX_VALUE);
            }
            if (null != sQLCollation) {
                sQLCollation.writeCollation(this);
            }
            if (bl2) {
                this.writeShort((short)-1);
            } else {
                if (bl3) {
                    this.writeShort((short)n2);
                } else {
                    this.writeInt(n2);
                }
                if (0 != n2) {
                    this.writeBytes(byArray);
                }
            }
        }
    }

    void writeRPCDateTime(String string, GregorianCalendar gregorianCalendar, int n2, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.DATETIMEN);
        this.writeByte((byte)8);
        if (null == gregorianCalendar) {
            this.writeByte((byte)0);
            return;
        }
        this.writeByte((byte)8);
        int n3 = DDC.daysSinceBaseDate(gregorianCalendar.get(1), gregorianCalendar.get(6), 1900);
        int n4 = (n2 + 500000) / 1000000 + 1000 * gregorianCalendar.get(13) + 60000 * gregorianCalendar.get(12) + 3600000 * gregorianCalendar.get(11);
        if (n4 >= 86399999) {
            ++n3;
            n4 = 0;
        }
        if (n3 < DDC.daysSinceBaseDate(1753, 1, 1900) || n3 >= DDC.daysSinceBaseDate(10000, 1, 1900)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueOutOfRange"));
            Object[] objectArray = new Object[]{SSType.DATETIME};
            throw new SQLServerException(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_DATETIME_FIELD_OVERFLOW, DriverError.NOT_SET, null);
        }
        this.writeInt(n3);
        this.writeInt((3 * n4 + 5) / 10);
    }

    void writeRPCTime(String string, GregorianCalendar gregorianCalendar, int n2, int n3, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.TIMEN);
        this.writeByte((byte)n3);
        if (null == gregorianCalendar) {
            this.writeByte((byte)0);
            return;
        }
        this.writeByte((byte)TDS.timeValueLength(n3));
        this.writeScaledTemporal(gregorianCalendar, n2, n3, SSType.TIME);
    }

    void writeRPCDate(String string, GregorianCalendar gregorianCalendar, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.DATEN);
        if (null == gregorianCalendar) {
            this.writeByte((byte)0);
            return;
        }
        this.writeByte((byte)3);
        this.writeScaledTemporal(gregorianCalendar, 0, 0, SSType.DATE);
    }

    void writeRPCDateTime2(String string, GregorianCalendar gregorianCalendar, int n2, int n3, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.DATETIME2N);
        this.writeByte((byte)n3);
        if (null == gregorianCalendar) {
            this.writeByte((byte)0);
            return;
        }
        this.writeByte((byte)TDS.datetime2ValueLength(n3));
        this.writeScaledTemporal(gregorianCalendar, n2, n3, SSType.DATETIME2);
    }

    void writeRPCDateTimeOffset(String string, GregorianCalendar gregorianCalendar, int n2, int n3, int n4, boolean bl) throws SQLServerException {
        assert (this.con.isKatmaiOrLater());
        this.writeRPCNameValType(string, bl, TDSType.DATETIMEOFFSETN);
        this.writeByte((byte)n4);
        if (null == gregorianCalendar) {
            this.writeByte((byte)0);
            return;
        }
        assert (0 == gregorianCalendar.get(15));
        this.writeByte((byte)TDS.datetimeoffsetValueLength(n4));
        this.writeScaledTemporal(gregorianCalendar, n3, n4, SSType.DATETIMEOFFSET);
        this.writeShort((short)n2);
    }

    private void writeScaledTemporal(GregorianCalendar gregorianCalendar, int n2, int n3, SSType sSType) throws SQLServerException {
        int n4;
        assert (SSType.DATE == sSType || SSType.TIME == sSType || SSType.DATETIME2 == sSType || SSType.DATETIMEOFFSET == sSType) : "Unexpected SSType: " + (Object)((Object)sSType);
        if (SSType.TIME == sSType || SSType.DATETIME2 == sSType || SSType.DATETIMEOFFSET == sSType) {
            long l2;
            assert (n2 >= 0);
            assert (n2 < 1000000000);
            assert (n3 >= 0);
            assert (n3 <= 7);
            n4 = gregorianCalendar.get(13) + 60 * gregorianCalendar.get(12) + 3600 * gregorianCalendar.get(11);
            long l3 = (long)Nanos.PER_MAX_SCALE_INTERVAL * (long)Math.pow(10.0, 7 - n3);
            if (86400000000000L / l3 == (l2 = (1000000000L * (long)n4 + (long)n2 + l3 / 2L) / l3)) {
                gregorianCalendar.add(13, 1);
                if (gregorianCalendar.get(1) <= 9999) {
                    l2 = 0L;
                } else {
                    gregorianCalendar.add(13, -1);
                    --l2;
                }
            }
            int n5 = TDS.nanosSinceMidnightLength(n3);
            byte[] byArray = new byte[n5];
            for (int i2 = 0; i2 < n5; ++i2) {
                byArray[i2] = (byte)(l2 >> 8 * i2 & 0xFFL);
            }
            this.writeBytes(byArray);
        }
        if (SSType.DATE == sSType || SSType.DATETIME2 == sSType || SSType.DATETIMEOFFSET == sSType) {
            if (gregorianCalendar.getTimeInMillis() < GregorianChange.STANDARD_CHANGE_DATE.getTime() || gregorianCalendar.getActualMaximum(6) < 365) {
                n4 = gregorianCalendar.get(1);
                int n6 = gregorianCalendar.get(2);
                int n7 = gregorianCalendar.get(5);
                gregorianCalendar.setGregorianChange(GregorianChange.PURE_CHANGE_DATE);
                gregorianCalendar.set(n4, n6, n7);
            }
            if ((n4 = DDC.daysSinceBaseDate(gregorianCalendar.get(1), gregorianCalendar.get(6), 1)) < 0 || n4 >= DDC.daysSinceBaseDate(10000, 1, 1)) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueOutOfRange"));
                Object[] objectArray = new Object[]{sSType};
                throw new SQLServerException(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_DATETIME_FIELD_OVERFLOW, DriverError.NOT_SET, null);
            }
            byte[] byArray = new byte[]{(byte)(n4 >> 0 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 >> 16 & 0xFF)};
            this.writeBytes(byArray);
        }
    }

    void writeRPCInputStream(String string, InputStream inputStream, long l2, boolean bl, JDBCType jDBCType, SQLCollation sQLCollation) throws SQLServerException {
        boolean bl2;
        assert (null != inputStream);
        assert (-1L == l2 || l2 >= 0L);
        boolean bl3 = bl2 = this.con.isYukonOrLater() && (-1L == l2 || l2 > 8000L);
        if (bl2) {
            assert (-1L == l2 || l2 <= Integer.MAX_VALUE);
            this.writeRPCNameValType(string, bl, jDBCType.isTextual() ? TDSType.BIGVARCHAR : TDSType.BIGVARBINARY);
            this.writeVMaxHeader(l2, false, jDBCType.isTextual() ? sQLCollation : null);
        } else {
            boolean bl4;
            if (-1L == l2) {
                Object object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8000);
                long l3 = 65535L * (long)this.con.getTDSPacketSize();
                try {
                    int n2;
                    object = new byte[8000];
                    for (l2 = 0L; l2 < l3 && -1 != (n2 = inputStream.read((byte[])object, 0, ((byte[])object).length)); l2 += (long)n2) {
                        byteArrayOutputStream.write((byte[])object);
                    }
                }
                catch (IOException iOException) {
                    throw new SQLServerException(iOException.getMessage(), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, (Throwable)iOException);
                }
                if (l2 >= l3) {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
                    Object[] objectArray = new Object[]{l2};
                    SQLServerException.makeFromDriverError(null, null, ((Format)object).format(objectArray), "", true);
                }
                assert (l2 <= Integer.MAX_VALUE);
                inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray(), 0, (int)l2);
            }
            assert (0L <= l2 && l2 <= Integer.MAX_VALUE);
            boolean bl5 = bl4 = l2 <= 8000L;
            this.writeRPCNameValType(string, bl, jDBCType.isTextual() ? (bl4 ? TDSType.BIGVARCHAR : TDSType.TEXT) : (bl4 ? TDSType.BIGVARBINARY : TDSType.IMAGE));
            if (bl4) {
                this.writeShort((short)8000);
                if (jDBCType.isTextual()) {
                    sQLCollation.writeCollation(this);
                }
                this.writeShort((short)l2);
            } else {
                this.writeInt(Integer.MAX_VALUE);
                if (jDBCType.isTextual()) {
                    sQLCollation.writeCollation(this);
                }
                this.writeInt((int)l2);
            }
        }
        this.writeStream(inputStream, l2, bl2);
    }

    void writeRPCXML(String string, InputStream inputStream, long l2, boolean bl) throws SQLServerException {
        assert (-1L == l2 || l2 >= 0L);
        assert (-1L == l2 || l2 <= Integer.MAX_VALUE);
        this.writeRPCNameValType(string, bl, TDSType.XML);
        this.writeByte((byte)0);
        if (null == inputStream) {
            this.writeLong(-1L);
        } else if (-1L == l2) {
            this.writeLong(-2L);
        } else {
            this.writeLong(l2);
        }
        if (null != inputStream) {
            this.writeStream(inputStream, l2, true);
        }
    }

    void writeRPCReaderUnicode(String string, Reader reader, long l2, boolean bl, SQLCollation sQLCollation) throws SQLServerException {
        boolean bl2;
        assert (null != reader);
        assert (-1L == l2 || l2 >= 0L);
        if (null == sQLCollation) {
            sQLCollation = this.con.getDatabaseCollation();
        }
        boolean bl3 = bl2 = this.con.isYukonOrLater() && (-1L == l2 || l2 > 4000L);
        if (bl2) {
            assert (-1L == l2 || l2 <= 0x3FFFFFFFL);
            this.writeRPCNameValType(string, bl, TDSType.NVARCHAR);
            this.writeVMaxHeader(-1L == l2 ? -1L : 2L * l2, false, sQLCollation);
        } else {
            assert (0L <= l2 && l2 <= 0x3FFFFFFFL);
            boolean bl4 = l2 <= 4000L;
            this.writeRPCNameValType(string, bl, bl4 ? TDSType.NVARCHAR : TDSType.NTEXT);
            if (bl4) {
                this.writeShort((short)8000);
                sQLCollation.writeCollation(this);
                this.writeShort((short)(2L * l2));
            } else {
                this.writeInt(0x3FFFFFFF);
                sQLCollation.writeCollation(this);
                this.writeInt((int)(2L * l2));
            }
        }
        this.writeReader(reader, l2, bl2);
    }
}

