/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

final class AsciiFilteredInputStream
extends InputStream {
    private final InputStream containedStream;
    private static final byte[] ASCII_FILTER;

    AsciiFilteredInputStream(BaseInputStream baseInputStream) throws SQLServerException {
        if (BaseInputStream.logger.isLoggable(Level.FINER)) {
            BaseInputStream.logger.finer(baseInputStream.toString() + " wrapping in AsciiFilteredInputStream");
        }
        this.containedStream = baseInputStream;
    }

    @Override
    public void close() throws IOException {
        this.containedStream.close();
    }

    @Override
    public long skip(long l2) throws IOException {
        return this.containedStream.skip(l2);
    }

    @Override
    public int available() throws IOException {
        return this.containedStream.available();
    }

    @Override
    public int read() throws IOException {
        int n2 = this.containedStream.read();
        if (n2 >= 0 && n2 <= 255) {
            return ASCII_FILTER[n2];
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n2 = this.containedStream.read(byArray);
        if (n2 > 0) {
            assert (n2 <= byArray.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = ASCII_FILTER[byArray[i2] & 0xFF];
            }
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.containedStream.read(byArray, n2, n3);
        if (n4 > 0) {
            assert (n2 + n4 <= byArray.length);
            for (int i2 = 0; i2 < n4; ++i2) {
                byArray[n2 + i2] = ASCII_FILTER[byArray[n2 + i2] & 0xFF];
            }
        }
        return n4;
    }

    @Override
    public boolean markSupported() {
        return this.containedStream.markSupported();
    }

    @Override
    public void mark(int n2) {
        this.containedStream.mark(n2);
    }

    @Override
    public void reset() throws IOException {
        this.containedStream.reset();
    }

    static {
        int n2;
        ASCII_FILTER = new byte[256];
        for (n2 = 0; n2 < 128; ++n2) {
            AsciiFilteredInputStream.ASCII_FILTER[n2] = (byte)n2;
        }
        for (n2 = 128; n2 < 256; ++n2) {
            AsciiFilteredInputStream.ASCII_FILTER[n2] = 63;
        }
    }
}

