/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.service.impl;

import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.client.utils.ParkClientCommonUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.park.bean.ParkProcessParameter;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkCloudService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterService;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.service.ParkTempBillingService;
import com.zkteco.zkbiosecurity.park.service.ParkVoiceViewService;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingMeterItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPavilioItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordoutItem;
import com.zkteco.zkbiosecurity.park.vo.ParkTempBillingItem;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkWechatResult {
    private static final Logger log = LoggerFactory.getLogger(ParkWechatResult.class);
    @Autowired
    private ParkParkingMeterService parkingMeterService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkTempBillingService tempBillingService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkCloudService parkCloudService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkVoiceViewService parkVoiceViewService;
    @Autowired
    private ParkPavilioService parkPavilioService;

    @Transactional
    public ZKResultMsg wechatResult(ZKMessage msg) {
        Map retMap = msg.getContent();
        String recordinId = retMap.get("checkinId").toString();
        String payType = retMap.get("payType").toString();
        String channelId = null;
        if (retMap.containsKey("channelId")) {
            channelId = retMap.get("channelId").toString();
        }
        if (this.parkParamsService.printParkLogger()) {
            log.info("PARK_ONLINE_PAY == Receiving Charge Result, RecordinId=" + recordinId + " ChannelId=" + channelId);
        }
        boolean operationMode = this.parkParamsService.isUnmanned();
        Short eventType = ParkConstants.EVENT_ONLINE_WXPAY;
        Short paymentMethod = ParkConstants.PAY_ONLINE_WXPAY;
        if ("ALIPAY".equals(payType)) {
            eventType = ParkConstants.EVENT_ONLINE_ALIPAY;
            paymentMethod = ParkConstants.PAY_ONLINE_ALIPAY;
        }
        ParkParkingMeterItem parkingMeterItem = null;
        ParkTempBillingItem tempBillingItem = this.tempBillingService.getByRecordinId(recordinId);
        if (operationMode && StringUtils.isNotBlank((CharSequence)channelId)) {
            ParkDeviceItem parkDeviceItem;
            int openRet;
            if (ParkClientCommonUtil.isNotNull(tempBillingItem)) {
                this.tempBillingService.deleteByIds(tempBillingItem.getId());
            }
            ParkRecordinItem recordinItem = this.parkRecordinService.getItemById(recordinId);
            recordinItem.setStatus(ParkConstants.CAR_STATUS_OUT);
            this.parkRecordinService.saveItem(recordinItem);
            parkingMeterItem = Objects.nonNull(tempBillingItem) ? this.parkingMeterService.getItemById(tempBillingItem.getParkingMeterId()) : this.parkingMeterService.getItemById(recordinItem.getParkingMeterId());
            parkingMeterItem.setPaymentMethod(paymentMethod);
            this.parkingMeterService.saveItem(parkingMeterItem);
            ParkRecordoutItem recordoutItem = this.parkRecordoutService.getItemById(parkingMeterItem.getRecordoutId());
            if (recordoutItem != null) {
                ParkProcessParameter parameter = new ParkProcessParameter();
                parameter.setLicense(recordoutItem.getCarNumber());
                parameter.setCheckinTime(recordinItem.getCheckInTime());
                parameter.setCheckoutTime(recordoutItem.getCheckOutTime());
                ParkPavilioItem parkPavilioItem = this.parkPavilioService.getItemById(recordoutItem.getParkPavilioId());
                parameter.setParkChannelId(channelId);
                if (parkPavilioItem != null) {
                    parameter.setPavilioIP(parkPavilioItem.getIpAddress());
                    this.parkRecordoutService.returnFrontResults("carInfo", "", recordoutItem.getCarTypeCode(), recordoutItem.getUserName(), parameter, recordoutItem.getEventType());
                }
            }
            if (0 != (openRet = this.parkRecordinService.openChannelGate(parkDeviceItem = this.parkDeviceService.getByChannelIdAndPriorities(channelId, ParkConstants.DEVICE_MASTER), null))) {
                log.info("ParkWechatResult >>> Open Gate failure ");
            }
            this.parkRecordinService.parkingLotIncr(recordinItem.getParkingAreaId());
            this.parkVoiceViewService.peace(parkDeviceItem, recordinItem.getCarNumber(), false, null);
            this.parkCloudService.sendCheckoutData(parkingMeterItem.getRecordoutId());
            this.parkRecordoutService.insertRecordinToSide(recordinId);
        } else {
            ParkRecordinItem recordinItem = null;
            if (ParkClientCommonUtil.isNotNull(tempBillingItem)) {
                tempBillingItem.setPaymentMethod(paymentMethod);
                ParkRecordinItem parkRecordinItem = this.parkRecordinService.getItemById(tempBillingItem.getRecordinId());
                tempBillingItem.setEventType(parkRecordinItem.getEventType());
                this.tempBillingService.saveItem(tempBillingItem);
                List recordinItemAry = this.parkRecordinService.getByCheckinIdAndStatus(recordinId, ParkConstants.CAR_STATUS_IN);
                recordinItem = ParkClientCommonUtil.isNotNull(recordinItemAry) ? (ParkRecordinItem)recordinItemAry.get(0) : parkRecordinItem;
            } else {
                List recordinItemAry = this.parkRecordinService.getByCheckinIdAndStatus(recordinId, ParkConstants.CAR_STATUS_IN);
                if (ParkClientCommonUtil.isNotNull(recordinItemAry)) {
                    recordinItem = (ParkRecordinItem)recordinItemAry.get(0);
                }
            }
            if (ParkClientCommonUtil.isNotNull(recordinItem)) {
                recordinItem.setEventType(eventType);
                this.parkRecordinService.saveItem(recordinItem);
                parkingMeterItem = this.parkingMeterService.getItemById(recordinItem.getParkingMeterId());
                parkingMeterItem.setPaymentMethod(paymentMethod);
                this.parkingMeterService.saveItem(parkingMeterItem);
            }
        }
        return ZKResultMsg.successMsg();
    }
}

