/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.cloud.sdk.FileItem;
import com.zkteco.cloud.sdk.bean.FileBean;
import com.zkteco.cloud.sdk.util.ZKCloudApiFileUploadUtil;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.client.utils.ParkClientCommonUtil;
import com.zkteco.zkbiosecurity.client.utils.ParkClientFTPUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ModelUtil;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.license.vo.bean.ModuleBean;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.bean.ParkWeChatCharge;
import com.zkteco.zkbiosecurity.park.bean.ParkWeChatRecordout;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkMessageSendService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterService;
import com.zkteco.zkbiosecurity.park.service.ParkPersonService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.service.ParkThirdPartyService;
import com.zkteco.zkbiosecurity.park.vo.ParkAuthorizeItem;
import com.zkteco.zkbiosecurity.park.vo.ParkBlackWhiteItem;
import com.zkteco.zkbiosecurity.park.vo.ParkCarNumberItem;
import com.zkteco.zkbiosecurity.park.vo.ParkCarTypeItem;
import com.zkteco.zkbiosecurity.park.vo.ParkChangeShiftsItem;
import com.zkteco.zkbiosecurity.park.vo.ParkChannelItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDailyReportItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkEntranceAreaItem;
import com.zkteco.zkbiosecurity.park.vo.ParkFinancialStatementsItem;
import com.zkteco.zkbiosecurity.park.vo.ParkFixedChargeItem;
import com.zkteco.zkbiosecurity.park.vo.ParkLevelRecordItem;
import com.zkteco.zkbiosecurity.park.vo.ParkMonthlyReportItem;
import com.zkteco.zkbiosecurity.park.vo.ParkOvertimeChargeExtendItem;
import com.zkteco.zkbiosecurity.park.vo.ParkOvertimeChargeItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingAreaItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingMeterItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingRemainingSpacesItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingSpaceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPavilioItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPersonItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordoutItem;
import com.zkteco.zkbiosecurity.park.vo.ParkShiftDefinitionItem;
import com.zkteco.zkbiosecurity.park.vo.ParkThirdPartyItem;
import com.zkteco.zkbiosecurity.park.vo.ParkWorkRecordItem;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ParkMessageSendServiceImpl
implements ParkMessageSendService {
    private static final Logger log = LoggerFactory.getLogger(ParkMessageSendServiceImpl.class);
    private static SaveSnapImageThread saveSnapImageThread;
    public static Map<String, String> saveSnapImageMap;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkPersonService parkPersonService;
    @Autowired
    private ParkParkingMeterService parkParkingMeterService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkThirdPartyService parkThirdPartyService;
    @Autowired(required=false)
    private BaseLicenseProvider baseLicenseProvider;
    @Autowired(required=false)
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired(required=false)
    private BaseLicenseService baseLicenseService;
    @Value(value="${cloud.server.file.url:https://zfs.xmzkteco.com}")
    private String cloudServerFileUrl;

    public String sendRecordinMsgs(String recordinId) {
        String msgId = "1";
        ModuleBean moduleBean = this.baseLicenseProvider.getModuleInfo("park");
        if (ParkClientCommonUtil.isNull(moduleBean) || moduleBean.isTrial() || !this.baseLicenseProvider.licenseAvaiable("park")) {
            log.info("Warn:------>ParkWebSocketWechatFun isTrial!!!");
            return "-1";
        }
        log.info("sendRecordinMsgs\uff1a" + recordinId);
        ParkRecordinItem recordinItem = this.parkRecordinService.getOne(recordinId);
        if (recordinItem != null) {
            recordinItem.setParkingLotName(this.parkParamsService.getParkingLotName());
            String photoPath = recordinItem.getPhotoPathIn();
            if (ParkClientCommonUtil.isNotNull(photoPath)) {
                if ("offine".equals(photoPath) || "fail".equals(photoPath) || "unMatch".equals(photoPath)) {
                    recordinItem.setPhotoPathIn(photoPath);
                } else {
                    saveSnapImageMap.put("in_" + recordinId, photoPath);
                    if (saveSnapImageThread == null || !saveSnapImageThread.isAlive()) {
                        saveSnapImageThread = new SaveSnapImageThread("ParkSaveSnapImageThread");
                        saveSnapImageThread.start();
                    }
                    recordinItem.setPhotoPathIn("");
                    String photoName = this.getPhotoName(photoPath);
                    recordinItem.setPhotoName(photoName);
                    if (this.isPhotoFtp()) {
                        recordinItem.setFtpPhotoPath(this.getFtpPath() + photoName);
                    }
                }
            }
            recordinItem.setCheckinId(recordinId);
            recordinItem.setParkingLotName(this.parkParamsService.getParkingLotName());
            ParkPersonItem parkPersonItem = this.parkPersonService.getByCarNumber(recordinItem.getCarNumber());
            if (ParkClientCommonUtil.isNotNull(parkPersonItem)) {
                recordinItem.setUserId(parkPersonItem.getId());
                recordinItem.setUserName(parkPersonItem.getPersPersonName());
                recordinItem.setUserPin(parkPersonItem.getPersPersonPin());
            }
            ZKMessage message = new ZKMessage();
            message.setModuleCode("park");
            message.setMessageId("parkCloudRecordinServiceImpl#receiveCheckinMsg");
            message.setContent(ParkClientCommonUtil.convertObjToMap(recordinItem));
            this.baseLicenseClientService.sendMessage(message);
        }
        return msgId;
    }

    public String sendRecordoutMsgs(String recordoutId) {
        String msgId = "1";
        ModuleBean moduleBean = this.baseLicenseProvider.getModuleInfo("park");
        if (ParkClientCommonUtil.isNull(moduleBean) || moduleBean.isTrial() || !this.baseLicenseProvider.licenseAvaiable("park")) {
            log.info("Warn:------>ParkWebSocketWechatFun isTrial!!!");
            return "-1";
        }
        log.info("sendRecordoutMsgs\uff1a" + recordoutId);
        ParkRecordoutItem recordoutItem = this.parkRecordoutService.getOne(recordoutId);
        ParkParkingMeterItem parkingMeterItem = this.parkParkingMeterService.getByRecordoutId(recordoutItem.getId());
        ParkWeChatRecordout wechatRecordout = new ParkWeChatRecordout();
        String checkinId = "";
        if (StringUtils.isNotBlank((CharSequence)recordoutItem.getRecordinId())) {
            ParkRecordinItem parkRecordinItem = this.parkRecordinService.getOne(recordoutItem.getRecordinId());
            if (Objects.nonNull(parkRecordinItem)) {
                checkinId = StringUtils.isNotBlank((CharSequence)parkRecordinItem.getCheckinId()) ? parkRecordinItem.getCheckinId() : parkRecordinItem.getId();
                wechatRecordout.setRecordinTime(parkRecordinItem.getCheckInTime());
                if (this.parkParamsService.printParkLogger()) {
                    log.info("sendRecordoutMsgs Recordin No Empty ParkRecordoutItem\uff1a{}", (Object)recordoutItem);
                }
            } else {
                log.info("sendRecordoutMsgs Recordin Empty ParkRecordoutItem\uff1a{}", (Object)recordoutItem);
            }
        }
        ModelUtil.copyPropertiesIgnoreNull((Object)recordoutItem, (Object)wechatRecordout);
        ModelUtil.copyPropertiesIgnoreNull((Object)parkingMeterItem, (Object)wechatRecordout);
        wechatRecordout.setEntranceAreaName(recordoutItem.getParkEntranceAreaName());
        wechatRecordout.setChannelName(recordoutItem.getChannelOutName());
        wechatRecordout.setCheckinId(checkinId);
        wechatRecordout.setParkRecordoutId(recordoutItem.getId());
        wechatRecordout.setParkParkingMeterId(parkingMeterItem.getId());
        wechatRecordout.setRecordoutTime(recordoutItem.getCheckOutTime());
        wechatRecordout.setParkingLotName(this.parkParamsService.getParkingLotName());
        ParkPersonItem parkPersonItem = this.parkPersonService.getByCarNumber(recordoutItem.getCarNumber());
        if (ParkClientCommonUtil.isNotNull(parkPersonItem)) {
            wechatRecordout.setUserId(parkPersonItem.getId());
            wechatRecordout.setUserName(parkPersonItem.getPersPersonName());
            wechatRecordout.setUserPin(parkPersonItem.getPersPersonPin());
        }
        wechatRecordout.setResource(Short.valueOf(recordoutItem.getRecordoutLogId() == null ? (short)0 : 1));
        String photoPath = recordoutItem.getPhotoPathOut();
        if (ParkClientCommonUtil.isNotNull(photoPath)) {
            if ("offine".equals(photoPath) || "fail".equals(photoPath) || "unMatch".equals(photoPath)) {
                wechatRecordout.setPhotoData(photoPath);
            } else {
                saveSnapImageMap.put("out_" + recordoutId, photoPath);
                if (saveSnapImageThread == null || !saveSnapImageThread.isAlive()) {
                    saveSnapImageThread = new SaveSnapImageThread("ParkSaveSnapImageThread");
                    saveSnapImageThread.start();
                }
                wechatRecordout.setPhotoData("");
                String photoName = this.getPhotoName(photoPath);
                wechatRecordout.setPhotoName(photoName);
                if (this.isPhotoFtp()) {
                    wechatRecordout.setFtpPhotoPath(this.getFtpPath() + photoName);
                }
            }
        }
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudRecordoutServiceImpl#receiveCheckoutMsg");
        message.setContent(ParkClientCommonUtil.convertObjToMap(wechatRecordout));
        this.baseLicenseClientService.sendMessage(message);
        return msgId;
    }

    public String sendParkingMeterData(String recordinId, String meterId) {
        String msgId = "1";
        ModuleBean moduleBean = this.baseLicenseProvider.getModuleInfo("park");
        if (ParkClientCommonUtil.isNull(moduleBean) || moduleBean.isTrial() || !this.baseLicenseProvider.licenseAvaiable("park")) {
            log.info("Warn:------>sendParkingMeterData isTrial!!!");
            return "-1";
        }
        ParkParkingMeterItem parkingMeterItem = this.parkParkingMeterService.getItemById(meterId);
        ParkWeChatRecordout wechatRecordout = new ParkWeChatRecordout();
        ModelUtil.copyPropertiesIgnoreNull((Object)parkingMeterItem, (Object)wechatRecordout);
        wechatRecordout.setCheckinId(recordinId);
        wechatRecordout.setParkParkingMeterId(parkingMeterItem.getId());
        wechatRecordout.setParkingLotName(this.parkParamsService.getParkingLotName());
        ParkPersonItem parkPersonItem = this.parkPersonService.getByCarNumber(parkingMeterItem.getCarNumber());
        if (ParkClientCommonUtil.isNotNull(parkPersonItem)) {
            wechatRecordout.setUserId(parkPersonItem.getId());
            wechatRecordout.setUserName(parkPersonItem.getPersPersonName());
        }
        wechatRecordout.setResource(Short.valueOf((short)0));
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudParkingMeterServiceImpl#receiveParkingMeter");
        message.setContent(ParkClientCommonUtil.convertObjToMap(wechatRecordout));
        this.baseLicenseClientService.sendMessage(message);
        return msgId;
    }

    public void sendUnattendedRet(ParkCheckOutInfo cheOutInfo) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudRecordinServiceImpl#receiveUnattendedRet");
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put("msgType", cheOutInfo.getMsgType());
        retMap.put("msgInfo", I18nUtil.i18nCode((String)cheOutInfo.getMsgInfo(), (Object[])new Object[0]));
        retMap.put("channelId", cheOutInfo.getParkChannelId());
        message.setContent(retMap);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendThirdParty(Map<String, Object> params) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudThirdPartyServiceImpl#receiveThirdParty");
        message.setContent(params);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendParkingFee(ParkWeChatCharge weChatCharge) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudParkingMeterServiceImpl#receiveChargeMsg");
        message.setContent(ParkClientCommonUtil.convertObjToMap(weChatCharge));
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendParkParams(Map<String, String> params) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudParamsServiceImpl#receiveParkParams");
        Map<String, String> properties = params;
        message.setContent(properties);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendCarType(List<ParkCarTypeItem> carTypeAry) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudCarTypeServiceImpl#receiveCarType");
        message.setListContent(carTypeAry);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delCarType(List<String> carTypeIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudCarTypeServiceImpl#delCarType");
        message.setListContent(carTypeIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendFixedCharge(List<ParkFixedChargeItem> items) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudFixedChargeServiceImpl#receiveFixedCharge");
        message.setListContent(items);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delFixedCharge(List<String> ids) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudFixedChargeServiceImpl#delFixedCharge");
        message.setListContent(ids);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendParkingArea(List<ParkParkingAreaItem> parkParkingAreaItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudParkingAreaServiceImpl#receiveParkingArea");
        message.setListContent(parkParkingAreaItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delParkingArea(List<String> areaIdAry) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudParkingAreaServiceImpl#delParkingArea");
        message.setListContent(areaIdAry);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendParkingSpace(List<ParkParkingSpaceItem> parkParkingSpaceItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudParkingSpaceServiceImpl#receiveParkingSpace");
        message.setListContent(parkParkingSpaceItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delParkingSpace(List<String> parkingSpaceIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudParkingSpaceServiceImpl#delParkingSpace");
        message.setListContent(parkingSpaceIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendEntranceArea(List<ParkEntranceAreaItem> entranceAreaAry) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudEntranceAreaServiceImpl#receiveEntranceArea");
        message.setListContent(entranceAreaAry);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendParkingRemainingSpace(ParkParkingRemainingSpacesItem parkingRemainingSpaces) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudParkingRemainingSpacesServiceImpl#receiveParkingLotSpacesNumber");
        message.setContent(ParkClientCommonUtil.convertObjToMap(parkingRemainingSpaces));
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delEntranceArea(List<String> entranceAreaIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudEntranceAreaServiceImpl#delEntranceArea");
        message.setListContent(entranceAreaIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendPerson(List<ParkPersonItem> parkPersonItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudPersonServiceImpl#receivePerson");
        message.setListContent(parkPersonItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delPerson(List<String> personIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudPersonServiceImpl#delPerson");
        message.setListContent(personIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendCarNumber(List<ParkCarNumberItem> parkCarNumberItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudCarNumberServiceImpl#receiveCarNumber");
        message.setListContent(parkCarNumberItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delCarNumber(List<String> carNumbers) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudCarNumberServiceImpl#delCarNumber");
        message.setListContent(carNumbers);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendAuthorize(List<ParkAuthorizeItem> parkAuthorizeItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudAuthorizeServiceImpl#receiveAuthorize");
        message.setListContent(parkAuthorizeItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delAuthorize(List<String> authorizeIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudAuthorizeServiceImpl#delAuthorize");
        message.setListContent(authorizeIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendLevelRecord(List<ParkLevelRecordItem> parkLevelRecordItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudAuthorizeRecordServiceImpl#receiveAuthorizeRecord");
        message.setListContent(parkLevelRecordItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendBlackWhite(List<ParkBlackWhiteItem> parkBlackWhiteItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudBlackWhiteServiceImpl#receiveBlackWhite");
        message.setListContent(parkBlackWhiteItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delBlackWhite(List<String> blackWhiteIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudBlackWhiteServiceImpl#delBlackWhite");
        message.setListContent(blackWhiteIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendDevice(List<ParkDeviceItem> parkDeviceItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudDeviceServiceImpl#receiveDevice");
        message.setListContent(parkDeviceItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delDevice(List<String> deviceIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudDeviceServiceImpl#delDevice");
        message.setListContent(deviceIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendPavilio(List<ParkPavilioItem> parkPavilioItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudPavilioServiceImpl#receivePavilio");
        message.setListContent(parkPavilioItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delPavilio(List<String> pavilioIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudPavilioServiceImpl#delPavilio");
        message.setListContent(pavilioIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendChannel(List<ParkChannelItem> parkChannelItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudChannelServiceImpl#receiveChannel");
        message.setListContent(parkChannelItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delChannel(List<String> channelIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudChannelServiceImpl#delChannel");
        message.setListContent(channelIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendDailyReport(ParkDailyReportItem dailyReportItem) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        dailyReportItem.setParkingLotName(this.parkParamsService.getParkingLotName());
        message.setMessageId("parkCloudDailyReportServiceImpl#receiveDailyReport");
        message.setContent(ParkClientCommonUtil.convertObjToMap(dailyReportItem));
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendMonthlyReport(ParkMonthlyReportItem monthlyReportItem) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        monthlyReportItem.setParkingLotName(this.parkParamsService.getParkingLotName());
        message.setMessageId("parkCloudMonthlyReportServiceImpl#receiveMonthlyReport");
        message.setContent(ParkClientCommonUtil.convertObjToMap(monthlyReportItem));
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendOvertimeCharge(List<ParkOvertimeChargeItem> parkOvertimeChargeItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudOvertimeChargeServiceImpl#receiveOvertimeCharge");
        message.setListContent(parkOvertimeChargeItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delOvertimeCharge(List<String> overtimeChargeIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudOvertimeChargeServiceImpl#delOvertimeCharge");
        message.setListContent(overtimeChargeIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendOvertimeChargeExtend(List<ParkOvertimeChargeExtendItem> parkOvertimeChargeExtendItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudOvertimeChargeExtendServiceImpl#receiveOvertimeChargeExtend");
        message.setListContent(parkOvertimeChargeExtendItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delOvertimeChargeExtend(List<String> overtimeChargeExtendIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudOvertimeChargeExtendServiceImpl#delOvertimeChargeExtend");
        message.setListContent(overtimeChargeExtendIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendChangeShifts(List<ParkChangeShiftsItem> parkChangeShiftsItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudChangeShiftsServiceImpl#receiveChangeShifts");
        message.setListContent(parkChangeShiftsItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delChangeShifts(List<String> changeShiftsIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudChangeShiftsServiceImpl#delChangeShifts");
        message.setListContent(changeShiftsIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendFinancialStatements(List<ParkFinancialStatementsItem> parkFinancialStatementsItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudFinancialStatementsServiceImpl#receiveFinancialStatements");
        message.setListContent(parkFinancialStatementsItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delFinancialStatements(List<String> financialStatementsIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudFinancialStatementsServiceImpl#delFinancialStatements");
        message.setListContent(financialStatementsIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendShiftDefinition(List<ParkShiftDefinitionItem> parkShiftDefinitionItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudShiftDefinitionServiceImpl#receiveShiftDefinition");
        message.setListContent(parkShiftDefinitionItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delShiftDefinition(List<String> shiftDefinitionIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudShiftDefinitionServiceImpl#delShiftDefinition");
        message.setListContent(shiftDefinitionIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendWorkRecord(List<ParkWorkRecordItem> parkWorkRecordItemList) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudWorkRecordServiceImpl#receiveWorkRecord");
        message.setListContent(parkWorkRecordItemList);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void delWorkRecord(List<String> workRecordIds) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudWorkRecordServiceImpl#delWorkRecord");
        message.setListContent(workRecordIds);
        this.baseLicenseClientService.sendMessage(message);
    }

    public void sendParkingLot(ParkCheckOutInfo cheOutInfo) {
        ZKMessage message = new ZKMessage();
        message.setModuleCode("park");
        message.setMessageId("parkCloudParkingLotServiceImpl#receiveParkingLot");
        String lotCount = this.parkCacheService.getStr("park:parkingLot_" + cheOutInfo.getAreaId());
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put("currParkingLot", cheOutInfo.getParkLot());
        retMap.put("allParkingLot", lotCount);
        retMap.put("parkParkingAreaId", cheOutInfo.getAreaId());
        message.setContent(retMap);
        this.baseLicenseClientService.sendMessage(message);
    }

    private ZKResultMsg upload(String photoPath, String filePath, String fileId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        try {
            FileBean fileBean = new FileBean();
            fileBean.setModuleName("park");
            fileBean.setAppId(this.baseLicenseService.getAppId());
            fileBean.setAppKey(this.parkParamsService.getAppKey());
            fileBean.setCloudServerFileUrl(this.cloudServerFileUrl);
            fileBean.setFile(new FileItem(photoPath));
            String body = ZKCloudApiFileUploadUtil.upload((FileBean)fileBean).getBody();
            JSONObject respData = JSON.parseObject((String)body);
            if ("ok".equals(respData.getString("ret"))) {
                zkResultMsg.setData((Object)respData.getString("data"));
                zkResultMsg.setMsg(respData.getString("msg"));
                zkResultMsg.setRet(respData.getString("ret"));
            } else {
                zkResultMsg.setData((Object)"upload fail");
                zkResultMsg.setRet("fail");
            }
        }
        catch (Exception e) {
            zkResultMsg.setData((Object)"upload fail");
            zkResultMsg.setRet("fail");
            log.error("Exception", (Throwable)e);
        }
        return zkResultMsg;
    }

    private boolean isPhotoFtp() {
        boolean isPhotoFtp = false;
        if (this.parkParamsService.isEnableThirdParty()) {
            String province;
            ParkThirdPartyItem condition = new ParkThirdPartyItem();
            condition.setParamKey("province");
            List parkThirdPartyItemList = this.parkThirdPartyService.getByCondition(condition);
            if (parkThirdPartyItemList != null && !parkThirdPartyItemList.isEmpty() && "DongGuan".equals(province = ((ParkThirdPartyItem)parkThirdPartyItemList.get(0)).getParamValue())) {
                isPhotoFtp = true;
            }
        }
        return isPhotoFtp;
    }

    private String getFtpPath() {
        return this.baseLicenseService.getAppId() + "/" + ParkClientCommonUtil.getDatePhotoPath() + "/";
    }

    private String getPhotoName(String photoPath) {
        return photoPath.substring(photoPath.lastIndexOf("\\") + 1, photoPath.length());
    }

    static {
        saveSnapImageMap = new ConcurrentHashMap<String, String>();
    }

    class SaveSnapImageThread
    extends Thread {
        private volatile boolean stop = false;

        SaveSnapImageThread(String threadName) {
            super.setName(threadName);
        }

        public void stopThread() {
            Thread thisThread = Thread.currentThread();
            this.stop = true;
            thisThread.interrupt();
        }

        @Override
        public void run() {
            while (!this.stop) {
                Set<String> keySet = saveSnapImageMap.keySet();
                if (keySet.size() > 0) {
                    for (String key : keySet) {
                        String photoPath = saveSnapImageMap.get(key);
                        if (ParkClientCommonUtil.fileExists(photoPath)) {
                            String[] idAry = key.split("_");
                            String newPhotoPath = ParkClientCommonUtil.createZoomImage(photoPath);
                            this.sendPhotoData(idAry[0], idAry[1], newPhotoPath);
                            if (ParkMessageSendServiceImpl.this.isPhotoFtp()) {
                                this.sendPhotoDataToFtp(photoPath);
                            }
                            saveSnapImageMap.remove(key);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                this.stopThread();
            }
        }

        private void sendPhotoData(String state, String recordId, String photoPath) {
            ZKMessage message = new ZKMessage();
            message.setModuleCode("park");
            if ("in".equals(state)) {
                message.setMessageId("parkCloudRecordinServiceImpl#receiveCheckinPhotoData");
            } else if ("out".equals(state)) {
                message.setMessageId("parkCloudRecordoutServiceImpl#receiveCheckoutPhotoData");
            }
            String filePath = "parkCloud/" + ParkMessageSendServiceImpl.this.baseLicenseService.getAppId() + "/" + ParkClientCommonUtil.getDatePhotoPath();
            ZKResultMsg zkResultMsg = ParkMessageSendServiceImpl.this.upload(photoPath, filePath, recordId);
            String photoData = zkResultMsg.getData().toString();
            HashMap<String, String> reMap = new HashMap<String, String>();
            reMap.put("recordId", recordId);
            reMap.put("photoData", photoData);
            message.setContent(reMap);
            ParkMessageSendServiceImpl.this.baseLicenseClientService.sendMessage(message);
        }

        private void sendPhotoDataToFtp(String photoPath) {
            try {
                Map map = ParkMessageSendServiceImpl.this.parkThirdPartyService.getParams();
                if (map != null) {
                    ParkClientFTPUtil.connect(ParkMessageSendServiceImpl.this.getFtpPath(), (String)map.get("ftpIP"), 21, (String)map.get("ftpUserName"), (String)map.get("ftpPassWord"));
                    File file = new File(ParkClientCommonUtil.getSystemFilePath() + photoPath);
                    ParkClientFTPUtil.upload(file);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

