/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.client.utils.ParkClientCommonUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.park.service.ParkAuthorizeDelayService;
import com.zkteco.zkbiosecurity.park.service.ParkAuthorizeService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkPersonService;
import com.zkteco.zkbiosecurity.park.vo.ParkAuthorizeItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPersonItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkAuthorizeHandle {
    private static final Logger log = LoggerFactory.getLogger(ParkAuthorizeHandle.class);
    @Autowired
    private ParkAuthorizeDelayService parkAuthorizeDelayService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkPersonService parkPersonService;
    @Autowired
    private ParkAuthorizeService parkAuthorizeService;

    public ZKResultMsg authorizeDelay(ZKMessage msg) {
        log.info("PARK_CLOUD ParkAuthorizeHandle authorizeDelay msg = {}", (Object)msg);
        Map retMap = msg.getContent();
        String parkAuthorizeId = retMap.get("parkAuthorizeId").toString();
        String parkParkingSpaceId = null;
        if (retMap.containsKey("parkParkingSpaceId")) {
            parkParkingSpaceId = retMap.get("parkParkingSpaceId").toString();
        }
        Double debt = Double.valueOf(retMap.get("debt").toString());
        Date endTime = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat(DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
            String endTimeStr = format.format(Long.valueOf(retMap.get("endTime").toString()));
            endTime = format.parse(endTimeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (this.parkParamsService.printParkLogger()) {
            log.info("PARK_CLOUD == Receiving AuthorizeDelay: parkAuthorizeId=" + parkAuthorizeId + " debt=" + debt);
        }
        this.parkAuthorizeDelayService.authorizeDelay(parkAuthorizeId, parkParkingSpaceId, debt, endTime);
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg getByAppIdAndPin(ZKMessage msg) {
        log.info("PARK_CLOUD ParkAuthorizeHandle getByAppIdAndPin msg = {}", (Object)msg);
        Map retMap = msg.getContent();
        String pin = ParkClientCommonUtil.getStringValue(retMap, "pin");
        ParkAuthorizeItem item = new ParkAuthorizeItem();
        item.setCarTypeCodeNot("tempA");
        if (StringUtils.isNotBlank((CharSequence)pin)) {
            ParkPersonItem parkPersonItem = this.parkPersonService.getByPin(pin);
            if (parkPersonItem != null) {
                item.setPersPersonPin(pin);
            } else {
                return new ZKResultMsg(null);
            }
        }
        List list = this.parkAuthorizeService.getByCondition(item);
        return new ZKResultMsg((Object)list);
    }

    public ZKResultMsg getPagerByAppIdAndPin(ZKMessage msg) {
        log.info("PARK_CLOUD ParkAuthorizeHandle getPagerByAppIdAndPin msg = {}", (Object)msg);
        Map retMap = msg.getContent();
        String pin = ParkClientCommonUtil.getStringValue(retMap, "pin");
        int page = ParkClientCommonUtil.getIntValue(retMap, "page");
        int size = ParkClientCommonUtil.getIntValue(retMap, "size");
        JSONObject json = (JSONObject)retMap.get("parkCloudAuthorizeItem");
        ParkAuthorizeItem parkAuthorizeItem = (ParkAuthorizeItem)JSONObject.toJavaObject((JSON)json, ParkAuthorizeItem.class);
        parkAuthorizeItem.setCarTypeCodeNot("tempA");
        if (StringUtils.isNotBlank((CharSequence)pin)) {
            ParkPersonItem parkPersonItem = this.parkPersonService.getByPin(pin);
            if (parkPersonItem != null) {
                parkAuthorizeItem.setPersPersonId(parkPersonItem.getPersPersonId());
            } else {
                return new ZKResultMsg(null);
            }
        }
        Pager pager = this.parkAuthorizeService.getItemsByPageForApp(parkAuthorizeItem, page, size);
        return new ZKResultMsg((Object)pager);
    }
}

